/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.instrument;

import com.alibaba.bytekit.agent.inst.Instrument;
import com.alibaba.bytekit.asm.instrument.DefineConfig;
import com.alibaba.bytekit.asm.instrument.InstrumentConfig;
import com.alibaba.bytekit.asm.instrument.InstrumentParseResult;
import com.alibaba.bytekit.asm.matcher.ClassMatcher;
import com.alibaba.bytekit.asm.matcher.SimpleClassMatcher;
import com.alibaba.bytekit.asm.matcher.SimpleInterfaceMatcher;
import com.alibaba.bytekit.asm.matcher.SimpleSubclassMatcher;
import com.alibaba.bytekit.log.Logger;
import com.alibaba.bytekit.log.Loggers;
import com.alibaba.bytekit.utils.AsmAnnotationUtils;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.bytekit.utils.IOUtils;
import com.alibaba.bytekit.utils.Pair;
import com.alibaba.bytekit.utils.PropertiesUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.ClassNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class InstrumentTemplate {
    private final Logger logger = Loggers.getLogger(this.getClass());
    public static final String INSTRUMENT_PROPERTIES = "instrument.properties";
    public static final String INSTRUMENT = "instrument";
    public static final String TRIGGER_RETRANSFORM = "triggerRetransform";
    public static final String DEFINE = "define";
    private List<File> jarFiles = new ArrayList<File>();
    private List<byte[]> instrumentClassList = new ArrayList<byte[]>();
    private List<byte[]> defineClassList = new ArrayList<byte[]>();

    public InstrumentTemplate(File ... jarFiles) {
        for (File file : jarFiles) {
            this.jarFiles.add(file);
        }
    }

    public void addJarFiles(Collection<File> jarFiles) {
        this.jarFiles.addAll(jarFiles);
    }

    public void addJarFile(File jarFile) {
        this.jarFiles.add(jarFile);
    }

    public void addInstrumentClass(byte[] classBytes) {
        this.instrumentClassList.add(classBytes);
    }

    public void addDefineClass(byte[] classBytes) {
        this.defineClassList.add(classBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentParseResult build() throws IOException {
        InstrumentParseResult result = new InstrumentParseResult();
        for (File file : this.jarFiles) {
            JarFile jarFile;
            block12: {
                jarFile = null;
                try {
                    Iterator<Pair<String, byte[]>> configKey;
                    jarFile = new JarFile(file);
                    JarEntry propertiesEntry = jarFile.getJarEntry(INSTRUMENT_PROPERTIES);
                    if (propertiesEntry == null) break block12;
                    InputStream inputStream2 = jarFile.getInputStream(propertiesEntry);
                    Properties properties = PropertiesUtils.loadNotNull(inputStream2);
                    String triggerRetransformValue = properties.getProperty(TRIGGER_RETRANSFORM, "false");
                    boolean triggerRetransform = Boolean.parseBoolean(triggerRetransformValue);
                    HashMap<Iterator<Pair<String, byte[]>>, List<Pair<String, byte[]>>> instrumentMap = new HashMap<Iterator<Pair<String, byte[]>>, List<Pair<String, byte[]>>>();
                    HashMap<Iterator<Pair<String, byte[]>>, List<Pair<String, byte[]>>> defineMap = new HashMap<Iterator<Pair<String, byte[]>>, List<Pair<String, byte[]>>>();
                    for (String string : properties.stringPropertyNames()) {
                        List<Pair<String, byte[]>> classBytesList;
                        if (string.startsWith("instrument.")) {
                            configKey = string.substring("instrument.".length());
                            classBytesList = this.readClassBytes(properties, string, jarFile);
                            if (classBytesList.isEmpty()) continue;
                            instrumentMap.put(configKey, classBytesList);
                            continue;
                        }
                        if (string.startsWith("define.")) {
                            configKey = string.substring("define.".length());
                            classBytesList = this.readClassBytes(properties, string, jarFile);
                            if (classBytesList.isEmpty()) continue;
                            defineMap.put(configKey, classBytesList);
                            continue;
                        }
                        if (string.equals(INSTRUMENT)) {
                            for (Pair<String, byte[]> pair : this.readClassBytes(properties, INSTRUMENT, jarFile)) {
                                this.parse(result, (byte[])pair.second, triggerRetransform, null);
                            }
                            continue;
                        }
                        if (!string.equals(DEFINE)) continue;
                        for (Pair<String, byte[]> pair : this.readClassBytes(properties, DEFINE, jarFile)) {
                            result.addDefineClass((String)pair.first, (byte[])pair.second);
                        }
                    }
                    for (Map.Entry entry : instrumentMap.entrySet()) {
                        configKey = (String)entry.getKey();
                        List defineClassList = (List)defineMap.get(configKey);
                        for (Pair instrumentPair : (List)entry.getValue()) {
                            this.parse(result, (byte[])instrumentPair.second, triggerRetransform, defineClassList);
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.close(jarFile);
                    throw throwable;
                }
            }
            IOUtils.close(jarFile);
        }
        for (byte[] classBytes : this.instrumentClassList) {
            this.parse(result, classBytes, false, null);
        }
        return result;
    }

    private List<Pair<String, byte[]>> readClassBytes(Properties properties, String key, JarFile jarFile) throws IOException {
        ArrayList<Pair<String, byte[]>> result = new ArrayList<Pair<String, byte[]>>();
        String value = properties.getProperty(key);
        ArrayList<String> classes = new ArrayList<String>();
        if (value != null) {
            String[] strings;
            for (String s2 : strings = value.split(",")) {
                if ((s2 = s2.trim()).isEmpty()) continue;
                classes.add(s2);
            }
        }
        for (String clazz : classes) {
            JarEntry classEntry = jarFile.getJarEntry(clazz.replace('.', '/') + ".class");
            if (classEntry == null) continue;
            byte[] classBytes = IOUtils.getBytes(jarFile.getInputStream(classEntry));
            result.add(Pair.of(clazz, classBytes));
        }
        return result;
    }

    private void parse(InstrumentParseResult result, byte[] classBytes, boolean triggerRetransform, List<Pair<String, byte[]>> defineClassList) {
        List<String> matchInterfaceList;
        List<String> matchSuperclassList;
        ClassNode classNode = AsmUtils.toClassNode(classBytes);
        if (!AsmUtils.fitCurrentJvmMajorVersion(classNode)) {
            this.logger.error("The current jvm major version is {}, less than the Instrument class major version: {}, ignore this class: {}", AsmUtils.currentJvmMajorVersion(), AsmUtils.getMajorVersion(classNode.version), classNode.name);
            return;
        }
        AsmUtils.removeLineNumbers(classNode);
        boolean updateMajorVersion = Boolean.parseBoolean((String)AsmAnnotationUtils.queryAnnotationValue(classNode.visibleAnnotations, Type.getDescriptor(Instrument.class), "updateMajorVersion"));
        List<String> matchClassList = AsmAnnotationUtils.queryAnnotationArrayValue(classNode.visibleAnnotations, Type.getDescriptor(Instrument.class), "Class");
        if (matchClassList != null && !matchClassList.isEmpty()) {
            SimpleClassMatcher classMatcher = new SimpleClassMatcher(matchClassList);
            InstrumentConfig config = new InstrumentConfig(classNode, classMatcher, updateMajorVersion, triggerRetransform);
            this.addDefineConfigs(config, defineClassList);
            result.addInstrumentConfig(config);
        }
        if (!(matchSuperclassList = AsmAnnotationUtils.queryAnnotationArrayValue(classNode.visibleAnnotations, Type.getDescriptor(Instrument.class), "Superclass")).isEmpty()) {
            SimpleSubclassMatcher matcher = new SimpleSubclassMatcher(matchSuperclassList);
            InstrumentConfig config = new InstrumentConfig(classNode, matcher, updateMajorVersion, triggerRetransform);
            this.addDefineConfigs(config, defineClassList);
            result.addInstrumentConfig(config);
        }
        if (!(matchInterfaceList = AsmAnnotationUtils.queryAnnotationArrayValue(classNode.visibleAnnotations, Type.getDescriptor(Instrument.class), "Interface")).isEmpty()) {
            SimpleInterfaceMatcher matcher = new SimpleInterfaceMatcher(matchInterfaceList);
            InstrumentConfig config = new InstrumentConfig(classNode, matcher, updateMajorVersion, triggerRetransform);
            this.addDefineConfigs(config, defineClassList);
            result.addInstrumentConfig(config);
        }
    }

    private void addDefineConfigs(InstrumentConfig config, List<Pair<String, byte[]>> defineClassList) {
        if (defineClassList != null && !defineClassList.isEmpty()) {
            for (Pair<String, byte[]> pair : defineClassList) {
                config.addDefineConfig(new DefineConfig((byte[])pair.second, (String)pair.first));
            }
        }
    }

    public static List<Class<?>> matchedClass(Instrumentation instrumentation, InstrumentConfig instrumentConfig) {
        ArrayList result = new ArrayList();
        ClassMatcher classMatcher = instrumentConfig.getClassMatcher();
        for (Class clazz : instrumentation.getAllLoadedClasses()) {
            if (!classMatcher.match(null, clazz.getName(), clazz, null, null)) continue;
            result.add(clazz);
        }
        return result;
    }
}

