/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.server.http;

import com.alibaba.arthas.nat.agent.core.JvmAttachmentHandler;
import com.alibaba.arthas.nat.agent.core.ListJvmProcessHandler;
import com.alibaba.arthas.nat.agent.core.MonitorTargetPidHandler;
import com.alibaba.arthas.nat.agent.server.dto.JavaProcessInfoDTO;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;

public class HttpNativeAgentHandler {
    private static final String OPERATION_KEY = "operation";
    private static final String PID_KEY = "pid";
    private static final String LIST_PROCESS_OPERATION = "listProcess";
    private static final String ATTACH_JVM_OPERATION = "attachJvm";
    private static final String MONITOR_OPERATION = "monitor";

    public FullHttpResponse handle(ChannelHandlerContext ctx, FullHttpRequest request) {
        String content = request.content().toString(StandardCharsets.UTF_8);
        FullHttpResponse resp = null;
        Map<String, Object> bodyMap = JSON.parseObject(content, new TypeReference<Map<String, Object>>(){}, new JSONReader.Feature[0]);
        String operation = (String)bodyMap.get(OPERATION_KEY);
        Integer pid = (Integer)bodyMap.get(PID_KEY);
        if (LIST_PROCESS_OPERATION.equals(operation)) {
            resp = this.doListProcess(ctx, request);
        }
        if (ATTACH_JVM_OPERATION.equals(operation)) {
            resp = this.doAttachJvm(ctx, request, pid);
        }
        if (MONITOR_OPERATION.equals(operation)) {
            resp = this.doMonitor(ctx, request, pid);
        }
        return resp;
    }

    private FullHttpResponse doMonitor(ChannelHandlerContext ctx, FullHttpRequest request, Integer pid) {
        boolean monitorSuccess = MonitorTargetPidHandler.monitorTargetPid(pid);
        String attachSuccessPid = monitorSuccess ? pid + "" : "-1";
        DefaultFullHttpResponse response = this.buildHttpCorsResponse(attachSuccessPid);
        return response;
    }

    private FullHttpResponse doAttachJvm(ChannelHandlerContext ctx, FullHttpRequest request, Integer pid) {
        String httpPort = "";
        try {
            httpPort = JvmAttachmentHandler.attachJvmByPid(pid);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String attachSuccessMsg = httpPort;
        DefaultFullHttpResponse response = this.buildHttpCorsResponse(attachSuccessMsg);
        return response;
    }

    private FullHttpResponse doListProcess(ChannelHandlerContext ctx, FullHttpRequest request) {
        Map<Long, String> processMap = null;
        try {
            processMap = ListJvmProcessHandler.listJvmProcessByInvoke();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ArrayList javaProcessInfoList = new ArrayList();
        if (processMap != null) {
            processMap.forEach((pid, applicationName) -> {
                if (!"".equals(applicationName.replace(pid + " ", ""))) {
                    javaProcessInfoList.add(new JavaProcessInfoDTO(applicationName.replace(pid + " ", ""), pid.intValue()));
                }
            });
        }
        String processJson = JSON.toJSONString(javaProcessInfoList);
        DefaultFullHttpResponse response = this.buildHttpCorsResponse(processJson);
        return response;
    }

    public DefaultFullHttpResponse buildHttpCorsResponse(String msg) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer(msg.getBytes(CharsetUtil.UTF_8)));
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, (Object)"GET, POST, PUT, DELETE, OPTIONS");
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE, (Object)3600L);
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, (Object)"Content-Type, Authorization, X-Requested-With, Accept, Origin");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        return response;
    }
}

