/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.registry.impl;

import com.alibaba.arthas.nat.agent.registry.NativeAgentRegistry;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperNativeAgentRegistry
implements NativeAgentRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperNativeAgentRegistry.class);
    private static CountDownLatch latch = new CountDownLatch(1);
    private static final int SESSION_TIMEOUT = 15000;

    @Override
    public void registerNativeAgent(String address, String k, String v) {
        ZooKeeper zk = null;
        AtomicBoolean createResult = new AtomicBoolean(false);
        try {
            zk = new ZooKeeper(address, 15000, event -> {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    latch.countDown();
                    createResult.compareAndSet(false, true);
                }
            });
            latch.await();
        }
        catch (Exception e) {
            logger.error("Create zookeeper client failed");
            throw new RuntimeException(e);
        }
        finally {
            latch.countDown();
        }
        if (!createResult.get()) {
            throw new RuntimeException("Create zookeeper client failed");
        }
        try {
            if (zk.exists("/native-agent", false) == null) {
                zk.create("/native-agent", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            String path = zk.create("/native-agent/" + k, v.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            logger.info("native agent client registered at: " + path);
        }
        catch (InterruptedException | KeeperException e) {
            logger.error("Register native agent client failed");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

