/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.readline.functions;

import io.termd.core.readline.Function;
import io.termd.core.readline.LineBuffer;
import io.termd.core.readline.Readline;

public class BackwardWord
implements Function {
    @Override
    public String name() {
        return "backward-word";
    }

    @Override
    public void apply(Readline.Interaction interaction) {
        LineBuffer buf = interaction.buffer().copy();
        buf.setCursor(BackwardWord.findPos(buf));
        interaction.refresh(buf);
        interaction.resume();
    }

    static int findPos(LineBuffer buf) {
        int codePoint;
        int prev;
        int cursor = buf.getCursor();
        while ((prev = cursor - 1) >= 0 && !Character.isLetterOrDigit(codePoint = buf.getAt(prev))) {
            --cursor;
        }
        while ((prev = cursor - 1) >= 0 && Character.isLetterOrDigit(codePoint = buf.getAt(prev))) {
            --cursor;
        }
        return cursor;
    }
}

