/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http;

import com.taobao.arthas.core.shell.term.impl.http.LocalTtyServerInitializer;
import com.taobao.arthas.core.shell.term.impl.http.TtyServerInitializer;
import com.taobao.arthas.core.shell.term.impl.http.session.HttpSessionManager;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.termd.core.function.Consumer;
import io.termd.core.tty.TtyConnection;
import io.termd.core.util.CompletableFuture;
import io.termd.core.util.Helper;

public class NettyWebsocketTtyBootstrap {
    private final ChannelGroup channelGroup = new DefaultChannelGroup(ImmediateEventExecutor.INSTANCE);
    private String host;
    private int port;
    private EventLoopGroup group;
    private Channel channel;
    private EventExecutorGroup workerGroup;
    private HttpSessionManager httpSessionManager;

    public NettyWebsocketTtyBootstrap(EventExecutorGroup workerGroup, HttpSessionManager httpSessionManager) {
        this.workerGroup = workerGroup;
        this.host = "localhost";
        this.port = 8080;
        this.httpSessionManager = httpSessionManager;
    }

    public String getHost() {
        return this.host;
    }

    public NettyWebsocketTtyBootstrap setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NettyWebsocketTtyBootstrap setPort(int port) {
        this.port = port;
        return this;
    }

    public void start(Consumer<TtyConnection> handler, final Consumer<Throwable> doneHandler) {
        this.group = new NioEventLoopGroup(new DefaultThreadFactory("arthas-NettyWebsocketTtyBootstrap", true));
        if (this.port > 0) {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group(this.group).channel(NioServerSocketChannel.class)).handler(new LoggingHandler(LogLevel.INFO))).childHandler(new TtyServerInitializer(this.channelGroup, handler, this.workerGroup, this.httpSessionManager));
            final ChannelFuture f = b.bind(this.host, this.port);
            f.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){
                final /* synthetic */ NettyWebsocketTtyBootstrap this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void operationComplete(Future<? super Void> future) throws Exception {
                    if (future.isSuccess()) {
                        this.this$0.channel = f.channel();
                        doneHandler.accept(null);
                    } else {
                        doneHandler.accept(future.cause());
                    }
                }
            });
        }
        ServerBootstrap b2 = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b2.group(this.group).channel(LocalServerChannel.class)).handler(new LoggingHandler(LogLevel.INFO))).childHandler(new LocalTtyServerInitializer(this.channelGroup, handler, this.workerGroup));
        ChannelFuture bindLocalFuture = b2.bind(new LocalAddress("arthas-netty-LocalAddress"));
        if (this.port < 0) {
            bindLocalFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){
                final /* synthetic */ NettyWebsocketTtyBootstrap this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void operationComplete(Future<? super Void> future) throws Exception {
                    if (future.isSuccess()) {
                        doneHandler.accept(null);
                    } else {
                        doneHandler.accept(future.cause());
                    }
                }
            });
        }
    }

    public CompletableFuture<Void> start(Consumer<TtyConnection> handler) {
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        this.start(handler, Helper.startedHandler(fut));
        return fut;
    }

    public void stop(final Consumer<Throwable> doneHandler) {
        if (this.channel != null) {
            this.channel.close();
        }
        this.channelGroup.close().addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){
            final /* synthetic */ NettyWebsocketTtyBootstrap this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void operationComplete(Future<? super Void> future) throws Exception {
                try {
                    doneHandler.accept(future.cause());
                }
                finally {
                    this.this$0.group.shutdownGracefully();
                }
            }
        });
    }

    public CompletableFuture<Void> stop() {
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        this.stop(Helper.stoppedHandler(fut));
        return fut;
    }
}

