/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.tunnel.client.LocalFrameHandler;
import com.alibaba.arthas.tunnel.client.RelayHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardClientSocketClientHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(ForwardClientSocketClientHandler.class);
    private ChannelPromise handshakeFuture;

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        logger.info("WebSocket Client disconnected!");
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt.equals((Object)WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE)) {
            try {
                this.connectLocalServer(ctx);
            }
            catch (Throwable e) {
                logger.error("ForwardClientSocketClientHandler connect local arthas server error", e);
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectLocalServer(final ChannelHandlerContext ctx) throws InterruptedException, URISyntaxException {
        block5: {
            NioEventLoopGroup group;
            block4: {
                group = new NioEventLoopGroup(1, new DefaultThreadFactory("arthas-forward-client-connect-local", true));
                ChannelFuture closeFuture = null;
                try {
                    logger.info("ForwardClientSocketClientHandler star connect local arthas server");
                    WebSocketClientProtocolConfig clientProtocolConfig = WebSocketClientProtocolConfig.newBuilder().webSocketUri("ws://127.0.0.1:8563/ws").maxFramePayloadLength(0xA00000).build();
                    final WebSocketClientProtocolHandler websocketClientHandler = new WebSocketClientProtocolHandler(clientProtocolConfig);
                    final LocalFrameHandler localFrameHandler = new LocalFrameHandler();
                    Bootstrap b = new Bootstrap();
                    b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000);
                    ((Bootstrap)((Bootstrap)b.group(group)).channel(LocalChannel.class)).handler(new ChannelInitializer<LocalChannel>(this){
                        final /* synthetic */ ForwardClientSocketClientHandler this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        protected void initChannel(LocalChannel ch) {
                            ChannelPipeline p = ch.pipeline();
                            p.addLast(new HttpClientCodec(), new HttpObjectAggregator(0xA00000), websocketClientHandler, localFrameHandler);
                        }
                    });
                    LocalAddress localAddress = new LocalAddress("arthas-netty-LocalAddress");
                    Channel localChannel = b.connect(localAddress).sync().channel();
                    this.handshakeFuture = localFrameHandler.handshakeFuture();
                    this.handshakeFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<ChannelFuture>(){
                        final /* synthetic */ ForwardClientSocketClientHandler this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            ChannelPipeline pipeline = future.channel().pipeline();
                            pipeline.remove(localFrameHandler);
                            pipeline.addLast(new RelayHandler(ctx.channel()));
                        }
                    });
                    this.handshakeFuture.sync();
                    ctx.pipeline().remove(this);
                    ctx.pipeline().addLast(new RelayHandler(localChannel));
                    logger.info("ForwardClientSocketClientHandler connect local arthas server success");
                    closeFuture = localChannel.closeFuture();
                    if (closeFuture == null) break block4;
                    closeFuture.addListener(new ChannelFutureListener(){
                        final /* synthetic */ EventLoopGroup val$group;
                        final /* synthetic */ ForwardClientSocketClientHandler this$0;
                        {
                            this.val$group = eventLoopGroup;
                            this.this$0 = this$0;
                        }

                        @Override
                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            this.val$group.shutdownGracefully();
                        }
                    });
                }
                catch (Throwable throwable) {
                    if (closeFuture != null) {
                        closeFuture.addListener(new /* invalid duplicate definition of identical inner class */);
                    } else {
                        group.shutdownGracefully();
                    }
                    throw throwable;
                }
                break block5;
            }
            group.shutdownGracefully();
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) {
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("ForwardClientSocketClient channel: {}", (Object)ctx.channel(), (Object)cause);
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
    }
}

