/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.core;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArthasHomeHandler {
    private static final Logger logger = LoggerFactory.getLogger(ArthasHomeHandler.class);
    public static File ARTHAS_HOME_DIR;

    public static void findArthasHome() {
        File arthasHomeDir = null;
        try {
            if (arthasHomeDir == null) {
                File arthasDir = new File(System.getProperty("user.home"), ".arthas" + File.separator + "lib" + File.separator + "arthas");
                ArthasHomeHandler.verifyArthasHome(arthasDir.getAbsolutePath());
                arthasHomeDir = arthasDir;
            }
        }
        catch (Exception arthasDir) {
            // empty catch block
        }
        try {
            URL jarUrl;
            if (arthasHomeDir == null && (jarUrl = ArthasHomeHandler.class.getProtectionDomain().getCodeSource().getLocation()) != null) {
                File arthasDir = new File(jarUrl.toURI());
                String jarDir = arthasDir.getParent();
                ArthasHomeHandler.verifyArthasHome(jarDir);
                if (arthasDir != null) {
                    arthasHomeDir = new File(jarDir);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (arthasHomeDir == null) {
            logger.error("Please ensure that arthas-native agent-client is in the same directory as arthas-core.jar, arthas-agent.jar, and arthas-spy.jar");
            throw new RuntimeException("arthas home not found");
        }
        ARTHAS_HOME_DIR = arthasHomeDir;
    }

    private static void verifyArthasHome(String arthasHome) {
        File home = new File(arthasHome);
        if (home.isDirectory()) {
            String[] fileList;
            for (String fileName : fileList = new String[]{"arthas-core.jar", "arthas-agent.jar", "arthas-spy.jar"}) {
                if (new File(home, fileName).exists()) continue;
                logger.error("Please ensure that arthas-native agent-client is in the same directory as arthas-core.jar, arthas-agent.jar, and arthas-spy.jar");
                throw new IllegalArgumentException(fileName + " do not exist, arthas home: " + home.getAbsolutePath());
            }
            return;
        }
        throw new IllegalArgumentException("illegal arthas home: " + home.getAbsolutePath());
    }
}

