/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import sun.jvmstat.perfdata.monitor.SyntaxException;

public class AliasFileParser {
    private static final String ALIAS = "alias";
    private static final boolean DEBUG = false;
    private URL inputfile;
    private StreamTokenizer st;
    private Token currentToken;

    AliasFileParser(URL inputfile) {
        this.inputfile = inputfile;
    }

    private void logln(String s2) {
    }

    private void nextToken() throws IOException {
        this.st.nextToken();
        this.currentToken = new Token(this.st.ttype, this.st.sval);
        this.logln("Read token: type = " + this.currentToken.ttype + " string = " + this.currentToken.sval);
    }

    private void match(int ttype, String token) throws IOException, SyntaxException {
        if (this.currentToken.ttype != ttype || this.currentToken.sval.compareTo(token) != 0) {
            throw new SyntaxException(this.st.lineno());
        }
        this.logln("matched type: " + ttype + " and token = " + this.currentToken.sval);
        this.nextToken();
    }

    private void match(int ttype) throws IOException, SyntaxException {
        if (this.currentToken.ttype != ttype) {
            throw new SyntaxException(this.st.lineno());
        }
        this.logln("matched type: " + ttype + ", token = " + this.currentToken.sval);
        this.nextToken();
    }

    private void match(String token) throws IOException, SyntaxException {
        this.match(-3, token);
    }

    public void parse(Map<String, ArrayList<String>> map) throws SyntaxException, IOException {
        if (this.inputfile == null) {
            return;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(this.inputfile.openStream()));
        this.st = new StreamTokenizer(r);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.wordChars(95, 95);
        this.nextToken();
        while (this.currentToken.ttype != -1) {
            if (this.currentToken.ttype != -3 || this.currentToken.sval.compareTo(ALIAS) != 0) {
                this.nextToken();
                continue;
            }
            this.match(ALIAS);
            String name = this.currentToken.sval;
            this.match(-3);
            ArrayList<String> aliases = new ArrayList<String>();
            do {
                aliases.add(this.currentToken.sval);
                this.match(-3);
            } while (this.currentToken.ttype != -1 && this.currentToken.sval.compareTo(ALIAS) != 0);
            this.logln("adding map entry for " + name + " values = " + aliases);
            map.put(name, aliases);
        }
    }

    private class Token {
        public String sval;
        public int ttype;

        public Token(int ttype, String sval) {
            this.ttype = ttype;
            this.sval = sval;
        }
    }
}

