/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.logger;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import java.lang.reflect.Field;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LogbackHelper {
    private static boolean Logback = false;
    private static Field headField;
    private static Field lengthOptionField;
    private static ILoggerFactory loggerFactoryInstance;

    public static Boolean updateLevel(String name, String level) {
        if (Logback) {
            try {
                Level l = Level.toLevel((String)level, (Level)Level.ERROR);
                LoggerContext loggerContext = (LoggerContext)loggerFactoryInstance;
                Logger logger = loggerContext.exists(name);
                if (logger != null) {
                    logger.setLevel(l);
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
        return null;
    }

    public static Map<String, Map<String, Object>> getLoggers(String name, boolean includeNoAppender) {
        LinkedHashMap<String, Map<String, Object>> loggerInfoMap = new LinkedHashMap<String, Map<String, Object>>();
        if (Logback) {
            LoggerContext loggerContext = (LoggerContext)loggerFactoryInstance;
            if (name != null && !name.trim().isEmpty()) {
                Logger logger = loggerContext.exists(name);
                if (logger != null) {
                    loggerInfoMap.put(name, LogbackHelper.doGetLoggerInfo(logger));
                }
            } else {
                List loggers = loggerContext.getLoggerList();
                for (Logger logger : loggers) {
                    Map<String, Object> info = LogbackHelper.doGetLoggerInfo(logger);
                    if (!includeNoAppender) {
                        List appenders = (List)info.get("appenders");
                        if (appenders == null || appenders.isEmpty()) continue;
                        loggerInfoMap.put(logger.getName(), info);
                        continue;
                    }
                    loggerInfoMap.put(logger.getName(), info);
                }
            }
        }
        return loggerInfoMap;
    }

    private static Map<String, Object> doGetLoggerInfo(Logger logger) {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        info.put("name", logger.getName());
        info.put("class", logger.getClass());
        CodeSource codeSource = logger.getClass().getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            info.put("codeSource", codeSource.getLocation());
        }
        info.put("additivity", logger.isAdditive());
        Level level = logger.getLevel();
        Level effectiveLevel = logger.getEffectiveLevel();
        if (level != null) {
            info.put("level", level.toString());
        }
        if (effectiveLevel != null) {
            info.put("effectiveLevel", effectiveLevel.toString());
        }
        List<Map<String, Object>> result = LogbackHelper.doGetLoggerAppenders(logger.iteratorForAppenders());
        info.put("appenders", result);
        return info;
    }

    private static List<Map<String, Object>> doGetLoggerAppenders(Iterator<Appender<ILoggingEvent>> appenders) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        while (appenders.hasNext()) {
            LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
            Appender<ILoggingEvent> appender = appenders.next();
            info.put("name", appender.getName());
            info.put("class", appender.getClass());
            if (appender instanceof FileAppender) {
                info.put("file", ((FileAppender)appender).getFile());
            } else if (appender instanceof AsyncAppender) {
                AsyncAppender aa = (AsyncAppender)appender;
                Iterator iter = aa.iteratorForAppenders();
                List<Map<String, Object>> asyncs = LogbackHelper.doGetLoggerAppenders(iter);
                ArrayList<String> appenderRef = new ArrayList<String>();
                for (Map<String, Object> a : asyncs) {
                    appenderRef.add((String)a.get("name"));
                    result.add(a);
                }
                info.put("appenderRef", appenderRef);
                info.put("blocking", !aa.isNeverBlock());
            } else if (appender instanceof ConsoleAppender) {
                info.put("target", ((ConsoleAppender)appender).getTarget());
            }
            result.add(info);
        }
        return result;
    }

    static {
        try {
            ILoggerFactory loggerFactory;
            Class<?> loggerClass = LogbackHelper.class.getClassLoader().loadClass("ch.qos.logback.classic.Logger");
            if (loggerClass.getClassLoader().equals(LogbackHelper.class.getClassLoader()) && (loggerFactory = LoggerFactory.getILoggerFactory()) instanceof LoggerContext) {
                loggerFactoryInstance = loggerFactory;
                headField = PatternLayoutBase.class.getDeclaredField("head");
                headField.setAccessible(true);
                lengthOptionField = ThrowableProxyConverter.class.getDeclaredField("lengthOption");
                lengthOptionField.setAccessible(true);
                Logback = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

