/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.io.PrintWriter;
import java.io.Serializable;
import ognl.Evaluation;
import ognl.EvaluationPool;
import ognl.InappropriateExpressionException;
import ognl.Node;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlParser;
import ognl.OgnlParserTreeConstants;
import ognl.OgnlRuntime;
import ognl.enhance.ExpressionAccessor;

public abstract class SimpleNode
implements Node,
Serializable {
    private static final long serialVersionUID = 996864654828982683L;
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected OgnlParser parser;
    private boolean constantValueCalculated;
    private volatile boolean hasConstantValue;
    private Object constantValue;
    private ExpressionAccessor expressionAccessor;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(OgnlParser p, int i) {
        this(i);
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return OgnlParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + OgnlParserTreeConstants.jjtNodeName[this.id] + " " + this;
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        return this.toString();
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        return this.toString();
    }

    public void dump(PrintWriter writer, String prefix) {
        writer.println(this.toString(prefix));
        if (this.children != null) {
            for (Node child : this.children) {
                SimpleNode n = (SimpleNode)child;
                if (n == null) continue;
                n.dump(writer, prefix + "  ");
            }
        }
    }

    public int getIndexInParent() {
        int result = -1;
        if (this.parent != null) {
            int icount = this.parent.jjtGetNumChildren();
            for (int i = 0; i < icount; ++i) {
                if (this.parent.jjtGetChild(i) != this) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public Node getNextSibling() {
        int icount;
        Node result = null;
        int i = this.getIndexInParent();
        if (i >= 0 && i < (icount = this.parent.jjtGetNumChildren())) {
            result = this.parent.jjtGetChild(i + 1);
        }
        return result;
    }

    protected Object evaluateGetValueBody(OgnlContext context, Object source2) throws OgnlException {
        context.setCurrentObject(source2);
        context.setCurrentNode(this);
        if (!this.constantValueCalculated) {
            this.constantValueCalculated = true;
            boolean constant = this.isConstant(context);
            if (constant) {
                this.constantValue = this.getValueBody(context, source2);
            }
            this.hasConstantValue = constant;
        }
        return this.hasConstantValue ? this.constantValue : this.getValueBody(context, source2);
    }

    protected void evaluateSetValueBody(OgnlContext context, Object target, Object value) throws OgnlException {
        context.setCurrentObject(target);
        context.setCurrentNode(this);
        this.setValueBody(context, target, value);
    }

    @Override
    public final Object getValue(OgnlContext context, Object source2) throws OgnlException {
        Object result = null;
        if (context.isTraceEvaluations()) {
            EvaluationPool pool = OgnlRuntime.getEvaluationPool();
            Exception evalException = null;
            Evaluation evaluation = pool.create(this, source2);
            context.pushEvaluation(evaluation);
            try {
                result = this.evaluateGetValueBody(context, source2);
            }
            catch (RuntimeException | OgnlException ex) {
                evalException = ex;
                throw ex;
            }
            finally {
                Evaluation eval = context.popEvaluation();
                eval.setResult(result);
                if (evalException != null) {
                    eval.setException(evalException);
                }
            }
        } else {
            result = this.evaluateGetValueBody(context, source2);
        }
        return result;
    }

    protected abstract Object getValueBody(OgnlContext var1, Object var2) throws OgnlException;

    @Override
    public final void setValue(OgnlContext context, Object target, Object value) throws OgnlException {
        if (context.isTraceEvaluations()) {
            EvaluationPool pool = OgnlRuntime.getEvaluationPool();
            Exception evalException = null;
            Evaluation evaluation = pool.create(this, target, true);
            context.pushEvaluation(evaluation);
            try {
                this.evaluateSetValueBody(context, target, value);
            }
            catch (OgnlException ex) {
                evalException = ex;
                ex.setEvaluation(evaluation);
                throw ex;
            }
            catch (RuntimeException ex) {
                evalException = ex;
                throw ex;
            }
            finally {
                Evaluation eval = context.popEvaluation();
                if (evalException != null) {
                    eval.setException(evalException);
                }
            }
        } else {
            this.evaluateSetValueBody(context, target, value);
        }
    }

    protected void setValueBody(OgnlContext context, Object target, Object value) throws OgnlException {
        throw new InappropriateExpressionException(this);
    }

    public boolean isNodeConstant(OgnlContext context) throws OgnlException {
        return false;
    }

    public boolean isConstant(OgnlContext context) throws OgnlException {
        return this.isNodeConstant(context);
    }

    public boolean isNodeSimpleProperty(OgnlContext context) throws OgnlException {
        return false;
    }

    public boolean isSimpleProperty(OgnlContext context) throws OgnlException {
        return this.isNodeSimpleProperty(context);
    }

    public boolean isSimpleNavigationChain(OgnlContext context) throws OgnlException {
        return this.isSimpleProperty(context);
    }

    public boolean isEvalChain(OgnlContext context) throws OgnlException {
        if (this.children == null) {
            return false;
        }
        for (Node child : this.children) {
            if (!(child instanceof SimpleNode) || !((SimpleNode)child).isEvalChain(context)) continue;
            return true;
        }
        return false;
    }

    public boolean isSequence(OgnlContext context) throws OgnlException {
        if (this.children == null) {
            return false;
        }
        for (Node child : this.children) {
            if (!(child instanceof SimpleNode) || !((SimpleNode)child).isSequence(context)) continue;
            return true;
        }
        return false;
    }

    public boolean isOperation(OgnlContext context) throws OgnlException {
        if (this.children == null) {
            return false;
        }
        for (Node child : this.children) {
            if (!(child instanceof SimpleNode) || !((SimpleNode)child).isOperation(context)) continue;
            return true;
        }
        return false;
    }

    public boolean isChain(OgnlContext context) throws OgnlException {
        if (this.children == null) {
            return false;
        }
        for (Node child : this.children) {
            if (!(child instanceof SimpleNode) || !((SimpleNode)child).isChain(context)) continue;
            return true;
        }
        return false;
    }

    public boolean isSimpleMethod(OgnlContext context) throws OgnlException {
        return false;
    }

    protected boolean lastChild(OgnlContext context) {
        return this.parent == null || context.get("_lastChild") != null;
    }

    protected void flattenTree() {
        boolean shouldFlatten = false;
        int newSize = 0;
        for (Node child : this.children) {
            if (child.getClass() == this.getClass()) {
                shouldFlatten = true;
                newSize += child.jjtGetNumChildren();
                continue;
            }
            ++newSize;
        }
        if (shouldFlatten) {
            Node[] newChildren = new Node[newSize];
            int j = 0;
            for (Node c : this.children) {
                if (c.getClass() == this.getClass()) {
                    for (int k = 0; k < c.jjtGetNumChildren(); ++k) {
                        newChildren[j++] = c.jjtGetChild(k);
                    }
                    continue;
                }
                newChildren[j++] = c;
            }
            if (j != newSize) {
                throw new Error("Assertion error: " + j + " != " + newSize);
            }
            this.children = newChildren;
        }
    }

    @Override
    public ExpressionAccessor getAccessor() {
        return this.expressionAccessor;
    }

    @Override
    public void setAccessor(ExpressionAccessor accessor) {
        this.expressionAccessor = accessor;
    }
}

