/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.ClassResolver;
import ognl.DefaultClassResolver;
import ognl.DefaultTypeConverter;
import ognl.Evaluation;
import ognl.MemberAccess;
import ognl.Node;
import ognl.OgnlOps;
import ognl.TypeConverter;
import ognl.enhance.LocalReference;

public class OgnlContext
implements Map<String, Object> {
    private static final String ROOT_CONTEXT_KEY = "root";
    private static final String THIS_CONTEXT_KEY = "this";
    private static final String TRACE_EVALUATIONS_CONTEXT_KEY = "_traceEvaluations";
    private static final String LAST_EVALUATION_CONTEXT_KEY = "_lastEvaluation";
    private static final String KEEP_LAST_EVALUATION_CONTEXT_KEY = "_keepLastEvaluation";
    private static final String PROPERTY_KEY_PREFIX = "ognl";
    private static boolean DEFAULT_TRACE_EVALUATIONS = false;
    private static boolean DEFAULT_KEEP_LAST_EVALUATION = false;
    private static final Map<String, Object> RESERVED_KEYS = new HashMap<String, Object>(6);
    private Object root;
    private Object currentObject;
    private Node currentNode;
    private boolean traceEvaluations = DEFAULT_TRACE_EVALUATIONS;
    private Evaluation rootEvaluation;
    private Evaluation currentEvaluation;
    private Evaluation lastEvaluation;
    private boolean keepLastEvaluation = DEFAULT_KEEP_LAST_EVALUATION;
    private final Map<String, Object> internalContext;
    private final ClassResolver classResolver;
    private final TypeConverter typeConverter;
    private final MemberAccess memberAccess;
    private final List<Class<?>> typeStack = new ArrayList(3);
    private final List<Class<?>> accessorStack = new ArrayList(3);
    private int localReferenceCounter = 0;
    private Map<String, LocalReference> localReferenceMap = null;

    public OgnlContext(ClassResolver classResolver, TypeConverter typeConverter, MemberAccess memberAccess) {
        this(memberAccess, classResolver, typeConverter, null);
    }

    public OgnlContext(MemberAccess memberAccess, ClassResolver classResolver, TypeConverter typeConverter, OgnlContext initialContext) {
        this.classResolver = classResolver != null ? classResolver : new DefaultClassResolver();
        this.typeConverter = typeConverter != null ? typeConverter : new DefaultTypeConverter();
        if (memberAccess == null) {
            throw new IllegalArgumentException("MemberAccess implementation must be provided - null not permitted!");
        }
        this.memberAccess = memberAccess;
        this.internalContext = new HashMap<String, Object>(23);
        if (initialContext != null) {
            this.internalContext.putAll(initialContext.internalContext);
        }
    }

    public void setValues(Map<Object, Object> values2) {
        for (Object k : values2.keySet()) {
            this.internalContext.put(k.toString(), values2.get(k));
        }
    }

    public OgnlContext withValues(Map<Object, Object> values2) {
        this.setValues(values2);
        return this;
    }

    public Map<?, Object> getValues() {
        return this.internalContext;
    }

    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public MemberAccess getMemberAccess() {
        return this.memberAccess;
    }

    public void setRoot(Object value) {
        this.root = value;
        this.accessorStack.clear();
        this.typeStack.clear();
        this.currentObject = value;
        if (this.currentObject != null) {
            this.setCurrentType(this.currentObject.getClass());
        }
    }

    public Object getRoot() {
        return this.root;
    }

    @Deprecated
    public boolean getTraceEvaluations() {
        return this.isTraceEvaluations();
    }

    public boolean isTraceEvaluations() {
        return this.traceEvaluations;
    }

    public void setTraceEvaluations(boolean value) {
        this.traceEvaluations = value;
    }

    public Evaluation getLastEvaluation() {
        return this.lastEvaluation;
    }

    public void setLastEvaluation(Evaluation value) {
        this.lastEvaluation = value;
    }

    @Deprecated
    public boolean getKeepLastEvaluation() {
        return this.isKeepLastEvaluation();
    }

    public boolean isKeepLastEvaluation() {
        return this.keepLastEvaluation;
    }

    public void setKeepLastEvaluation(boolean value) {
        this.keepLastEvaluation = value;
    }

    public void setCurrentObject(Object value) {
        this.currentObject = value;
    }

    public Object getCurrentObject() {
        return this.currentObject;
    }

    public void setCurrentAccessor(Class<?> type) {
        this.accessorStack.add(type);
    }

    public Class<?> getCurrentAccessor() {
        if (this.accessorStack.isEmpty()) {
            return null;
        }
        return this.accessorStack.get(this.accessorStack.size() - 1);
    }

    public Class<?> getPreviousAccessor() {
        if (this.accessorStack.isEmpty()) {
            return null;
        }
        if (this.accessorStack.size() > 1) {
            return this.accessorStack.get(this.accessorStack.size() - 2);
        }
        return null;
    }

    public Class<?> getFirstAccessor() {
        if (this.accessorStack.isEmpty()) {
            return null;
        }
        return this.accessorStack.get(0);
    }

    public Class<?> getCurrentType() {
        if (this.typeStack.isEmpty()) {
            return null;
        }
        return this.typeStack.get(this.typeStack.size() - 1);
    }

    public void setCurrentType(Class<?> type) {
        this.typeStack.add(type);
    }

    public Class<?> getPreviousType() {
        if (this.typeStack.isEmpty()) {
            return null;
        }
        if (this.typeStack.size() > 1) {
            return this.typeStack.get(this.typeStack.size() - 2);
        }
        return null;
    }

    public void setPreviousType(Class<?> type) {
        if (this.typeStack.isEmpty() || this.typeStack.size() < 2) {
            return;
        }
        this.typeStack.set(this.typeStack.size() - 2, type);
    }

    public Class<?> getFirstType() {
        if (this.typeStack.isEmpty()) {
            return null;
        }
        return this.typeStack.get(0);
    }

    public void setCurrentNode(Node value) {
        this.currentNode = value;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public Evaluation getCurrentEvaluation() {
        return this.currentEvaluation;
    }

    public void setCurrentEvaluation(Evaluation value) {
        this.currentEvaluation = value;
    }

    public Evaluation getRootEvaluation() {
        return this.rootEvaluation;
    }

    public void setRootEvaluation(Evaluation value) {
        this.rootEvaluation = value;
    }

    public Evaluation getEvaluation(int relativeIndex) {
        Evaluation result = null;
        if (relativeIndex <= 0) {
            for (result = this.currentEvaluation; ++relativeIndex < 0 && result != null; result = result.getParent()) {
            }
        }
        return result;
    }

    public void pushEvaluation(Evaluation value) {
        if (this.currentEvaluation != null) {
            this.currentEvaluation.addChild(value);
        } else {
            this.setRootEvaluation(value);
        }
        this.setCurrentEvaluation(value);
    }

    public Evaluation popEvaluation() {
        Evaluation result = this.currentEvaluation;
        this.setCurrentEvaluation(result.getParent());
        if (this.currentEvaluation == null) {
            this.setLastEvaluation(this.isKeepLastEvaluation() ? result : null);
            this.setRootEvaluation(null);
            this.setCurrentNode(null);
        }
        return result;
    }

    public int incrementLocalReferenceCounter() {
        return ++this.localReferenceCounter;
    }

    public void addLocalReference(String key, LocalReference reference) {
        if (this.localReferenceMap == null) {
            this.localReferenceMap = new LinkedHashMap<String, LocalReference>();
        }
        this.localReferenceMap.put(key, reference);
    }

    public Map<String, LocalReference> getLocalReferences() {
        return this.localReferenceMap;
    }

    @Override
    public int size() {
        return this.internalContext.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalContext.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalContext.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalContext.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        Object result;
        if (key == null) {
            return null;
        }
        String strKey = key.toString();
        if (RESERVED_KEYS.containsKey(strKey)) {
            switch (strKey) {
                case "this": {
                    result = this.getCurrentObject();
                    break;
                }
                case "root": {
                    result = this.getRoot();
                    break;
                }
                case "_traceEvaluations": {
                    result = this.isTraceEvaluations() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case "_lastEvaluation": {
                    result = this.getLastEvaluation();
                    break;
                }
                case "_keepLastEvaluation": {
                    result = this.isKeepLastEvaluation() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown reserved key '" + key + "'");
                }
            }
        } else {
            result = this.internalContext.get(key);
        }
        return result;
    }

    @Override
    public Object put(String key, Object value) {
        Object result;
        if (RESERVED_KEYS.containsKey(key)) {
            switch (key) {
                case "this": {
                    result = this.getCurrentObject();
                    this.setCurrentObject(value);
                    break;
                }
                case "root": {
                    result = this.getRoot();
                    this.setRoot(value);
                    break;
                }
                case "_traceEvaluations": {
                    result = this.isTraceEvaluations() ? Boolean.TRUE : Boolean.FALSE;
                    this.setTraceEvaluations(OgnlOps.booleanValue(value));
                    break;
                }
                case "_lastEvaluation": {
                    result = this.getLastEvaluation();
                    this.lastEvaluation = (Evaluation)value;
                    break;
                }
                case "_keepLastEvaluation": {
                    result = this.isKeepLastEvaluation() ? Boolean.TRUE : Boolean.FALSE;
                    this.setKeepLastEvaluation(OgnlOps.booleanValue(value));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown reserved key '" + key + "'");
                }
            }
        } else {
            result = this.internalContext.put(key, value);
        }
        return result;
    }

    @Override
    public Object remove(Object key) {
        Object result;
        if (key == null) {
            return this.internalContext.remove(key);
        }
        String strKey = key.toString();
        if (RESERVED_KEYS.containsKey(strKey)) {
            switch (strKey) {
                case "this": {
                    result = this.getCurrentObject();
                    this.setCurrentObject(null);
                    break;
                }
                case "root": {
                    result = this.getRoot();
                    this.setRoot(null);
                    break;
                }
                case "_traceEvaluations": {
                    throw new IllegalArgumentException("Can't remove _traceEvaluations from context");
                }
                case "_lastEvaluation": {
                    result = this.lastEvaluation;
                    this.setLastEvaluation(null);
                    break;
                }
                case "_keepLastEvaluation": {
                    throw new IllegalArgumentException("Can't remove _keepLastEvaluation from context");
                }
                default: {
                    throw new IllegalArgumentException("Unknown reserved key '" + key + "'");
                }
            }
        } else {
            result = this.internalContext.remove(key);
        }
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ?> t) {
        for (Map.Entry<String, ?> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.internalContext.clear();
        this.typeStack.clear();
        this.accessorStack.clear();
        this.localReferenceCounter = 0;
        if (this.localReferenceMap != null) {
            this.localReferenceMap.clear();
        }
        this.setRoot(null);
        this.setCurrentObject(null);
        this.setRootEvaluation(null);
        this.setCurrentEvaluation(null);
        this.setLastEvaluation(null);
        this.setCurrentNode(null);
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.internalContext.keySet());
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.internalContext.values());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.internalContext.entrySet());
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OgnlContext)) {
            return false;
        }
        OgnlContext otherContext = (OgnlContext)other;
        return this.internalContext.equals(otherContext.internalContext);
    }

    @Override
    public int hashCode() {
        return this.internalContext.hashCode();
    }

    static {
        RESERVED_KEYS.put(ROOT_CONTEXT_KEY, null);
        RESERVED_KEYS.put(THIS_CONTEXT_KEY, null);
        RESERVED_KEYS.put(TRACE_EVALUATIONS_CONTEXT_KEY, null);
        RESERVED_KEYS.put(LAST_EVALUATION_CONTEXT_KEY, null);
        RESERVED_KEYS.put(KEEP_LAST_EVALUATION_CONTEXT_KEY, null);
        try {
            String property = System.getProperty("ognl.traceEvaluations");
            if (property != null) {
                DEFAULT_TRACE_EVALUATIONS = Boolean.parseBoolean(property.trim());
            }
            if ((property = System.getProperty("ognl.keepLastEvaluation")) != null) {
                DEFAULT_KEEP_LAST_EVALUATION = Boolean.parseBoolean(property.trim());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

