/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.ArrayElementsAccessor;
import ognl.ArrayPropertyAccessor;
import ognl.ClassCacheInspector;
import ognl.CollectionElementsAccessor;
import ognl.ElementsAccessor;
import ognl.EnumerationElementsAccessor;
import ognl.EnumerationPropertyAccessor;
import ognl.IteratorElementsAccessor;
import ognl.IteratorPropertyAccessor;
import ognl.ListPropertyAccessor;
import ognl.MapElementsAccessor;
import ognl.MapPropertyAccessor;
import ognl.MethodAccessor;
import ognl.NullHandler;
import ognl.NumberElementsAccessor;
import ognl.ObjectElementsAccessor;
import ognl.ObjectMethodAccessor;
import ognl.ObjectNullHandler;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlException;
import ognl.PropertyAccessor;
import ognl.SetPropertyAccessor;
import ognl.internal.Cache;
import ognl.internal.CacheException;
import ognl.internal.CacheFactory;
import ognl.internal.ClassCache;
import ognl.internal.ClassCacheHandler;
import ognl.internal.HashMapCacheFactory;
import ognl.internal.entry.DeclaredMethodCacheEntry;
import ognl.internal.entry.DeclaredMethodCacheEntryFactory;
import ognl.internal.entry.FieldCacheEntryFactory;
import ognl.internal.entry.GenericMethodParameterTypeCacheEntry;
import ognl.internal.entry.GenericMethodParameterTypeFactory;
import ognl.internal.entry.MethodAccessCacheEntryFactory;
import ognl.internal.entry.MethodAccessEntryValue;
import ognl.internal.entry.MethodPermCacheEntryFactory;
import ognl.internal.entry.PermissionCacheEntry;
import ognl.internal.entry.PermissionCacheEntryFactory;
import ognl.internal.entry.PropertyDescriptorCacheEntryFactory;

public class OgnlCache {
    private final CacheFactory cacheFactory = new HashMapCacheFactory();
    private final ClassCache<MethodAccessor> methodAccessors = this.cacheFactory.createClassCache();
    private final ClassCache<PropertyAccessor> propertyAccessors;
    private final ClassCache<ElementsAccessor> elementsAccessors;
    private final ClassCache<NullHandler> nullHandlers;
    final ClassCache<Map<String, PropertyDescriptor>> propertyDescriptorCache;
    private final ClassCache<List<Constructor<?>>> constructorCache;
    private final Cache<DeclaredMethodCacheEntry, Map<String, List<Method>>> methodCache;
    private final Cache<PermissionCacheEntry, Permission> invokePermissionCache;
    private final ClassCache<Map<String, Field>> fieldCache;
    private final Cache<Method, Class<?>[]> methodParameterTypesCache;
    final Cache<GenericMethodParameterTypeCacheEntry, Class<?>[]> genericMethodParameterTypesCache;
    private final Cache<Constructor<?>, Class<?>[]> ctorParameterTypesCache;
    private final Cache<Method, MethodAccessEntryValue> methodAccessCache;
    private final MethodPermCacheEntryFactory methodPermCacheEntryFactory;
    private final Cache<Method, Boolean> methodPermCache;

    public OgnlCache() {
        ObjectMethodAccessor methodAccessor = new ObjectMethodAccessor();
        this.setMethodAccessor(Object.class, methodAccessor);
        this.setMethodAccessor(byte[].class, methodAccessor);
        this.setMethodAccessor(short[].class, methodAccessor);
        this.setMethodAccessor(char[].class, methodAccessor);
        this.setMethodAccessor(int[].class, methodAccessor);
        this.setMethodAccessor(long[].class, methodAccessor);
        this.setMethodAccessor(float[].class, methodAccessor);
        this.setMethodAccessor(double[].class, methodAccessor);
        this.setMethodAccessor(Object[].class, methodAccessor);
        this.propertyAccessors = this.cacheFactory.createClassCache();
        ArrayPropertyAccessor propertyAccessor = new ArrayPropertyAccessor();
        this.setPropertyAccessor(Object.class, new ObjectPropertyAccessor());
        this.setPropertyAccessor(byte[].class, propertyAccessor);
        this.setPropertyAccessor(short[].class, propertyAccessor);
        this.setPropertyAccessor(char[].class, propertyAccessor);
        this.setPropertyAccessor(int[].class, propertyAccessor);
        this.setPropertyAccessor(long[].class, propertyAccessor);
        this.setPropertyAccessor(float[].class, propertyAccessor);
        this.setPropertyAccessor(double[].class, propertyAccessor);
        this.setPropertyAccessor(Object[].class, propertyAccessor);
        this.setPropertyAccessor(List.class, new ListPropertyAccessor());
        this.setPropertyAccessor(Map.class, new MapPropertyAccessor());
        this.setPropertyAccessor(Set.class, new SetPropertyAccessor());
        this.setPropertyAccessor(Iterator.class, new IteratorPropertyAccessor());
        this.setPropertyAccessor(Enumeration.class, new EnumerationPropertyAccessor());
        this.elementsAccessors = this.cacheFactory.createClassCache();
        ArrayElementsAccessor elementsAccessor = new ArrayElementsAccessor();
        this.setElementsAccessor(Object.class, new ObjectElementsAccessor());
        this.setElementsAccessor(byte[].class, elementsAccessor);
        this.setElementsAccessor(short[].class, elementsAccessor);
        this.setElementsAccessor(char[].class, elementsAccessor);
        this.setElementsAccessor(int[].class, elementsAccessor);
        this.setElementsAccessor(long[].class, elementsAccessor);
        this.setElementsAccessor(float[].class, elementsAccessor);
        this.setElementsAccessor(double[].class, elementsAccessor);
        this.setElementsAccessor(Object[].class, elementsAccessor);
        this.setElementsAccessor(Collection.class, new CollectionElementsAccessor());
        this.setElementsAccessor(Map.class, new MapElementsAccessor());
        this.setElementsAccessor(Iterator.class, new IteratorElementsAccessor());
        this.setElementsAccessor(Enumeration.class, new EnumerationElementsAccessor());
        this.setElementsAccessor(Number.class, new NumberElementsAccessor());
        this.nullHandlers = this.cacheFactory.createClassCache();
        ObjectNullHandler nullHandler = new ObjectNullHandler();
        this.setNullHandler(Object.class, nullHandler);
        this.setNullHandler(byte[].class, nullHandler);
        this.setNullHandler(short[].class, nullHandler);
        this.setNullHandler(char[].class, nullHandler);
        this.setNullHandler(int[].class, nullHandler);
        this.setNullHandler(long[].class, nullHandler);
        this.setNullHandler(float[].class, nullHandler);
        this.setNullHandler(double[].class, nullHandler);
        this.setNullHandler(Object[].class, nullHandler);
        this.propertyDescriptorCache = this.cacheFactory.createClassCache(new PropertyDescriptorCacheEntryFactory());
        this.constructorCache = this.cacheFactory.createClassCache(key -> Arrays.asList(key.getConstructors()));
        this.methodCache = this.cacheFactory.createCache(new DeclaredMethodCacheEntryFactory());
        this.invokePermissionCache = this.cacheFactory.createCache(new PermissionCacheEntryFactory());
        this.fieldCache = this.cacheFactory.createClassCache(new FieldCacheEntryFactory());
        this.methodParameterTypesCache = this.cacheFactory.createCache(Method::getParameterTypes);
        this.genericMethodParameterTypesCache = this.cacheFactory.createCache(new GenericMethodParameterTypeFactory());
        this.ctorParameterTypesCache = this.cacheFactory.createCache(Constructor::getParameterTypes);
        this.methodAccessCache = this.cacheFactory.createCache(new MethodAccessCacheEntryFactory());
        this.methodPermCacheEntryFactory = new MethodPermCacheEntryFactory(System.getSecurityManager());
        this.methodPermCache = this.cacheFactory.createCache(this.methodPermCacheEntryFactory);
    }

    public Class<?>[] getMethodParameterTypes(Method method) throws CacheException {
        return this.methodParameterTypesCache.get(method);
    }

    public Class<?>[] getParameterTypes(Constructor<?> constructor) throws CacheException {
        return this.ctorParameterTypesCache.get(constructor);
    }

    public List<Constructor<?>> getConstructor(Class<?> clazz) throws CacheException {
        return (List)this.constructorCache.get(clazz);
    }

    public Map<String, Field> getField(Class<?> clazz) throws CacheException {
        return (Map)this.fieldCache.get(clazz);
    }

    public Map<String, List<Method>> getMethod(DeclaredMethodCacheEntry declaredMethodCacheEntry) throws CacheException {
        return this.methodCache.get(declaredMethodCacheEntry);
    }

    public Map<String, PropertyDescriptor> getPropertyDescriptor(Class<?> clazz) throws CacheException {
        return (Map)this.propertyDescriptorCache.get(clazz);
    }

    public Permission getInvokePermission(PermissionCacheEntry permissionCacheEntry) throws CacheException {
        return this.invokePermissionCache.get(permissionCacheEntry);
    }

    public MethodAccessor getMethodAccessor(Class<?> clazz) throws OgnlException {
        MethodAccessor methodAccessor = ClassCacheHandler.getHandler(clazz, this.methodAccessors);
        if (methodAccessor != null) {
            return methodAccessor;
        }
        throw new OgnlException("No method accessor for " + clazz);
    }

    public void setMethodAccessor(Class<?> clazz, MethodAccessor accessor) {
        this.methodAccessors.put(clazz, accessor);
    }

    public void setPropertyAccessor(Class<?> clazz, PropertyAccessor accessor) {
        this.propertyAccessors.put(clazz, accessor);
    }

    public PropertyAccessor getPropertyAccessor(Class<?> clazz) throws OgnlException {
        PropertyAccessor propertyAccessor = ClassCacheHandler.getHandler(clazz, this.propertyAccessors);
        if (propertyAccessor != null) {
            return propertyAccessor;
        }
        throw new OgnlException("No property accessor for class " + clazz);
    }

    public void setClassCacheInspector(ClassCacheInspector inspector) {
        this.propertyDescriptorCache.setClassInspector(inspector);
        this.constructorCache.setClassInspector(inspector);
        this.fieldCache.setClassInspector(inspector);
    }

    public Class<?>[] getGenericMethodParameterTypes(GenericMethodParameterTypeCacheEntry key) throws CacheException {
        return this.genericMethodParameterTypesCache.get(key);
    }

    public boolean getMethodPerm(Method method) throws CacheException {
        return this.methodPermCache.get(method);
    }

    public MethodAccessEntryValue getMethodAccess(Method method) throws CacheException {
        return this.methodAccessCache.get(method);
    }

    public void clear() {
        this.methodParameterTypesCache.clear();
        this.ctorParameterTypesCache.clear();
        this.propertyDescriptorCache.clear();
        this.genericMethodParameterTypesCache.clear();
        this.constructorCache.clear();
        this.methodCache.clear();
        this.invokePermissionCache.clear();
        this.fieldCache.clear();
        this.methodAccessCache.clear();
    }

    public ElementsAccessor getElementsAccessor(Class<?> clazz) throws OgnlException {
        ElementsAccessor answer = ClassCacheHandler.getHandler(clazz, this.elementsAccessors);
        if (answer != null) {
            return answer;
        }
        throw new OgnlException("No elements accessor for class " + clazz);
    }

    public void setElementsAccessor(Class<?> clazz, ElementsAccessor accessor) {
        this.elementsAccessors.put(clazz, accessor);
    }

    public NullHandler getNullHandler(Class<?> clazz) throws OgnlException {
        NullHandler answer = ClassCacheHandler.getHandler(clazz, this.nullHandlers);
        if (answer != null) {
            return answer;
        }
        throw new OgnlException("No null handler for class " + clazz);
    }

    public void setNullHandler(Class<?> clazz, NullHandler handler) {
        this.nullHandlers.put(clazz, handler);
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.methodPermCacheEntryFactory.setSecurityManager(securityManager);
    }
}

