/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.lang.reflect.Method;
import java.util.Objects;
import ognl.ASTConst;
import ognl.NodeType;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.enhance.ExpressionCompiler;
import ognl.enhance.UnsupportedCompilationException;

public class ASTStaticMethod
extends SimpleNode
implements NodeType {
    private static final long serialVersionUID = -116222026971367049L;
    private String className;
    private String methodName;
    private Class<?> getterClass;

    public ASTStaticMethod(int id) {
        super(id);
    }

    public ASTStaticMethod(OgnlParser p, int id) {
        super(p, id);
    }

    void init(String className, String methodName) {
        this.className = className;
        this.methodName = methodName;
    }

    @Override
    protected Object getValueBody(OgnlContext context, Object source2) throws OgnlException {
        Object[] args2 = new Object[this.jjtGetNumChildren()];
        Object root = context.getRoot();
        int icount = args2.length;
        for (int i = 0; i < icount; ++i) {
            args2[i] = this.children[i].getValue(context, root);
        }
        return OgnlRuntime.callStaticMethod(context, this.className, this.methodName, args2);
    }

    @Override
    public Class<?> getGetterClass() {
        return this.getterClass;
    }

    @Override
    public Class<?> getSetterClass() {
        return this.getterClass;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("@" + this.className + "@" + this.methodName);
        result.append("(");
        if (this.children != null && this.children.length > 0) {
            for (int i = 0; i < this.children.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.children[i]);
            }
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        StringBuilder result = new StringBuilder(this.className + "#" + this.methodName + "(");
        try {
            Class clazz = OgnlRuntime.classForName(context, this.className);
            Method m3 = OgnlRuntime.getMethod(context, clazz, this.methodName, this.children, true);
            if (m3 == null) {
                throw new UnsupportedCompilationException("Unable to find class/method combo " + this.className + " / " + this.methodName);
            }
            if (!context.getMemberAccess().isAccessible(context, clazz, m3, this.methodName)) {
                throw new UnsupportedCompilationException("Method is not accessible, check your jvm runtime security settings. For static class method " + this.className + " / " + this.methodName);
            }
            if (this.children != null && this.children.length > 0) {
                Class<?>[] parms = m3.getParameterTypes();
                for (int i = 0; i < this.children.length; ++i) {
                    Class<?> valueClass;
                    if (i > 0) {
                        result.append(", ");
                    }
                    Class<?> prevType = context.getCurrentType();
                    Object value = this.children[i].getValue(context, context.getRoot());
                    String parmString = this.children[i].toGetSourceString(context, context.getRoot());
                    if (parmString == null || parmString.trim().length() < 1) {
                        parmString = "null";
                    }
                    if (this.children[i] instanceof ASTConst) {
                        context.setCurrentType(prevType);
                    }
                    parmString = ExpressionCompiler.getRootExpression(this.children[i], context.getRoot(), context) + parmString;
                    String cast = "";
                    if (ExpressionCompiler.shouldCast(this.children[i])) {
                        cast = (String)context.remove("_preCast");
                    }
                    if (cast == null) {
                        cast = "";
                    }
                    if (!(this.children[i] instanceof ASTConst)) {
                        parmString = cast + parmString;
                    }
                    Class<?> clazz2 = valueClass = value != null ? value.getClass() : null;
                    if (NodeType.class.isAssignableFrom(this.children[i].getClass())) {
                        valueClass = ((NodeType)((Object)this.children[i])).getGetterClass();
                    }
                    if (valueClass != parms[i]) {
                        if (parms[i].isArray()) {
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "(" + ExpressionCompiler.getCastString(parms[i]) + ")ognl.OgnlOps.toArray(" + parmString + ", " + parms[i].getComponentType().getName() + ".class, true)", parms[i]);
                        } else if (parms[i].isPrimitive()) {
                            Class<?> wrapClass = OgnlRuntime.getPrimitiveWrapperClass(parms[i]);
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "((" + wrapClass.getName() + ")ognl.OgnlOps.convertValue(" + parmString + "," + wrapClass.getName() + ".class, true))." + OgnlRuntime.getNumericValueGetter(wrapClass), parms[i]);
                        } else if (parms[i] != Object.class) {
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "(" + parms[i].getName() + ")ognl.OgnlOps.convertValue(" + parmString + "," + parms[i].getName() + ".class)", parms[i]);
                        } else if (this.children[i] instanceof NodeType && ((NodeType)((Object)this.children[i])).getGetterClass() != null && Number.class.isAssignableFrom(((NodeType)((Object)this.children[i])).getGetterClass()) || Objects.requireNonNull(valueClass).isPrimitive()) {
                            parmString = " ($w) " + parmString;
                        }
                    }
                    result.append(parmString);
                }
            }
            result.append(")");
            try {
                Object contextObj = this.getValueBody(context, target);
                context.setCurrentObject(contextObj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.getterClass = m3.getReturnType();
            context.setCurrentType(m3.getReturnType());
            context.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m3, m3.getDeclaringClass()));
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return result.toString();
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        return this.toGetSourceString(context, target);
    }
}

