/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.Pair;
import com.taobao.arthas.core.command.klass100.ClassDumpTransformer;
import com.taobao.arthas.core.command.model.ClassLoaderVO;
import com.taobao.arthas.core.command.model.ClassVO;
import com.taobao.arthas.core.command.model.JadModel;
import com.taobao.arthas.core.command.model.MessageModel;
import com.taobao.arthas.core.command.model.RowAffectModel;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.command.ExitStatus;
import com.taobao.arthas.core.util.ClassLoaderUtils;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.arthas.core.util.CommandUtils;
import com.taobao.arthas.core.util.Decompiler;
import com.taobao.arthas.core.util.FileUtils;
import com.taobao.arthas.core.util.InstrumentationUtils;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.DefaultValue;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.regex.Pattern;

@Name(value="jad")
@Summary(value="Decompile class")
@Description(value="\nEXAMPLES:\n  jad java.lang.String\n  jad java.lang.String toString\n  jad java.lang.String -d /tmp/jad/dump\n  jad --source-only java.lang.String\n  jad -c 39eb305e org/apache/log4j/Logger\n  jad -c 39eb305e -E org\\\\.apache\\\\.*\\\\.StringUtils\n\nWIKI:\n  https://arthas.aliyun.com/doc/jad")
public class JadCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(JadCommand.class);
    private static Pattern pattern = Pattern.compile("(?m)^/\\*\\s*\\*/\\s*$" + System.getProperty("line.separator"));
    private String classPattern;
    private String methodName;
    private String code = null;
    private String classLoaderClass;
    private boolean isRegEx = false;
    private boolean hideUnicode = false;
    private boolean lineNumber;
    private String directory;
    private boolean sourceOnly = false;

    @Argument(argName="class-pattern", index=0)
    @Description(value="Class name pattern, use either '.' or '/' as separator")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(argName="method-name", index=1, required=false)
    @Description(value="Method name pattern, decompile a specific method instead of the whole class")
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Option(shortName="c", longName="code")
    @Description(value="The hash code of the special class's classLoader")
    public void setCode(String code) {
        this.code = code;
    }

    @Option(longName="classLoaderClass")
    @Description(value="The class name of the special class's classLoader.")
    public void setClassLoaderClass(String classLoaderClass) {
        this.classLoaderClass = classLoaderClass;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(longName="hideUnicode", flag=true)
    @Description(value="Hide unicode, default value false")
    public void setHideUnicode(boolean hideUnicode) {
        this.hideUnicode = hideUnicode;
    }

    @Option(longName="source-only", flag=true)
    @Description(value="Output source code only")
    public void setSourceOnly(boolean sourceOnly) {
        this.sourceOnly = sourceOnly;
    }

    @Option(longName="lineNumber")
    @DefaultValue(value="true")
    @Description(value="Output source code contains line number, default value true")
    public void setLineNumber(boolean lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Option(shortName="d", longName="directory")
    @Description(value="Sets the destination directory for dumped class files required by cfr decompiler")
    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public void process(CommandProcess process) {
        if (this.directory != null && !FileUtils.isDirectoryOrNotExist(this.directory)) {
            process.end(-1, this.directory + " :is not a directory, please check it");
            return;
        }
        Instrumentation inst = process.session().getInstrumentation();
        if (this.code == null && this.classLoaderClass != null) {
            List<ClassLoader> matchedClassLoaders = ClassLoaderUtils.getClassLoaderByClassName(inst, this.classLoaderClass);
            if (matchedClassLoaders.size() == 1) {
                this.code = Integer.toHexString(matchedClassLoaders.get(0).hashCode());
            } else {
                if (matchedClassLoaders.size() > 1) {
                    List<ClassLoaderVO> classLoaderVOList = ClassUtils.createClassLoaderVOList(matchedClassLoaders);
                    JadModel jadModel = new JadModel().setClassLoaderClass(this.classLoaderClass).setMatchedClassLoaders(classLoaderVOList);
                    process.appendResult(jadModel);
                    process.end(-1, "Found more than one classloader by class name, please specify classloader with '-c <classloader hash>'");
                    return;
                }
                process.end(-1, "Can not find classloader by class name: " + this.classLoaderClass + ".");
                return;
            }
        }
        Set<Class<?>> matchedClasses = SearchUtils.searchClassOnly(inst, this.classPattern, this.isRegEx, this.code);
        try {
            ExitStatus status;
            RowAffect affect = new RowAffect();
            if (matchedClasses == null || matchedClasses.isEmpty()) {
                status = this.processNoMatch(process);
            } else if (matchedClasses.size() > 1) {
                status = this.processMatches(process, matchedClasses);
            } else {
                Set<Class<?>> withInnerClasses = SearchUtils.searchClassOnly(inst, matchedClasses.iterator().next().getName() + "$*", false, this.code);
                if (withInnerClasses.isEmpty()) {
                    withInnerClasses = matchedClasses;
                }
                status = this.processExactMatch(process, affect, inst, matchedClasses, withInnerClasses);
            }
            if (!this.sourceOnly) {
                process.appendResult(new RowAffectModel(affect));
            }
            CommandUtils.end(process, status);
        }
        catch (Throwable e) {
            logger.error("processing error", e);
            process.end(-1, "processing error");
        }
    }

    private ExitStatus processExactMatch(CommandProcess process, RowAffect affect, Instrumentation inst, Set<Class<?>> matchedClasses, Set<Class<?>> withInnerClasses) {
        Class<?> c = matchedClasses.iterator().next();
        HashSet allClasses = new HashSet(withInnerClasses);
        allClasses.add(c);
        try {
            ClassDumpTransformer transformer = this.directory == null ? new ClassDumpTransformer(allClasses) : new ClassDumpTransformer(allClasses, new File(this.directory));
            InstrumentationUtils.retransformClasses(inst, transformer, allClasses);
            Map<Class<?>, File> classFiles = transformer.getDumpResult();
            if (classFiles == null || classFiles.isEmpty()) {
                return ExitStatus.failure(-1, "jad: fail to dump class file for decompiler, make sure you have write permission of the directory \"" + transformer.dumpDir() + "\" or try with \"-d/--directory\" to specify the directory of dump files");
            }
            File classFile = classFiles.get(c);
            Pair<String, NavigableMap<Integer, Integer>> decompileResult = Decompiler.decompileWithMappings(classFile.getAbsolutePath(), this.methodName, this.hideUnicode, this.lineNumber);
            String source2 = decompileResult.getFirst();
            source2 = source2 != null ? pattern.matcher(source2).replaceAll("") : "unknown";
            JadModel jadModel = new JadModel();
            jadModel.setSource(source2);
            jadModel.setMappings(decompileResult.getSecond());
            if (!this.sourceOnly) {
                jadModel.setClassInfo(ClassUtils.createSimpleClassInfo(c));
                jadModel.setLocation(ClassUtils.getCodeSource(c.getProtectionDomain().getCodeSource()));
            }
            process.appendResult(jadModel);
            affect.rCnt(classFiles.keySet().size());
            return ExitStatus.success();
        }
        catch (Throwable t) {
            logger.error("jad: fail to decompile class: " + c.getName(), t);
            return ExitStatus.failure(-1, "jad: fail to decompile class: " + c.getName() + ", please check $HOME/logs/arthas/arthas.log for more details.");
        }
    }

    private ExitStatus processMatches(CommandProcess process, Set<Class<?>> matchedClasses) {
        String usage = "jad -c <hashcode> " + this.classPattern;
        String msg = " Found more than one class for: " + this.classPattern + ", Please use " + usage;
        process.appendResult(new MessageModel(msg));
        List<ClassVO> classVOs = ClassUtils.createClassVOList(matchedClasses);
        JadModel jadModel = new JadModel();
        jadModel.setMatchedClasses(classVOs);
        process.appendResult(jadModel);
        return ExitStatus.failure(-1, msg);
    }

    private ExitStatus processNoMatch(CommandProcess process) {
        return ExitStatus.failure(-1, "No class found for: " + this.classPattern);
    }

    @Override
    public void complete(Completion completion) {
        int argumentIndex = CompletionUtils.detectArgumentIndex(completion);
        if (argumentIndex == 1) {
            if (!CompletionUtils.completeClassName(completion)) {
                super.complete(completion);
            }
            return;
        }
        if (argumentIndex == 2) {
            if (!CompletionUtils.completeMethodName(completion)) {
                super.complete(completion);
            }
            return;
        }
        super.complete(completion);
    }
}

