/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;
import java.lang.reflect.Type;

final class ObjectWriterImplInt8Array
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImplInt8Array INSTANCE = new ObjectWriterImplInt8Array();
    static final byte[] JSONB_TYPE_NAME_BYTES = JSONB.toBytes("[Byte");
    static final long JSONB_TYPE_HASH = Fnv.hashCode64("[Byte");

    ObjectWriterImplInt8Array() {
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        boolean writeAsString = (features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        Byte[] array = (Byte[])object;
        jsonWriter.startArray();
        for (int i = 0; i < array.length; ++i) {
            Byte value;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((value = array[i]) == null) {
                jsonWriter.writeNull();
                continue;
            }
            byte byteValue = value;
            if (writeAsString) {
                jsonWriter.writeString(byteValue);
                continue;
            }
            jsonWriter.writeInt8(byteValue);
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            jsonWriter.writeTypeName(JSONB_TYPE_NAME_BYTES, JSONB_TYPE_HASH);
        }
        boolean writeAsString = (features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        Byte[] array = (Byte[])object;
        jsonWriter.startArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            Byte value = array[i];
            if (value == null) {
                jsonWriter.writeNull();
                continue;
            }
            byte byteValue = value;
            if (writeAsString) {
                jsonWriter.writeString(byteValue);
                continue;
            }
            jsonWriter.writeInt8(byteValue);
        }
    }
}

