/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.proxy.discovery.impl;

import com.alibaba.arthas.nat.agent.proxy.discovery.NativeAgentDiscovery;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.support.CloseableClient;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdNativeAgentDiscovery
implements NativeAgentDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(EtcdNativeAgentDiscovery.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> findNativeAgent(String address) {
        Client client = null;
        CloseableClient kvClient = null;
        ConcurrentHashMap<String, String> nativeAgentMap = null;
        try {
            client = Client.builder().endpoints("http://" + address).build();
            kvClient = client.getKVClient();
            GetResponse getResponse = null;
            try {
                ByteSequence prefix = ByteSequence.from("/native-agent", StandardCharsets.UTF_8);
                GetOption option = GetOption.newBuilder().isPrefix(true).build();
                getResponse = kvClient.get(prefix, option).get();
            }
            catch (Exception e) {
                logger.error("get value failed with prefix/native-agent");
                throw new RuntimeException(e);
            }
            List<KeyValue> kvs = getResponse.getKvs();
            nativeAgentMap = new ConcurrentHashMap<String, String>(kvs.size());
            for (KeyValue kv : kvs) {
                String keyStr = kv.getKey().toString(StandardCharsets.UTF_8);
                if (keyStr.startsWith("/native-agent-proxy")) continue;
                String[] split = keyStr.split("/");
                nativeAgentMap.put(split[2], kv.getValue().toString(StandardCharsets.UTF_8));
            }
        }
        finally {
            if (kvClient != null) {
                kvClient.close();
            }
            if (client != null) {
                client.close();
            }
        }
        return nativeAgentMap;
    }
}

