/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.grpc.InternalServiceProviders;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.grpclb.GrpclbNameResolver;
import io.grpc.internal.GrpcUtil;
import java.net.URI;

final class SecretGrpclbNameResolverProvider {
    private SecretGrpclbNameResolverProvider() {
    }

    public static final class Provider
    extends NameResolverProvider {
        private static final String SCHEME = "dns";

        @Override
        public GrpclbNameResolver newNameResolver(URI targetUri, NameResolver.Args args2) {
            if (SCHEME.equals(targetUri.getScheme())) {
                String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
                Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
                String name = targetPath.substring(1);
                return new GrpclbNameResolver(targetUri.getAuthority(), name, args2, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), InternalServiceProviders.isAndroid(this.getClass().getClassLoader()));
            }
            return null;
        }

        @Override
        public String getDefaultScheme() {
            return SCHEME;
        }

        @Override
        protected boolean isAvailable() {
            return true;
        }

        @Override
        public int priority() {
            return 6;
        }
    }
}

