/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import java.nio.charset.StandardCharsets;

public class StringUtils {
    protected static final long MASK_ESCAPE_NONE_ASCII = JSONWriter.Feature.EscapeNoneAscii.mask;
    protected static final long MASK_BROWSER_SECURE = JSONWriter.Feature.BrowserSecure.mask;

    public static int writeLatin1(byte[] bytes, int off, byte[] value, byte quote) {
        int strlen = value.length;
        bytes[off] = quote;
        System.arraycopy(value, 0, bytes, off + 1, strlen);
        bytes[off + strlen + 1] = quote;
        return off + strlen + 2;
    }

    public static int writeLatin1Escaped(byte[] bytes, int off, byte[] values2, byte quote, long features) {
        boolean browserSecure = (features & MASK_BROWSER_SECURE) != 0L;
        bytes[off++] = quote;
        block5: for (int i = 0; i < values2.length; ++i) {
            byte ch = values2[i];
            switch (ch) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 92: {
                    StringUtils.writeEscapedChar(bytes, off, (int)ch);
                    off += 2;
                    continue block5;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    StringUtils.writeU4Hex2(bytes, off, (int)ch);
                    off += 6;
                    continue block5;
                }
                case 40: 
                case 41: 
                case 60: 
                case 62: {
                    if (browserSecure) {
                        StringUtils.writeU4HexU(bytes, off, (int)ch);
                        off += 6;
                        continue block5;
                    }
                    bytes[off++] = ch;
                    continue block5;
                }
                default: {
                    if (ch == quote) {
                        bytes[off] = 92;
                        bytes[off + 1] = quote;
                        off += 2;
                        continue block5;
                    }
                    if (ch < 0) {
                        int c = ch & 0xFF;
                        bytes[off] = (byte)(0xC0 | c >> 6);
                        bytes[off + 1] = (byte)(0x80 | c & 0x3F);
                        off += 2;
                        continue block5;
                    }
                    bytes[off++] = ch;
                }
            }
        }
        bytes[off] = quote;
        return off + 1;
    }

    public static int writeLatin1EscapedRest(char[] chars, int off, byte[] str, int coff, char quote, long features) {
        boolean escapeNoneAscii = (features & JSONWriter.Feature.EscapeNoneAscii.mask) != 0L;
        boolean browserSecure = (features & JSONWriter.Feature.BrowserSecure.mask) != 0L;
        block6: for (int i = coff; i < str.length; ++i) {
            byte b = str[i];
            char ch = (char)(b & 0xFF);
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch == quote) {
                        chars[off++] = 92;
                    }
                    chars[off++] = ch;
                    continue block6;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\\': {
                    StringUtils.writeEscapedChar(chars, off, (int)ch);
                    off += 2;
                    continue block6;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    StringUtils.writeU4Hex2(chars, off, (int)ch);
                    off += 6;
                    continue block6;
                }
                case '(': 
                case ')': 
                case '<': 
                case '>': {
                    if (browserSecure) {
                        StringUtils.writeU4HexU(chars, off, (int)ch);
                        off += 6;
                        continue block6;
                    }
                    chars[off++] = ch;
                    continue block6;
                }
                default: {
                    if (escapeNoneAscii && ch > '\u007f') {
                        StringUtils.writeU4HexU(chars, off, (int)ch);
                        off += 6;
                        continue block6;
                    }
                    chars[off++] = ch;
                }
            }
        }
        chars[off] = quote;
        return off + 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int writeUTF16(byte[] bytes, int off, byte[] value, byte quote, long features) {
        boolean escapeNoneAscii = (features & MASK_ESCAPE_NONE_ASCII) != 0L;
        boolean browserSecure = (features & MASK_BROWSER_SECURE) != 0L;
        bytes[off++] = quote;
        int coff = 0;
        int char_len = value.length >> 1;
        block5: while (true) {
            char c;
            block18: {
                int uc;
                block17: {
                    block19: {
                        if (coff >= char_len) {
                            bytes[off] = quote;
                            return off + 1;
                        }
                        if ((c = IOUtils.getChar(value, coff++)) < '\u0080') {
                            switch (c) {
                                case '\b': 
                                case '\t': 
                                case '\n': 
                                case '\f': 
                                case '\r': 
                                case '\\': {
                                    StringUtils.writeEscapedChar(bytes, off, (int)c);
                                    off += 2;
                                    continue block5;
                                }
                                case '\u0000': 
                                case '\u0001': 
                                case '\u0002': 
                                case '\u0003': 
                                case '\u0004': 
                                case '\u0005': 
                                case '\u0006': 
                                case '\u0007': 
                                case '\u000b': 
                                case '\u000e': 
                                case '\u000f': 
                                case '\u0010': 
                                case '\u0011': 
                                case '\u0012': 
                                case '\u0013': 
                                case '\u0014': 
                                case '\u0015': 
                                case '\u0016': 
                                case '\u0017': 
                                case '\u0018': 
                                case '\u0019': 
                                case '\u001a': 
                                case '\u001b': 
                                case '\u001c': 
                                case '\u001d': 
                                case '\u001e': 
                                case '\u001f': {
                                    StringUtils.writeU4Hex2(bytes, off, (int)c);
                                    off += 6;
                                    continue block5;
                                }
                                case '(': 
                                case ')': 
                                case '<': 
                                case '>': {
                                    if (browserSecure) {
                                        StringUtils.writeU4HexU(bytes, off, (int)c);
                                        off += 6;
                                        continue block5;
                                    }
                                    bytes[off++] = (byte)c;
                                    continue block5;
                                }
                            }
                            if (c == quote) {
                                bytes[off] = 92;
                                bytes[off + 1] = quote;
                                off += 2;
                                continue;
                            }
                            bytes[off++] = (byte)c;
                            continue;
                        }
                        if (c < '\u0800') {
                            bytes[off] = (byte)(0xC0 | c >> 6);
                            bytes[off + 1] = (byte)(0x80 | c & 0x3F);
                            off += 2;
                            continue;
                        }
                        if (escapeNoneAscii) {
                            StringUtils.writeU4HexU(bytes, off, (int)c);
                            off += 6;
                            continue;
                        }
                        if (c < '\ud800' || c >= '\ue000') break block18;
                        if (c >= '\udc00') break block19;
                        if (coff + 1 > char_len) {
                            uc = -1;
                            break block17;
                        } else {
                            char d = IOUtils.getChar(value, coff);
                            if (d >= '\udc00' && d < '\ue000') {
                                ++coff;
                                uc = (c << 10) + d + -56613888;
                                break block17;
                            } else {
                                bytes[off++] = 63;
                                continue;
                            }
                        }
                    }
                    bytes[off++] = 63;
                    continue;
                }
                if (uc < 0) {
                    bytes[off++] = 63;
                    continue;
                }
                bytes[off] = (byte)(0xF0 | uc >> 18);
                bytes[off + 1] = (byte)(0x80 | uc >> 12 & 0x3F);
                bytes[off + 2] = (byte)(0x80 | uc >> 6 & 0x3F);
                bytes[off + 3] = (byte)(0x80 | uc & 0x3F);
                off += 4;
                continue;
            }
            bytes[off] = (byte)(0xE0 | c >> 12);
            bytes[off + 1] = (byte)(0x80 | c >> 6 & 0x3F);
            bytes[off + 2] = (byte)(0x80 | c & 0x3F);
            off += 3;
        }
    }

    public static void writeEscapedChar(byte[] bytes, int off, int c0) {
        IOUtils.putShortLE(bytes, off, LATIN1.ESCAPED_CHARS[c0 & 0x7F]);
    }

    public static void writeU4Hex2(byte[] bytes, int off, int c) {
        IOUtils.putIntUnaligned(bytes, off, LATIN1.U4);
        IOUtils.putShortLE(bytes, off + 4, IOUtils.hex2(c));
    }

    public static void writeU4HexU(byte[] bytes, int off, int c) {
        IOUtils.putShortUnaligned(bytes, off, LATIN1.U2);
        IOUtils.putIntLE(bytes, off + 2, IOUtils.hex4U(c));
    }

    public static void writeEscapedChar(char[] chars, int off, int c0) {
        IOUtils.putIntUnaligned(chars, off, UTF16.ESCAPED_CHARS[c0 & 0x7F]);
    }

    public static void writeU4Hex2(char[] chars, int off, int c) {
        IOUtils.putLongUnaligned(chars, off, UTF16.U4);
        IOUtils.putIntLE(chars, off + 4, IOUtils.utf16Hex2(c));
    }

    public static void writeU4HexU(char[] chars, int off, int c) {
        IOUtils.putIntUnaligned(chars, off, UTF16.U2);
        IOUtils.putLongLE(chars, off + 2, IOUtils.utf16Hex4U(c));
    }

    public static boolean escaped(byte[] value, byte quote, long vecQuote) {
        int i;
        int upperBound = value.length - i & 0xFFFFFFF8;
        for (i = 0; i < upperBound; i += 8) {
            if (StringUtils.noneEscaped(IOUtils.getLongUnaligned(value, i), vecQuote)) continue;
            return true;
        }
        while (i < value.length) {
            byte c = value[i];
            if (c == quote || c == 92 || c < 32) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean noneEscaped(long v, long quote) {
        return (v + 0x6060606060606060L & 0x8080808080808080L) == -9187201950435737472L && ((v ^ quote) + 0x101010101010101L & 0x8080808080808080L) == -9187201950435737472L && ((v ^ 0xA3A3A3A3A3A3A3A3L) + 0x101010101010101L & 0x8080808080808080L) == -9187201950435737472L;
    }

    public static final class LATIN1 {
        private static final short U2;
        private static final int U4;
        private static final short[] ESCAPED_CHARS;

        static {
            byte[] bytes = "\\u00".getBytes(StandardCharsets.UTF_8);
            U2 = JDKUtils.UNSAFE.getShort(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
            U4 = JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
            int slash = 92;
            short[] shorts = new short[128];
            shorts[92] = (short)(slash | 0x5C00);
            shorts[10] = (short)(slash | 0x6E00);
            shorts[13] = (short)(slash | 0x7200);
            shorts[12] = (short)(slash | 0x6600);
            shorts[8] = (short)(slash | 0x6200);
            shorts[9] = (short)(slash | 0x7400);
            ESCAPED_CHARS = shorts;
        }
    }

    public static final class UTF16 {
        private static final int U2;
        private static final long U4;
        private static final int[] ESCAPED_CHARS;

        static {
            char[] bytes = "\\u00".toCharArray();
            U2 = JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
            U4 = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
            char[] mapping = new char[]{'\\', '\\', '\n', 'n', '\r', 'r', '\f', 'f', '\b', 'b', '\t', 't'};
            char[] buf = new char[]{'\\', '\u0000'};
            int[] shorts = new int[128];
            for (int i = 0; i < mapping.length; i += 2) {
                buf[1] = mapping[i + 1];
                shorts[mapping[i]] = IOUtils.getIntUnaligned(buf, 0);
            }
            ESCAPED_CHARS = shorts;
        }
    }
}

