/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.filter.ExtraProcessor;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class ObjectReaderBean<T>
implements ObjectReader<T> {
    protected final Class objectClass;
    protected final Supplier<T> creator;
    protected final Function buildFunction;
    protected final long features;
    protected final String typeName;
    protected final long typeNameHash;
    protected FieldReader extraFieldReader;
    protected boolean hasDefaultValue;
    protected final boolean serializable;
    protected final JSONSchema schema;
    protected JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler;

    protected ObjectReaderBean(Class objectClass, Supplier<T> creator, String typeName, long features, JSONSchema schema, Function buildFunction) {
        if (typeName == null && objectClass != null) {
            typeName = TypeUtils.getTypeName(objectClass);
        }
        this.objectClass = objectClass;
        this.creator = creator;
        this.buildFunction = buildFunction;
        this.features = features;
        this.typeName = typeName;
        this.typeNameHash = typeName != null ? Fnv.hashCode64(typeName) : 0L;
        this.schema = schema;
        this.serializable = objectClass != null && Serializable.class.isAssignableFrom(objectClass);
    }

    @Override
    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    protected T processObjectInputSingleItemArray(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Type itemType;
        List list;
        String message = "expect {, but [, class " + this.typeName;
        if (fieldName != null) {
            message = message + ", parent fieldName " + fieldName;
        }
        String info = jsonReader.info(message);
        long featuresAll = jsonReader.features(features);
        if ((featuresAll & JSONReader.Feature.SupportSmartMatch.mask) != 0L && (list = jsonReader.readArray(itemType = fieldType == null ? this.objectClass : fieldType)) != null) {
            if (list.size() == 0) {
                return null;
            }
            if (list.size() == 1) {
                return (T)list.get(0);
            }
        }
        throw new JSONException(info);
    }

    protected void processExtra(JSONReader jsonReader, Object object) {
        this.processExtra(jsonReader, object, 0L);
    }

    protected void processExtra(JSONReader jsonReader, Object object, long features) {
        Class fieldClass;
        String fieldName1;
        long hashCode64LCase;
        FieldReader fieldReader;
        String fieldName;
        if ((jsonReader.features(this.features | features) & JSONReader.Feature.SupportSmartMatch.mask) != 0L && (fieldName = jsonReader.getFieldName()).startsWith("is") && (fieldReader = this.getFieldReaderLCase(hashCode64LCase = Fnv.hashCode64LCase(fieldName1 = fieldName.substring(2)))) != null && ((fieldClass = fieldReader.fieldClass) == Boolean.class || fieldClass == Boolean.TYPE)) {
            fieldReader.readFieldValue(jsonReader, object);
            return;
        }
        if (this.extraFieldReader != null && object != null) {
            this.extraFieldReader.processExtra(jsonReader, object);
            return;
        }
        ExtraProcessor extraProcessor = jsonReader.getContext().getExtraProcessor();
        if (extraProcessor != null) {
            String fieldName2 = jsonReader.getFieldName();
            Type type = extraProcessor.getType(fieldName2);
            Object extraValue = jsonReader.read(type);
            extraProcessor.processExtra(object, fieldName2, extraValue);
            return;
        }
        if ((jsonReader.features(features) & JSONReader.Feature.ErrorOnUnknownProperties.mask) != 0L) {
            throw new JSONException("Unknown Property " + jsonReader.getFieldName());
        }
        jsonReader.skipValue();
    }

    @Override
    public void acceptExtra(Object object, String fieldName, Object fieldValue, long features) {
        if (this.extraFieldReader == null || object == null) {
            Class fieldClass;
            String fieldName1;
            long hashCode64LCase;
            FieldReader fieldReader;
            if (fieldName.startsWith("is") && (fieldReader = this.getFieldReaderLCase(hashCode64LCase = Fnv.hashCode64LCase(fieldName1 = fieldName.substring(2)))) != null && ((fieldClass = fieldReader.fieldClass) == Boolean.class || fieldClass == Boolean.TYPE)) {
                fieldReader.accept(object, fieldValue);
                return;
            }
            if ((features & JSONReader.Feature.ErrorOnUnknownProperties.mask) != 0L) {
                throw new JSONException("Unknown Property " + fieldName);
            }
            return;
        }
        this.extraFieldReader.acceptExtra(object, fieldName, fieldValue);
    }

    @Deprecated
    public final ObjectReader checkAutoType(JSONReader jsonReader, Class expectClass, long features) {
        return this.checkAutoType(jsonReader, features);
    }

    public final ObjectReader checkAutoType(JSONReader jsonReader, long features) {
        if (!jsonReader.nextIfMatchTypedAny()) {
            return null;
        }
        return this.checkAutoType0(jsonReader, features);
    }

    protected final ObjectReader checkAutoType0(JSONReader jsonReader, long features) {
        ObjectReader autoTypeObjectReader;
        Class expectClass = this.objectClass;
        long typeHash = jsonReader.readTypeHashCode();
        JSONReader.Context context = jsonReader.getContext();
        long features3 = jsonReader.features(features | this.features);
        JSONReader.AutoTypeBeforeHandler autoTypeFilter = context.getContextAutoTypeBeforeHandler();
        if (autoTypeFilter != null) {
            String typeName;
            Class filterClass = autoTypeFilter.apply(typeHash, expectClass, features);
            if (filterClass == null && (filterClass = autoTypeFilter.apply(typeName = jsonReader.getString(), expectClass, features)) != null && !expectClass.isAssignableFrom(filterClass)) {
                if ((jsonReader.features(features) & JSONReader.Feature.IgnoreAutoTypeNotMatch.mask) == 0L) {
                    throw this.notMatchError();
                }
                filterClass = expectClass;
            }
            autoTypeObjectReader = context.getObjectReader(filterClass);
        } else {
            autoTypeObjectReader = jsonReader.getObjectReaderAutoType(typeHash, expectClass, features);
            if (autoTypeObjectReader == null) {
                throw this.auotypeError(jsonReader);
            }
            Class autoTypeObjectReaderClass = autoTypeObjectReader.getObjectClass();
            if (expectClass != null && autoTypeObjectReaderClass != null && !expectClass.isAssignableFrom(autoTypeObjectReaderClass)) {
                if ((features3 & JSONReader.Feature.IgnoreAutoTypeNotMatch.mask) == 0L) {
                    throw this.notMatchError();
                }
                autoTypeObjectReader = context.getObjectReader(expectClass);
            } else if (typeHash == this.typeNameHash || (features3 & JSONReader.Feature.SupportAutoType.mask) == 0L) {
                autoTypeObjectReader = null;
            }
        }
        if (autoTypeObjectReader == this || autoTypeObjectReader != null && autoTypeObjectReader.getObjectClass() == this.objectClass) {
            autoTypeObjectReader = null;
        }
        return autoTypeObjectReader;
    }

    private JSONException notMatchError() {
        return new JSONException("type not match. " + this.typeName + " -> " + this.objectClass.getName());
    }

    private JSONException auotypeError(JSONReader jsonReader) {
        return new JSONException(jsonReader.info("autoType not support"));
    }

    protected void initDefaultValue(T object) {
    }

    public void readObject(JSONReader jsonReader, Object object, long features) {
        if (jsonReader.nextIfNull()) {
            jsonReader.nextIfComma();
            return;
        }
        boolean objectStart = jsonReader.nextIfObjectStart();
        if (!objectStart) {
            throw new JSONException(jsonReader.info());
        }
        while (!jsonReader.nextIfObjectEnd()) {
            long hash = jsonReader.readFieldNameHashCode();
            FieldReader fieldReader = this.getFieldReader(hash);
            if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.getFeatures())) {
                long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
            }
            if (fieldReader == null) {
                this.processExtra(jsonReader, object);
                continue;
            }
            fieldReader.readFieldValue(jsonReader, object);
        }
        jsonReader.nextIfComma();
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
    }

    @Override
    public T readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.jsonb) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (jsonReader.nextIfNullOrEmptyString()) {
            jsonReader.nextIfComma();
            return null;
        }
        long featuresAll = jsonReader.features(this.getFeatures() | features);
        if (jsonReader.isArray()) {
            if ((featuresAll & JSONReader.Feature.SupportArrayToBean.mask) != 0L) {
                return this.readArrayMappingObject(jsonReader, fieldType, fieldName, features);
            }
            return this.processObjectInputSingleItemArray(jsonReader, fieldType, fieldName, featuresAll);
        }
        Object object = null;
        boolean objectStart = jsonReader.nextIfObjectStart();
        if (!objectStart) {
            char ch = jsonReader.current();
            if (ch == 't' || ch == 'f') {
                jsonReader.readBoolValue();
                return null;
            }
            if (ch != '\"' && ch != '\'' && ch != '}') {
                throw new JSONException(jsonReader.info());
            }
        }
        int i = 0;
        while (true) {
            long features3;
            if (jsonReader.nextIfObjectEnd()) {
                if (object != null || (object = (Object)this.createInstance(jsonReader.getContext().getFeatures() | features)) == null || (featuresAll & JSONReader.Feature.InitStringFieldAsEmpty.mask) == 0L) break;
                this.initStringFieldAsEmpty(object);
                break;
            }
            JSONReader.Context context = jsonReader.getContext();
            long hash = jsonReader.readFieldNameHashCode();
            JSONReader.AutoTypeBeforeHandler autoTypeFilter = this.autoTypeBeforeHandler;
            if (autoTypeFilter == null) {
                autoTypeFilter = context.getContextAutoTypeBeforeHandler();
            }
            if (i == 0 && hash == this.getTypeKeyHash() && (((features3 = features | this.getFeatures() | context.getFeatures()) & JSONReader.Feature.SupportAutoType.mask) != 0L || autoTypeFilter != null)) {
                Class<?> filterClass;
                ObjectReader reader = null;
                long typeHash = jsonReader.readTypeHashCode();
                if (autoTypeFilter != null && (filterClass = autoTypeFilter.apply(typeHash, this.objectClass, features3)) == null && (filterClass = autoTypeFilter.apply(jsonReader.getString(), this.objectClass, features3)) != null) {
                    reader = context.getObjectReader(filterClass);
                }
                if (reader == null) {
                    reader = this.autoType(context, typeHash);
                }
                String typeName = null;
                if (reader == null && (reader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass, features3)) == null) {
                    throw new JSONException(jsonReader.info("No suitable ObjectReader found for " + typeName));
                }
                if (reader != this) {
                    FieldReader fieldReader = reader.getFieldReader(hash);
                    if (fieldReader != null && typeName == null) {
                        typeName = jsonReader.getString();
                    }
                    object = reader.readObject(jsonReader, null, null, features | this.getFeatures());
                    if (fieldReader != null) {
                        fieldReader.accept(object, typeName);
                    }
                    return object;
                }
            } else {
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.getFeatures())) {
                    long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (object == null) {
                    object = this.createInstance(jsonReader.getContext().getFeatures() | features);
                }
                if (fieldReader == null) {
                    this.processExtra(jsonReader, object);
                } else {
                    fieldReader.readFieldValue(jsonReader, object);
                }
            }
            ++i;
        }
        jsonReader.nextIfComma();
        Function buildFunction = this.getBuildFunction();
        if (buildFunction != null) {
            object = buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    protected void initStringFieldAsEmpty(Object object) {
    }

    public JSONReader.AutoTypeBeforeHandler getAutoTypeBeforeHandler() {
        return this.autoTypeBeforeHandler;
    }

    public void setAutoTypeBeforeHandler(JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler) {
        this.autoTypeBeforeHandler = autoTypeBeforeHandler;
    }

    protected boolean readFieldValueWithLCase(JSONReader jsonReader, Object object, long hashCode64, long features2) {
        FieldReader fieldReader;
        long hashCode64L;
        if (jsonReader.isSupportSmartMatch(features2) && (hashCode64L = jsonReader.getNameHashCodeLCase()) != hashCode64 && (fieldReader = this.getFieldReaderLCase(hashCode64L)) != null) {
            fieldReader.readFieldValue(jsonReader, object);
            return true;
        }
        return false;
    }
}

