/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.pointer;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.json.pointer.JsonPointerIterator;
import io.vertx.core.json.pointer.impl.JsonPointerImpl;
import java.net.URI;
import java.util.List;

@VertxGen
public interface JsonPointer {
    public boolean isRootPointer();

    public boolean isLocalPointer();

    public boolean isParent(JsonPointer var1);

    public String toString();

    @GenIgnore(value={"permitted-type"})
    public URI toURI();

    @GenIgnore(value={"permitted-type"})
    public URI getURIWithoutFragment();

    @Fluent
    public JsonPointer append(String var1);

    @Fluent
    public JsonPointer append(int var1);

    @Fluent
    public JsonPointer append(List<String> var1);

    @Fluent
    public JsonPointer append(JsonPointer var1);

    @Fluent
    public JsonPointer parent();

    default public @Nullable Object query(Object objectToQuery, JsonPointerIterator iterator2) {
        return this.queryOrDefault(objectToQuery, iterator2, null);
    }

    public Object queryOrDefault(Object var1, JsonPointerIterator var2, Object var3);

    default public @Nullable Object queryJson(Object jsonElement) {
        return this.query(jsonElement, JsonPointerIterator.JSON_ITERATOR);
    }

    default public @Nullable Object queryJsonOrDefault(Object jsonElement, Object defaultValue) {
        return this.queryOrDefault(jsonElement, JsonPointerIterator.JSON_ITERATOR, defaultValue);
    }

    public List<Object> tracedQuery(Object var1, JsonPointerIterator var2);

    public Object write(Object var1, JsonPointerIterator var2, Object var3, boolean var4);

    default public Object writeJson(Object jsonElement, Object newElement) {
        return this.writeJson(jsonElement, newElement, false);
    }

    default public Object writeJson(Object jsonElement, Object newElement, boolean createOnMissing) {
        return this.write(jsonElement, JsonPointerIterator.JSON_ITERATOR, newElement, createOnMissing);
    }

    public JsonPointer copy();

    public static JsonPointer create() {
        return new JsonPointerImpl();
    }

    public static JsonPointer from(String pointer) {
        return new JsonPointerImpl(pointer);
    }

    @GenIgnore(value={"permitted-type"})
    public static JsonPointer fromURI(URI uri) {
        return new JsonPointerImpl(uri);
    }
}

