/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl.headers;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.impl.HttpUtils;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class Http2HeadersAdaptor
implements MultiMap {
    private final Http2Headers headers;

    public Http2HeadersAdaptor(Http2Headers headers) {
        List cookies = headers.getAll(HttpHeaderNames.COOKIE);
        if (cookies != null && cookies.size() > 1) {
            String value = cookies.stream().collect(Collectors.joining("; "));
            headers.set(HttpHeaderNames.COOKIE, value);
        }
        this.headers = headers;
    }

    @Override
    public String get(String name) {
        CharSequence val = (CharSequence)this.headers.get(HttpUtils.toLowerCase(name));
        return val != null ? val.toString() : null;
    }

    @Override
    public List<String> getAll(String name) {
        final List all = this.headers.getAll(HttpUtils.toLowerCase(name));
        if (all != null) {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return ((CharSequence)all.get(index)).toString();
                }

                @Override
                public int size() {
                    return all.size();
                }
            };
        }
        return null;
    }

    @Override
    public boolean contains(String name) {
        return this.headers.contains(HttpUtils.toLowerCase(name));
    }

    @Override
    public boolean contains(String name, String value, boolean caseInsensitive) {
        return this.headers.contains(HttpUtils.toLowerCase(name), value, caseInsensitive);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public Set<String> names() {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<CharSequence, CharSequence> header : this.headers) {
            names.add(header.getKey().toString());
        }
        return names;
    }

    @Override
    public MultiMap add(String name, String value) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader((CharSequence)name, value);
        }
        this.headers.add(HttpUtils.toLowerCase(name), value);
        return this;
    }

    @Override
    public MultiMap add(String name, Iterable<String> values2) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader((CharSequence)name, values2);
        }
        this.headers.add(HttpUtils.toLowerCase(name), values2);
        return this;
    }

    @Override
    public MultiMap addAll(MultiMap headers) {
        for (Map.Entry<String, String> entry : headers.entries()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap addAll(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap set(String name, String value) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader((CharSequence)name, value);
        }
        name = (String)HttpUtils.toLowerCase(name);
        if (value != null) {
            this.headers.set(name, value);
        } else {
            this.headers.remove(name);
        }
        return this;
    }

    @Override
    public MultiMap set(String name, Iterable<String> values2) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader((CharSequence)name, values2);
        }
        this.headers.set(HttpUtils.toLowerCase(name), values2);
        return this;
    }

    @Override
    public MultiMap setAll(MultiMap httpHeaders) {
        this.clear();
        for (Map.Entry entry : httpHeaders) {
            this.add((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap remove(String name) {
        this.headers.remove(HttpUtils.toLowerCase(name));
        return this;
    }

    @Override
    public MultiMap clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        final Iterator<Map.Entry<CharSequence, CharSequence>> i = this.headers.iterator();
        return new Iterator<Map.Entry<String, String>>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                final Map.Entry next = (Map.Entry)i.next();
                return new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return ((CharSequence)next.getKey()).toString();
                    }

                    @Override
                    public String getValue() {
                        return ((CharSequence)next.getValue()).toString();
                    }

                    @Override
                    public String setValue(String value) {
                        String old = ((CharSequence)next.getValue()).toString();
                        next.setValue(value);
                        return old;
                    }

                    public String toString() {
                        return next.toString();
                    }
                };
            }
        };
    }

    @Override
    public int size() {
        return this.names().size();
    }

    @Override
    public MultiMap setAll(Map<String, String> headers) {
        this.clear();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public String get(CharSequence name) {
        CharSequence val = (CharSequence)this.headers.get(HttpUtils.toLowerCase(name));
        return val != null ? val.toString() : null;
    }

    @Override
    public List<String> getAll(CharSequence name) {
        List all = this.headers.getAll(HttpUtils.toLowerCase(name));
        return all != null ? all.stream().map(CharSequence::toString).collect(Collectors.toList()) : null;
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.headers.contains(HttpUtils.toLowerCase(name));
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean caseInsensitive) {
        return this.headers.contains(HttpUtils.toLowerCase(name), value, caseInsensitive);
    }

    @Override
    public MultiMap add(CharSequence name, CharSequence value) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader(name, value);
        }
        this.headers.add(HttpUtils.toLowerCase(name), value);
        return this;
    }

    @Override
    public MultiMap add(CharSequence name, Iterable<CharSequence> values2) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader(name, values2);
        }
        this.headers.add(HttpUtils.toLowerCase(name), values2);
        return this;
    }

    @Override
    public MultiMap set(CharSequence name, CharSequence value) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader(name, value);
        }
        name = HttpUtils.toLowerCase(name);
        if (value != null) {
            this.headers.set(name, value);
        } else {
            this.headers.remove(name);
        }
        return this;
    }

    @Override
    public MultiMap set(CharSequence name, Iterable<CharSequence> values2) {
        if (!HttpHeaders.DISABLE_HTTP_HEADERS_VALIDATION) {
            HttpUtils.validateHeader(name, values2);
        }
        this.headers.set(HttpUtils.toLowerCase(name), values2);
        return this;
    }

    @Override
    public MultiMap remove(CharSequence name) {
        this.headers.remove(HttpUtils.toLowerCase(name));
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<CharSequence, CharSequence> header : this.headers) {
            sb.append(header).append('\n');
        }
        return sb.toString();
    }
}

