/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.VertxException;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;

public class BlockedThreadChecker {
    private static final Logger log = LoggerFactory.getLogger(BlockedThreadChecker.class);
    private final Map<Thread, Task> threads = new WeakHashMap<Thread, Task>();
    private final Timer timer = new Timer("vertx-blocked-thread-checker", true);

    BlockedThreadChecker(long interval, TimeUnit intervalUnit, final long warningExceptionTime, final TimeUnit warningExceptionTimeUnit) {
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BlockedThreadChecker blockedThreadChecker = BlockedThreadChecker.this;
                synchronized (blockedThreadChecker) {
                    long now = System.nanoTime();
                    for (Map.Entry entry : BlockedThreadChecker.this.threads.entrySet()) {
                        long execStart = ((Task)entry.getValue()).startTime();
                        long dur = now - execStart;
                        long timeLimit = ((Task)entry.getValue()).maxExecTime();
                        TimeUnit maxExecTimeUnit = ((Task)entry.getValue()).maxExecTimeUnit();
                        long val = maxExecTimeUnit.convert(dur, TimeUnit.NANOSECONDS);
                        if (execStart == 0L || val < timeLimit) continue;
                        String message = "Thread " + entry.getKey() + " has been blocked for " + dur / 1000000L + " ms, time limit is " + TimeUnit.MILLISECONDS.convert(timeLimit, maxExecTimeUnit) + " ms";
                        if (warningExceptionTimeUnit.convert(dur, TimeUnit.NANOSECONDS) <= warningExceptionTime) {
                            log.warn(message);
                            continue;
                        }
                        VertxException stackTrace = new VertxException("Thread blocked");
                        stackTrace.setStackTrace(((Thread)entry.getKey()).getStackTrace());
                        log.warn(message, stackTrace);
                    }
                }
            }
        }, intervalUnit.toMillis(interval), intervalUnit.toMillis(interval));
    }

    synchronized void registerThread(Thread thread2, Task checked) {
        this.threads.put(thread2, checked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.timer.cancel();
        BlockedThreadChecker blockedThreadChecker = this;
        synchronized (blockedThreadChecker) {
            this.threads.clear();
        }
    }

    public static interface Task {
        public long startTime();

        public long maxExecTime();

        public TimeUnit maxExecTimeUnit();
    }
}

