/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.middleware.cli.impl;

import com.taobao.middleware.cli.Argument;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.CommandLine;
import com.taobao.middleware.cli.Option;
import com.taobao.middleware.cli.UsageMessageFormatter;
import com.taobao.middleware.cli.impl.DefaultParser;
import com.taobao.middleware.cli.impl.Objects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class DefaultCLI
implements CLI {
    protected String name;
    protected String description;
    protected String summary;
    protected boolean hidden;
    protected boolean caseSensitive;
    protected List<Option> options = new ArrayList<Option>();
    private List<Argument> arguments = new ArrayList<Argument>();

    @Override
    public CommandLine parse(List<String> arguments) {
        DefaultParser parser = new DefaultParser();
        parser.setCaseSensitive(this.caseSensitive);
        return parser.parse(this, arguments);
    }

    @Override
    public CommandLine parse(List<String> arguments, boolean validate) {
        DefaultParser parser = new DefaultParser();
        parser.setCaseSensitive(this.caseSensitive);
        return parser.parse(this, arguments, validate);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CLI setName(String name) {
        Objects.requireNonNull(name);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Invalid command name");
        }
        this.name = name;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public CLI setDescription(String desc) {
        Objects.requireNonNull(desc);
        this.description = desc;
        return this;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public CLI setSummary(String summary) {
        Objects.requireNonNull(summary);
        this.summary = summary;
        return this;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public CLI setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public List<Option> getOptions() {
        return this.options;
    }

    @Override
    public CLI addOption(Option option) {
        Objects.requireNonNull(option);
        this.options.add(option);
        return this;
    }

    @Override
    public CLI addOptions(List<Option> options) {
        Objects.requireNonNull(options);
        for (Option option : options) {
            this.addOption(option);
        }
        return this;
    }

    @Override
    public CLI setOptions(List<Option> options) {
        Objects.requireNonNull(options);
        this.options = new ArrayList<Option>();
        return this.addOptions(options);
    }

    @Override
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public CLI addArgument(Argument arg) {
        Objects.requireNonNull(arg);
        this.arguments.add(arg);
        return this;
    }

    @Override
    public CLI addArguments(List<Argument> args2) {
        Objects.requireNonNull(args2);
        for (Argument arg : args2) {
            this.addArgument(arg);
        }
        return this;
    }

    @Override
    public CLI setArguments(List<Argument> args2) {
        Objects.requireNonNull(args2);
        this.arguments = new ArrayList<Argument>(args2);
        return this;
    }

    @Override
    public Option getOption(String name) {
        Objects.requireNonNull(name);
        for (Option option : this.options) {
            if (!this.optionOrArgumentEauals(name, option.getLongName())) continue;
            return option;
        }
        for (Option option : this.options) {
            if (!this.optionOrArgumentEauals(name, option.getShortName())) continue;
            return option;
        }
        for (Option option : this.options) {
            if (!this.optionOrArgumentEauals(name, option.getArgName())) continue;
            return option;
        }
        return null;
    }

    @Override
    public Argument getArgument(String name) {
        Objects.requireNonNull(name);
        for (Argument arg : this.arguments) {
            if (!this.optionOrArgumentEauals(name, arg.getArgName())) continue;
            return arg;
        }
        return null;
    }

    @Override
    public Argument getArgument(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Given index cannot be negative");
        }
        for (Argument arg : this.arguments) {
            if (index != arg.getIndex()) continue;
            return arg;
        }
        return null;
    }

    @Override
    public CLI removeOption(String name) {
        Iterator<Option> iterator2 = this.options.iterator();
        while (iterator2.hasNext()) {
            Option option = iterator2.next();
            if (!option.getLongName().equals(name) && !option.getShortName().equals(name)) continue;
            iterator2.remove();
        }
        return this;
    }

    @Override
    public CLI removeArgument(int index) {
        for (Argument arg : new TreeSet<Argument>(this.arguments)) {
            if (arg.getIndex() != index) continue;
            this.arguments.remove(arg);
            return this;
        }
        return this;
    }

    @Override
    public CLI usage(StringBuilder builder) {
        new UsageMessageFormatter().usage(builder, this);
        return this;
    }

    @Override
    public CLI usage(StringBuilder builder, String prefix) {
        new UsageMessageFormatter().usage(builder, prefix, this);
        return this;
    }

    @Override
    public CLI usage(StringBuilder builder, UsageMessageFormatter formatter) {
        if (formatter == null) {
            return this.usage(builder);
        }
        formatter.usage(builder, this);
        return this;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    private boolean optionOrArgumentEauals(String name1, String name2) {
        if (this.caseSensitive) {
            return name1.equals(name2);
        }
        return name1.equalsIgnoreCase(name2);
    }
}

