/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.nat.agent.proxy.factory;

import com.alibaba.arthas.nat.agent.proxy.registry.NativeAgentProxyRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NativeAgentProxyRegistryFactory {
    private static final String FILE_PATH = "META-INF/arthas/com.alibaba.arthas.native.agent.proxy.NativeAgentProxyRegistryFactory";
    private static Map<String, NativeAgentProxyRegistry> nativeAgentProxyRegistryMap = new ConcurrentHashMap<String, NativeAgentProxyRegistry>();
    private static volatile NativeAgentProxyRegistryFactory nativeAgentProxyRegistryFactory;

    private NativeAgentProxyRegistryFactory() {
        Map<String, String> registrationConfigMap = this.readConfigInfo(FILE_PATH);
        this.loadNativeAgentProxyRegistry2Map(registrationConfigMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NativeAgentProxyRegistryFactory getNativeAgentProxyRegistryFactory() {
        if (nativeAgentProxyRegistryFactory != null) return nativeAgentProxyRegistryFactory;
        Class<NativeAgentProxyRegistryFactory> clazz = NativeAgentProxyRegistryFactory.class;
        synchronized (NativeAgentProxyRegistryFactory.class) {
            if (nativeAgentProxyRegistryFactory != null) return nativeAgentProxyRegistryFactory;
            nativeAgentProxyRegistryFactory = new NativeAgentProxyRegistryFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return nativeAgentProxyRegistryFactory;
        }
    }

    private void loadNativeAgentProxyRegistry2Map(Map<String, String> registrationConfigMap) {
        for (Map.Entry<String, String> entry : registrationConfigMap.entrySet()) {
            String name = entry.getKey();
            String classPath = entry.getValue();
            try {
                Class<?> clazz = Class.forName(classPath);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                NativeAgentProxyRegistry instance = (NativeAgentProxyRegistry)constructor.newInstance(new Object[0]);
                nativeAgentProxyRegistryMap.put(name, instance);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Map<String, String> readConfigInfo(String filePath) {
        ConcurrentHashMap<String, String> nativeAgentDiscoveryConfigMap = new ConcurrentHashMap<String, String>();
        ClassLoader classLoader = NativeAgentProxyRegistryFactory.class.getClassLoader();
        try (InputStream inputStream2 = classLoader.getResourceAsStream(filePath);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2));){
            String line;
            if (inputStream2 == null) {
                throw new IllegalArgumentException("File not found: " + filePath);
            }
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (line.trim().isEmpty() || !line.contains("=") || (parts = line.split("=", 2)).length != 2) continue;
                nativeAgentDiscoveryConfigMap.put(parts[0].trim(), parts[1].trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nativeAgentDiscoveryConfigMap;
    }

    public NativeAgentProxyRegistry getNativeAgentProxyRegistry(String name) {
        return nativeAgentProxyRegistryMap.get(name);
    }
}

