/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.reader.ByteArrayValueConsumer;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.stream.StreamReader;
import com.alibaba.fastjson2.support.csv.CSVReader;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

final class CSVReaderUTF8<T>
extends CSVReader<T> {
    static final int ESCAPE_INDEX_NOT_SET = -2;
    int nextEscapeIndex = -2;
    static final Map<Long, Function<Consumer, ByteArrayValueConsumer>> valueConsumerCreators = new ConcurrentHashMap<Long, Function<Consumer, ByteArrayValueConsumer>>();
    byte[] buf;
    InputStream input;
    Charset charset = StandardCharsets.UTF_8;
    ByteArrayValueConsumer valueConsumer;

    CSVReaderUTF8(StreamReader.Feature ... features) {
        for (StreamReader.Feature feature : features) {
            this.features |= feature.mask;
        }
    }

    CSVReaderUTF8(byte[] bytes, int off, int len, Charset charset, Class<T> objectClass) {
        super(objectClass);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
        this.charset = charset;
    }

    CSVReaderUTF8(byte[] bytes, int off, int len, Charset charset, ByteArrayValueConsumer valueConsumer) {
        this.valueConsumer = valueConsumer;
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
        this.charset = charset;
    }

    CSVReaderUTF8(byte[] bytes, int off, int len, Type[] types) {
        super(types);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
        this.types = types;
    }

    CSVReaderUTF8(byte[] bytes, int off, int len, Class<T> objectClass) {
        super(objectClass);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
    }

    CSVReaderUTF8(InputStream input, Charset charset, Type[] types) {
        super(types);
        this.charset = charset;
        this.input = input;
    }

    CSVReaderUTF8(InputStream input, Charset charset, Class<T> objectClass) {
        super(objectClass);
        this.charset = charset;
        this.input = input;
    }

    CSVReaderUTF8(InputStream input, Charset charset, ByteArrayValueConsumer valueConsumer) {
        this.charset = charset;
        this.input = input;
        this.valueConsumer = valueConsumer;
    }

    static boolean containsQuoteOrLineSeparator(long v) {
        long x22 = v ^ 0x2222222222222222L;
        long x0a = v ^ 0xA0A0A0A0A0A0A0AL;
        long x0d = v ^ 0xD0D0D0D0D0D0D0DL;
        return (((x22 = x22 - 0x101010101010101L & (x22 ^ 0xFFFFFFFFFFFFFFFFL)) | (x0a = x0a - 0x101010101010101L & (x0a ^ 0xFFFFFFFFFFFFFFFFL)) | (x0d = x0d - 0x101010101010101L & (x0d ^ 0xFFFFFFFFFFFFFFFFL))) & 0x8080808080808080L) != 0L;
    }

    private byte[] getBuf() throws IOException {
        byte[] buf = this.buf;
        if (buf != null) {
            return buf;
        }
        return this.initBuf();
    }

    private byte[] initBuf() throws IOException {
        int end;
        int cnt;
        if (this.input == null) {
            throw new JSONException("init buf error");
        }
        byte[] buf = new byte[524288];
        for (end = 0; end < buf.length; end += cnt) {
            cnt = this.input.read(buf, this.off, buf.length - this.off);
            if (cnt != -1) continue;
            this.inputEnd = true;
            break;
        }
        this.end = end;
        if (end > 4 && IOUtils.isUTF8BOM(buf, 0)) {
            this.off = 3;
            this.lineNextStart = 3;
        }
        this.buf = buf;
        return buf;
    }

    @Override
    protected boolean seekLine() throws IOException {
        int lineSeparatorIndex;
        byte[] buf = this.getBuf();
        int off = this.off;
        int end = this.end;
        int escapeIndex = this.nextEscapeIndex;
        if (escapeIndex == -2 || escapeIndex != -1 && escapeIndex < off) {
            this.nextEscapeIndex = escapeIndex = IOUtils.indexOfDoubleQuote(buf, off, end);
        }
        if ((lineSeparatorIndex = IOUtils.indexOfLineSeparator(buf, off, end)) == -1) {
            if (this.input != null && !this.inputEnd) {
                int cnt;
                int rest = end - off;
                if (rest > 0) {
                    System.arraycopy(buf, off, buf, 0, rest);
                }
                for (end = rest; end < buf.length; end += cnt) {
                    cnt = this.input.read(buf, end, buf.length - end);
                    if (cnt != -1) {
                        continue;
                    }
                    this.inputEnd = true;
                    break;
                }
                this.nextEscapeIndex = escapeIndex >= off ? escapeIndex - off : IOUtils.indexOfDoubleQuote(buf, rest, end);
                lineSeparatorIndex = IOUtils.indexOfLineSeparator(buf, rest, end);
                off = 0;
                this.off = 0;
                this.end = end;
            }
            if (lineSeparatorIndex == -1 && this.inputEnd) {
                if (off < end) {
                    lineSeparatorIndex = end;
                } else {
                    return false;
                }
            }
        }
        if (lineSeparatorIndex != -1 && (escapeIndex == -1 || escapeIndex > lineSeparatorIndex)) {
            this.lineTerminated = true;
            this.lineStart = off;
            this.lineEnd = lineSeparatorIndex != off && buf[lineSeparatorIndex - 1] == 13 ? lineSeparatorIndex - 1 : lineSeparatorIndex;
            this.off = lineSeparatorIndex + 1;
            return true;
        }
        return this.seekLine0(buf, off, end);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean seekLine0(byte[] buf, int off, int end) throws IOException {
        int lineNextStart = off;
        for (int k = 0; k < 3; ++k) {
            this.lineTerminated = false;
            for (int i = off; i < end; ++i) {
                int n;
                byte ch = buf[i];
                if (ch == 34) {
                    ++this.lineSize;
                    if (!this.quote) {
                        this.quote = true;
                        continue;
                    }
                    n = i + 1;
                    if (n >= end) break;
                    if (buf[n] == 34) {
                        ++this.lineSize;
                        ++i;
                        continue;
                    }
                    this.quote = false;
                    continue;
                }
                if (this.quote) {
                    ++this.lineSize;
                    continue;
                }
                if (ch == 13 || ch == 10) {
                    if (this.lineSize > 0 || (this.features & StreamReader.Feature.IgnoreEmptyLine.mask) == 0L) {
                        ++this.rowCount;
                    }
                    this.lineTerminated = true;
                    this.lineSize = 0;
                    this.lineEnd = i;
                    if (ch == 13) {
                        n = i + 1;
                        if (n >= end) break;
                        if (buf[n] == 10) {
                            ++i;
                        }
                    }
                    this.lineStart = lineNextStart;
                    lineNextStart = off = i + 1;
                    break;
                }
                ++this.lineSize;
            }
            if (!this.lineTerminated) {
                if (this.input != null && !this.inputEnd) {
                    int cnt;
                    int len = end - off;
                    int escapedIndex = this.nextEscapeIndex;
                    if (off > 0) {
                        if (len > 0) {
                            System.arraycopy(buf, off, buf, 0, len);
                            this.nextEscapeIndex = escapedIndex >= off ? escapedIndex - off : -2;
                        }
                        lineNextStart = 0;
                        this.lineStart = 0;
                        off = 0;
                        end = len;
                        this.quote = false;
                    }
                    if ((cnt = this.input.read(buf, end, buf.length - end)) == -1) {
                        this.inputEnd = true;
                        if (off == end) {
                            this.off = off;
                            return false;
                        }
                    } else {
                        this.end = end += cnt;
                        continue;
                    }
                }
                this.lineStart = lineNextStart;
                this.lineEnd = end;
                ++this.rowCount;
                this.lineSize = 0;
                off = end;
            }
            this.lineTerminated = off == end;
            break;
        }
        this.off = off;
        return true;
    }

    Object readValue(byte[] bytes, int off, int len, Type type) {
        if (len == 0) {
            return null;
        }
        if (type == Integer.class) {
            return TypeUtils.parseInt(bytes, off, len);
        }
        if (type == Long.class) {
            return TypeUtils.parseLong(bytes, off, len);
        }
        if (type == BigDecimal.class) {
            return TypeUtils.parseBigDecimal(bytes, off, len);
        }
        if (type == Float.class) {
            return Float.valueOf(TypeUtils.parseFloat(bytes, off, len));
        }
        if (type == Double.class) {
            return TypeUtils.parseDouble(bytes, off, len);
        }
        if (type == Date.class) {
            long millis = DateUtils.parseMillis(bytes, off, len, this.charset, DateUtils.DEFAULT_ZONE_ID);
            return new Date(millis);
        }
        if (type == Boolean.class) {
            return TypeUtils.parseBoolean(bytes, off, len);
        }
        String str = new String(bytes, off, len, this.charset);
        return TypeUtils.cast((Object)str, type);
    }

    @Override
    public boolean isEnd() {
        return this.inputEnd;
    }

    @Override
    public Object[] readLineValues(boolean strings) {
        try {
            if (this.inputEnd && this.off == this.end) {
                return null;
            }
            if (this.input == null && this.off >= this.end) {
                return null;
            }
            boolean result = this.seekLine();
            if (!result) {
                return null;
            }
        }
        catch (IOException e) {
            throw new JSONException("seekLine error", e);
        }
        int escapedIndex = this.nextEscapeIndex;
        return escapedIndex == -1 || escapedIndex >= this.lineEnd ? this.readLineValue(strings) : this.readLineValueEscaped(strings);
    }

    private Object[] readLineValue(boolean strings) {
        List columns = this.columns;
        Object[] values2 = null;
        ArrayList<Object> valueList = null;
        if (columns != null) {
            int size = columns.size();
            values2 = strings ? new String[size] : new Object[size];
        } else {
            valueList = new ArrayList<Object>();
        }
        int valueStart = this.lineStart;
        int lineEnd = this.lineEnd;
        int valueSize = 0;
        int columnIndex = 0;
        byte[] buf = this.buf;
        for (int i = this.lineStart; i < lineEnd; ++i) {
            if (buf[i] == 44) {
                this.readValue(strings, columnIndex, valueSize, buf, valueStart, values2, valueList);
                valueStart = i + 1;
                valueSize = 0;
                ++columnIndex;
                continue;
            }
            ++valueSize;
        }
        if (valueSize > 0) {
            this.readValue(strings, columnIndex, valueSize, buf, valueStart, values2, valueList);
        }
        if (values2 == null && valueList != null) {
            int size = valueList.size();
            values2 = strings ? new String[size] : new Object[size];
            valueList.toArray(values2);
        }
        if (this.input == null && this.off == this.end) {
            this.inputEnd = true;
        }
        return values2;
    }

    private void readValue(boolean strings, int columnIndex, int valueSize, byte[] buf, int valueStart, Object[] values2, List<Object> valueList) {
        Object value;
        Type type;
        Type type2 = type = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
        if (type == null || type == String.class || type == Object.class || strings) {
            byte c1;
            byte c0;
            value = valueSize == 1 && (c0 = buf[valueStart]) >= 0 ? TypeUtils.toString((char)c0) : (valueSize == 2 && (c0 = buf[valueStart]) >= 0 && (c1 = buf[valueStart + 1]) >= 0 ? TypeUtils.toString((char)c0, (char)c1) : new String(buf, valueStart, valueSize, this.charset));
        } else {
            try {
                value = this.readValue(buf, valueStart, valueSize, type);
            }
            catch (Exception e) {
                value = this.error(columnIndex, e);
            }
        }
        if (values2 != null) {
            if (columnIndex < values2.length) {
                values2[columnIndex] = value;
            }
        } else {
            valueList.add(value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] readLineValueEscaped(boolean strings) {
        ArrayList<Object> valueList;
        Object[] values2;
        block56: {
            Object value;
            int columnIndex;
            block52: {
                Type type;
                byte c1;
                byte[] buf;
                int valueSize;
                int valueStart;
                block57: {
                    List columns = this.columns;
                    values2 = null;
                    valueList = null;
                    if (columns != null) {
                        int size = columns.size();
                        values2 = strings ? new String[size] : new Object[size];
                    }
                    boolean quote = false;
                    valueStart = this.lineStart;
                    int lineEnd = this.lineEnd;
                    valueSize = 0;
                    int escapeCount = 0;
                    columnIndex = 0;
                    buf = this.buf;
                    for (int i = this.lineStart; i < lineEnd; ++i) {
                        block54: {
                            Object value2;
                            block51: {
                                Type type2;
                                block55: {
                                    byte ch;
                                    block50: {
                                        block53: {
                                            ch = buf[i];
                                            if (!quote) break block53;
                                            if (ch == 34) {
                                                int n = i + 1;
                                                if (n < lineEnd) {
                                                    c1 = buf[n];
                                                    if (c1 == 34) {
                                                        valueSize += 2;
                                                        ++escapeCount;
                                                        ++i;
                                                        continue;
                                                    }
                                                    if (c1 == 44) {
                                                        ++i;
                                                        ch = c1;
                                                    }
                                                    break block50;
                                                } else if (n == lineEnd) {
                                                    break;
                                                }
                                                break block50;
                                            } else {
                                                ++valueSize;
                                                continue;
                                            }
                                        }
                                        if (ch == 34) {
                                            quote = true;
                                            continue;
                                        }
                                    }
                                    if (ch != 44) break block54;
                                    Type type3 = type2 = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
                                    if (!quote) break block55;
                                    if (escapeCount == 0) {
                                        if (type2 == null || type2 == String.class || type2 == Object.class || strings) {
                                            value2 = new String(buf, valueStart + 1, valueSize, this.charset);
                                            break block51;
                                        } else {
                                            try {
                                                value2 = this.readValue(buf, valueStart + 1, valueSize, type2);
                                            }
                                            catch (Exception e) {
                                                value2 = this.error(columnIndex, e);
                                            }
                                        }
                                        break block51;
                                    } else {
                                        byte[] bytes = new byte[valueSize - escapeCount];
                                        int valueEnd = valueStart + valueSize;
                                        int k = 0;
                                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                                            byte c = buf[j];
                                            bytes[k++] = c;
                                            if (c != 34 || buf[j + 1] != 34) continue;
                                            ++j;
                                        }
                                        if (type2 == null || type2 == String.class || type2 == Object.class) {
                                            value2 = new String(bytes, this.charset);
                                            break block51;
                                        } else {
                                            try {
                                                value2 = this.readValue(bytes, 0, bytes.length, type2);
                                            }
                                            catch (Exception e) {
                                                value2 = this.error(columnIndex, e);
                                            }
                                        }
                                    }
                                    break block51;
                                }
                                if (type2 == null || type2 == String.class || type2 == Object.class || strings) {
                                    byte c12;
                                    byte c0;
                                    value2 = valueSize == 1 && (c0 = buf[valueStart]) >= 0 ? TypeUtils.toString((char)c0) : (valueSize == 2 && (c0 = buf[valueStart]) >= 0 && (c12 = buf[valueStart + 1]) >= 0 ? TypeUtils.toString((char)c0, (char)c12) : new String(buf, valueStart, valueSize, this.charset));
                                } else {
                                    try {
                                        value2 = this.readValue(buf, valueStart, valueSize, type2);
                                    }
                                    catch (Exception e) {
                                        value2 = this.error(columnIndex, e);
                                    }
                                }
                            }
                            if (values2 != null) {
                                if (columnIndex < values2.length) {
                                    values2[columnIndex] = value2;
                                }
                            } else {
                                if (valueList == null) {
                                    valueList = new ArrayList();
                                }
                                valueList.add(value2);
                            }
                            quote = false;
                            valueStart = i + 1;
                            valueSize = 0;
                            escapeCount = 0;
                            ++columnIndex;
                            continue;
                        }
                        ++valueSize;
                    }
                    if (valueSize <= 0 && !quote) break block56;
                    Type type4 = type = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
                    if (!quote) break block57;
                    if (escapeCount == 0) {
                        if (type == null || type == String.class || type == Object.class || strings) {
                            value = new String(buf, valueStart + 1, valueSize, this.charset);
                            break block52;
                        } else {
                            try {
                                value = this.readValue(buf, valueStart + 1, valueSize, type);
                            }
                            catch (Exception e) {
                                value = this.error(columnIndex, e);
                            }
                        }
                        break block52;
                    } else {
                        byte[] bytes = new byte[valueSize - escapeCount];
                        int valueEnd = lineEnd;
                        int k = 0;
                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                            byte c = buf[j];
                            bytes[k++] = c;
                            if (c != 34 || buf[j + 1] != 34) continue;
                            ++j;
                        }
                        if (type == null || type == String.class || type == Object.class || strings) {
                            value = new String(bytes, 0, bytes.length, this.charset);
                            break block52;
                        } else {
                            try {
                                value = this.readValue(bytes, 0, bytes.length, type);
                            }
                            catch (Exception e) {
                                value = this.error(columnIndex, e);
                            }
                        }
                    }
                    break block52;
                }
                if (type == null || type == String.class || type == Object.class || strings) {
                    byte c0;
                    value = valueSize == 1 && (c0 = buf[valueStart]) >= 0 ? TypeUtils.toString((char)c0) : (valueSize == 2 && (c0 = buf[valueStart]) >= 0 && (c1 = buf[valueStart + 1]) >= 0 ? TypeUtils.toString((char)c0, (char)c1) : new String(buf, valueStart, valueSize, this.charset));
                } else {
                    try {
                        value = this.readValue(buf, valueStart, valueSize, type);
                    }
                    catch (Exception e) {
                        value = this.error(columnIndex, e);
                    }
                }
            }
            if (values2 != null) {
                if (columnIndex < values2.length) {
                    values2[columnIndex] = value;
                }
            } else {
                if (valueList == null) {
                    valueList = new ArrayList<Object>();
                }
                valueList.add(value);
            }
        }
        if (values2 == null && valueList != null) {
            int size = valueList.size();
            values2 = strings ? new String[size] : new Object[size];
            valueList.toArray(values2);
        }
        if (this.input == null && this.off == this.end) {
            this.inputEnd = true;
        }
        return values2;
    }

    @Override
    public void close() {
        if (this.input != null) {
            IOUtils.close(this.input);
        }
    }

    @Override
    public void statAll() {
        ByteArrayValueConsumer consumer = (row, column, bytes, off, len, charset) -> {
            StreamReader.ColumnStat stat = this.getColumnStat(column);
            stat.stat(bytes, off, len, charset);
        };
        this.readAll(consumer, Integer.MAX_VALUE);
    }

    @Override
    public void statAll(int maxRows) {
        ByteArrayValueConsumer consumer = (row, column, bytes, off, len, charset) -> {
            StreamReader.ColumnStat stat = this.getColumnStat(column);
            stat.stat(bytes, off, len, charset);
        };
        this.readAll(consumer, maxRows);
    }

    @Override
    public void readAll() {
        if (this.valueConsumer == null) {
            throw new JSONException("unsupported operation, consumer is null");
        }
        this.readAll(this.valueConsumer, Integer.MAX_VALUE);
    }

    @Override
    public void readAll(int maxRows) {
        if (this.valueConsumer == null) {
            throw new JSONException("unsupported operation, consumer is null");
        }
        this.readAll(this.valueConsumer, maxRows);
    }

    @Override
    public void readLineObjectAll(boolean readHeader, Consumer<T> consumer) {
        if (readHeader) {
            this.readHeader();
        }
        if (this.fieldReaders == null) {
            Object[] line;
            while ((line = this.readLineValues(false)) != null) {
                consumer.accept(line);
            }
            return;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        if (this.fieldReaders == null && this.objectClass != null) {
            ObjectReaderAdapter objectReader = (ObjectReaderAdapter)provider.getObjectReader(this.objectClass);
            this.fieldReaders = objectReader.getFieldReaders();
            this.objectCreator = provider.createObjectCreator(this.objectClass, this.features);
        }
        String[] strings = new String[this.fieldReaders.length + 1];
        strings[0] = this.objectClass.getName();
        for (int i = 0; i < this.fieldReaders.length; ++i) {
            strings[i + 1] = this.fieldReaders[i].fieldName;
        }
        long fullNameHash = Fnv.hashCode64(strings);
        Function<Consumer, ByteArrayValueConsumer> valueConsumerCreator = valueConsumerCreators.get(fullNameHash);
        if (valueConsumerCreator == null && (valueConsumerCreator = provider.createValueConsumerCreator(this.objectClass, this.fieldReaders)) != null) {
            valueConsumerCreators.putIfAbsent(fullNameHash, valueConsumerCreator);
        }
        ByteArrayValueConsumer bytesConsumer = null;
        if (valueConsumerCreator != null) {
            bytesConsumer = valueConsumerCreator.apply(consumer);
        }
        if (bytesConsumer == null) {
            bytesConsumer = new ByteArrayConsumerImpl(consumer);
        }
        this.readAll(bytesConsumer, Integer.MAX_VALUE);
    }

    private void readAll(ByteArrayValueConsumer consumer, int maxRows) {
        consumer.start();
        for (int r = 0; r < maxRows || maxRows < 0; ++r) {
            try {
                boolean result;
                if (this.inputEnd & this.off == this.end || this.input == null && this.off >= this.end || !(result = this.seekLine())) {
                    break;
                }
            }
            catch (IOException e) {
                throw new JSONException("seekLine error", e);
            }
            consumer.beforeRow(this.rowCount);
            int escapedIndex = this.nextEscapeIndex;
            if (escapedIndex == -1 || escapedIndex >= this.lineEnd) {
                this.readLine(consumer);
            } else {
                this.readLineEscaped(consumer);
            }
            consumer.afterRow(this.rowCount);
        }
        consumer.end();
    }

    private void readLine(ByteArrayValueConsumer consumer) {
        int valueStart = this.lineStart;
        int valueSize = 0;
        int columnIndex = 0;
        byte[] buf = this.buf;
        for (int i = this.lineStart; i < this.lineEnd; ++i) {
            if (buf[i] == 44) {
                consumer.accept(this.rowCount, columnIndex, buf, valueStart, valueSize, this.charset);
                valueStart = i + 1;
                valueSize = 0;
                ++columnIndex;
                continue;
            }
            ++valueSize;
        }
        if (valueSize > 0) {
            consumer.accept(this.rowCount, columnIndex, buf, valueStart, valueSize, this.charset);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readLineEscaped(ByteArrayValueConsumer consumer) {
        boolean quote = false;
        int valueStart = this.lineStart;
        int valueSize = 0;
        int escapeCount = 0;
        int columnIndex = 0;
        for (int i = this.lineStart; i < this.lineEnd; ++i) {
            byte ch;
            block21: {
                block24: {
                    ch = this.buf[i];
                    if (!quote) break block24;
                    if (ch == 34) {
                        int n = i + 1;
                        if (n < this.lineEnd) {
                            byte c1 = this.buf[n];
                            if (c1 == 34) {
                                valueSize += 2;
                                ++escapeCount;
                                ++i;
                                continue;
                            }
                            if (c1 == 44) {
                                ++i;
                                ch = c1;
                            }
                            break block21;
                        } else if (n == this.lineEnd) {
                            break;
                        }
                        break block21;
                    } else {
                        ++valueSize;
                        continue;
                    }
                }
                if (ch == 34) {
                    quote = true;
                    continue;
                }
            }
            if (ch == 44) {
                byte[] columnBuf = this.buf;
                int columnStart = 0;
                int columnSize = valueSize;
                if (quote) {
                    if (escapeCount == 0) {
                        columnStart = valueStart + 1;
                    } else {
                        byte[] bytes = new byte[valueSize - escapeCount];
                        int valueEnd = valueStart + valueSize;
                        int k = 0;
                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                            byte c = this.buf[j];
                            bytes[k++] = c;
                            if (c != 34 || this.buf[j + 1] != 34) continue;
                            ++j;
                        }
                        columnBuf = bytes;
                        columnSize = bytes.length;
                    }
                } else {
                    columnStart = valueStart;
                }
                consumer.accept(this.rowCount, columnIndex, columnBuf, columnStart, columnSize, this.charset);
                quote = false;
                valueStart = i + 1;
                valueSize = 0;
                escapeCount = 0;
                ++columnIndex;
                continue;
            }
            ++valueSize;
        }
        if (valueSize > 0) {
            byte[] columnBuf = this.buf;
            int columnStart = 0;
            int columnSize = valueSize;
            if (quote) {
                if (escapeCount == 0) {
                    columnStart = valueStart + 1;
                } else {
                    byte[] bytes = new byte[valueSize - escapeCount];
                    int valueEnd = this.lineEnd;
                    int k = 0;
                    for (int j = valueStart + 1; j < valueEnd; ++j) {
                        byte c = this.buf[j];
                        bytes[k++] = c;
                        if (c != 34 || this.buf[j + 1] != 34) continue;
                        ++j;
                    }
                    columnBuf = bytes;
                    columnSize = bytes.length;
                }
            } else {
                columnStart = valueStart;
            }
            consumer.accept(this.rowCount, columnIndex, columnBuf, columnStart, columnSize, this.charset);
        }
    }

    class ByteArrayConsumerImpl
    implements ByteArrayValueConsumer {
        protected Object object;
        final Consumer consumer;

        public ByteArrayConsumerImpl(Consumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public final void beforeRow(int row) {
            if (CSVReaderUTF8.this.objectCreator != null) {
                this.object = CSVReaderUTF8.this.objectCreator.get();
            }
        }

        @Override
        public void accept(int row, int column, byte[] bytes, int off, int len, Charset charset) {
            if (column >= CSVReaderUTF8.this.fieldReaders.length || len == 0) {
                return;
            }
            FieldReader fieldReader = CSVReaderUTF8.this.fieldReaders[column];
            Object fieldValue = CSVReaderUTF8.this.readValue(bytes, off, len, fieldReader.fieldType);
            fieldReader.accept(this.object, fieldValue);
        }

        @Override
        public final void afterRow(int row) {
            this.consumer.accept(this.object);
            this.object = null;
        }
    }
}

