/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpClosedException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.CookieJar;
import io.vertx.core.http.impl.Http2ServerConnection;
import io.vertx.core.http.impl.Http2ServerStream;
import io.vertx.core.http.impl.HttpNetSocket;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetSocket;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.core.streams.ReadStream;
import java.util.Set;

public class Http2ServerResponse
implements HttpServerResponse,
HttpResponse {
    private final Http2ServerStream stream;
    private final ChannelHandlerContext ctx;
    private final Http2ServerConnection conn;
    private final boolean push;
    private final String host;
    private final String contentEncoding;
    private final Http2Headers headers = new DefaultHttp2Headers();
    private Http2HeadersAdaptor headersMap;
    private Http2Headers trailers;
    private Http2HeadersAdaptor trailedMap;
    private boolean chunked;
    private boolean headWritten;
    private boolean ended;
    private boolean closed;
    private CookieJar cookies;
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private String statusMessage;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> headersEndHandler;
    private Handler<Void> bodyEndHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    private Future<NetSocket> netSocket;

    public Http2ServerResponse(Http2ServerConnection conn, Http2ServerStream stream, boolean push, String contentEncoding, String host) {
        this.stream = stream;
        this.ctx = conn.handlerContext;
        this.conn = conn;
        this.push = push;
        this.host = host;
        this.contentEncoding = contentEncoding;
    }

    boolean isPush() {
        return this.push;
    }

    void handleReset(long code) {
        this.handleException(new StreamResetException(code));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable cause) {
        Handler<Throwable> handler;
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            handler = this.exceptionHandler;
        }
        if (handler != null) {
            handler.handle(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClose(HttpClosedException ex) {
        Handler<Void> closeHandler;
        Handler<Void> endHandler;
        Handler<Throwable> exceptionHandler;
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.closed = true;
            boolean failed = !this.ended;
            exceptionHandler = failed ? this.exceptionHandler : null;
            endHandler = failed ? this.endHandler : null;
            closeHandler = this.closeHandler;
        }
        if (exceptionHandler != null) {
            this.stream.context.emit(ex, exceptionHandler);
        }
        if (endHandler != null) {
            this.stream.context.emit(null, endHandler);
        }
        if (closeHandler != null) {
            this.stream.context.emit(null, closeHandler);
        }
    }

    private void checkHeadWritten() {
        if (this.headWritten) {
            throw new IllegalStateException("Response head already sent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.exceptionHandler = handler;
            return this;
        }
    }

    @Override
    public int statusCode() {
        return this.getStatusCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStatusCode() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.status.code();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusCode(int statusCode) {
        if (statusCode < 0) {
            throw new IllegalArgumentException("code: " + statusCode + " (expected: 0+)");
        }
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.status = HttpResponseStatus.valueOf(statusCode);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatusMessage() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.statusMessage == null) {
                return this.status.reasonPhrase();
            }
            return this.statusMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusMessage(String statusMessage) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.statusMessage = statusMessage;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setChunked(boolean chunked) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.chunked = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChunked() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.chunked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap headers() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.headersMap == null) {
                this.headersMap = new Http2HeadersAdaptor(this.headers);
            }
            return this.headersMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(String name, String value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(String name, Iterable<String> values2) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().set(name, values2);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values2) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().set(name, values2);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap trailers() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.trailedMap == null) {
                this.trailers = new DefaultHttp2Headers();
                this.trailedMap = new Http2HeadersAdaptor(this.trailers);
            }
            return this.trailedMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(String name, String value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(String name, Iterable<String> values2) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.trailers().set(name, values2);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse closeHandler(Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.closeHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse endHandler(@Nullable Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.endHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse writeContinue() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.stream.writeHeaders(new DefaultHttp2Headers().status("100"), false, null);
            return this;
        }
    }

    @Override
    public Future<Void> write(Buffer chunk) {
        ByteBuf buf = chunk.getByteBuf();
        PromiseInternal<Void> promise = this.stream.context.promise();
        this.write(buf, false, promise);
        return promise.future();
    }

    @Override
    public void write(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        ByteBuf buf = chunk.getByteBuf();
        this.write(buf, false, handler);
    }

    @Override
    public Future<Void> write(String chunk, String enc) {
        PromiseInternal<Void> promise = this.stream.context.promise();
        this.write(Buffer.buffer(chunk, enc).getByteBuf(), false, promise);
        return promise.future();
    }

    @Override
    public void write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.write(Buffer.buffer(chunk, enc).getByteBuf(), false, handler);
    }

    @Override
    public Future<Void> write(String chunk) {
        PromiseInternal<Void> promise = this.stream.context.promise();
        this.write(Buffer.buffer(chunk).getByteBuf(), false, promise);
        return promise.future();
    }

    @Override
    public void write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.write(Buffer.buffer(chunk).getByteBuf(), false, handler);
    }

    private Http2ServerResponse write(ByteBuf chunk) {
        this.write(chunk, false, null);
        return this;
    }

    @Override
    public Future<Void> end(String chunk) {
        return this.end(Buffer.buffer(chunk));
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.end(Buffer.buffer(chunk), handler);
    }

    @Override
    public Future<Void> end(String chunk, String enc) {
        return this.end(Buffer.buffer(chunk, enc));
    }

    @Override
    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.end(Buffer.buffer(chunk, enc));
    }

    @Override
    public Future<Void> end(Buffer chunk) {
        PromiseInternal<Void> promise = this.stream.context.promise();
        this.write(chunk.getByteBuf(), true, promise);
        return promise.future();
    }

    @Override
    public void end(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.end(chunk.getByteBuf(), handler);
    }

    @Override
    public Future<Void> end() {
        PromiseInternal<Void> promise = this.stream.context.promise();
        this.write(null, true, promise);
        return promise.future();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.end((ByteBuf)null, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<NetSocket> netSocket() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.netSocket == null) {
                this.status = HttpResponseStatus.OK;
                if (!this.checkSendHeaders(false)) {
                    this.netSocket = this.stream.context.failedFuture("Response for CONNECT already sent");
                } else {
                    this.ctx.flush();
                    HttpNetSocket ns = HttpNetSocket.netSocket(this.conn, this.stream.context, (ReadStream)((Object)this.stream), this);
                    this.netSocket = Future.succeededFuture(ns);
                }
            }
        }
        return this.netSocket;
    }

    @Override
    private void end(ByteBuf chunk, Handler<AsyncResult<Void>> handler) {
        this.write(chunk, true, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(ByteBuf chunk, boolean end, Handler<AsyncResult<Void>> handler) {
        Handler<Void> endHandler;
        Handler<Void> bodyEndHandler;
        boolean invokeHandler = false;
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.ended) {
                throw new IllegalStateException("Response has already been written");
            }
            this.ended = end;
            boolean hasBody = false;
            if (chunk != null) {
                hasBody = true;
            } else {
                chunk = Unpooled.EMPTY_BUFFER;
            }
            if (end && !this.headWritten && this.needsContentLengthHeader()) {
                this.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(chunk.readableBytes()));
            }
            boolean sent = this.checkSendHeaders(end && !hasBody && this.trailers == null);
            if (hasBody || !sent && end) {
                this.stream.writeData(chunk, end && this.trailers == null, handler);
            } else {
                invokeHandler = true;
            }
            if (end && this.trailers != null) {
                this.stream.writeHeaders(this.trailers, true, null);
            }
            bodyEndHandler = this.bodyEndHandler;
            endHandler = this.endHandler;
        }
        if (end) {
            if (bodyEndHandler != null) {
                bodyEndHandler.handle(null);
            }
            if (endHandler != null) {
                endHandler.handle(null);
            }
            if (invokeHandler) {
                handler.handle(Future.succeededFuture());
            }
        }
    }

    private boolean needsContentLengthHeader() {
        return this.stream.method != HttpMethod.HEAD && this.status != HttpResponseStatus.NOT_MODIFIED && !this.headers.contains(HttpHeaderNames.CONTENT_LENGTH);
    }

    private boolean checkSendHeaders(boolean end) {
        if (!this.headWritten) {
            if (this.headersEndHandler != null) {
                this.headersEndHandler.handle(null);
            }
            if (this.cookies != null) {
                this.setCookies();
            }
            this.prepareHeaders();
            this.headWritten = true;
            this.stream.writeHeaders(this.headers, end, null);
            if (end) {
                this.ctx.flush();
            }
            return true;
        }
        return false;
    }

    private void prepareHeaders() {
        this.headers.status(Integer.toString(this.status.code()));
        if (this.contentEncoding != null && this.headers.get(HttpHeaderNames.CONTENT_ENCODING) == null) {
            this.headers.set(HttpHeaderNames.CONTENT_ENCODING, this.contentEncoding);
        }
        if (this.stream.method == HttpMethod.HEAD || this.status == HttpResponseStatus.NOT_MODIFIED) {
            this.headers.remove(HttpHeaders.TRANSFER_ENCODING);
        } else if (this.status == HttpResponseStatus.RESET_CONTENT) {
            this.headers.remove(HttpHeaders.TRANSFER_ENCODING);
            this.headers.set(HttpHeaders.CONTENT_LENGTH, "0");
        } else if (this.status.codeClass() == HttpStatusClass.INFORMATIONAL || this.status == HttpResponseStatus.NO_CONTENT) {
            this.headers.remove(HttpHeaders.TRANSFER_ENCODING);
            this.headers.remove(HttpHeaders.CONTENT_LENGTH);
        }
    }

    private void setCookies() {
        for (ServerCookie cookie : this.cookies) {
            if (!cookie.isChanged()) continue;
            this.headers.add(HttpHeaders.SET_COOKIE, cookie.encode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse writeCustomFrame(int type, int flags, Buffer payload) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.checkSendHeaders(false);
            this.stream.writeFrame(type, flags, payload.getByteBuf());
            this.ctx.flush();
            return this;
        }
    }

    private void checkValid() {
        if (this.ended) {
            throw new IllegalStateException("Response has already been written");
        }
    }

    void handlerWritabilityChanged(boolean writable) {
        if (!this.ended && writable && this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            return this.stream.isNotWritable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse drainHandler(Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.drainHandler = handler;
            return this;
        }
    }

    @Override
    public Future<Void> sendFile(String filename, long offset, long length) {
        PromiseInternal<Void> promise = this.stream.context.promise();
        this.sendFile(filename, offset, length, promise);
        return promise.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        Handler<AsyncResult> h2;
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
        }
        if (resultHandler != null) {
            ContextInternal resultCtx = this.stream.vertx.getOrCreateContext();
            h2 = ar -> resultCtx.runOnContext(v -> resultHandler.handle((AsyncResult<Void>)ar));
        } else {
            h2 = ar -> {};
        }
        HttpUtils.resolveFile(this.stream.vertx, filename, offset, length, ar -> {
            if (ar.succeeded()) {
                String contentType;
                AsyncFile file = (AsyncFile)ar.result();
                long contentLength = Math.min(length, file.getReadLength());
                if (this.headers.get(HttpHeaderNames.CONTENT_LENGTH) == null) {
                    this.putHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(contentLength));
                }
                if (this.headers.get(HttpHeaderNames.CONTENT_TYPE) == null && (contentType = MimeMapping.getMimeTypeForFilename(filename)) != null) {
                    this.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)contentType);
                }
                this.checkSendHeaders(false);
                file.pipeTo(this, ar1 -> file.close(ar2 -> {
                    Throwable failure;
                    Throwable throwable = ar1.failed() ? ar1.cause() : (failure = ar2.failed() ? ar2.cause() : null);
                    if (failure == null) {
                        h2.handle((AsyncResult)ar1);
                    } else {
                        h2.handle(Future.failedFuture(failure));
                    }
                }));
            } else {
                h2.handle(ar.mapEmpty());
            }
        });
        return this;
    }

    @Override
    public void close() {
        this.conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ended() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.ended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean closed() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean headWritten() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.headWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse headersEndHandler(@Nullable Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.headersEndHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse bodyEndHandler(@Nullable Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.bodyEndHandler = handler;
            return this;
        }
    }

    @Override
    public long bytesWritten() {
        return this.stream.bytesWritten();
    }

    @Override
    public int streamId() {
        return this.stream.id();
    }

    @Override
    public boolean reset(long code) {
        if (this.ended) {
            return false;
        }
        this.stream.writeReset(code);
        this.ctx.flush();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<HttpServerResponse> push(HttpMethod method, String host, String path, MultiMap headers) {
        if (this.push) {
            throw new IllegalStateException("A push response cannot promise another push");
        }
        if (host == null) {
            host = this.host;
        }
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
        }
        PromiseInternal<HttpServerResponse> promise = this.stream.context.promise();
        this.conn.sendPush(this.stream.id(), host, method, headers, path, this.stream.priority(), promise);
        return promise.future();
    }

    @Override
    public HttpServerResponse setStreamPriority(StreamPriority priority) {
        this.stream.updatePriority(priority);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CookieJar cookies() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.cookies == null) {
                CharSequence cookieHeader = this.stream.headers != null ? (CharSequence)this.stream.headers.get(HttpHeaders.COOKIE) : null;
                this.cookies = cookieHeader == null ? new CookieJar() : new CookieJar(cookieHeader);
            }
        }
        return this.cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse addCookie(Cookie cookie) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.cookies().add((ServerCookie)cookie);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Cookie removeCookie(String name, boolean invalidate) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            return this.cookies().removeOrInvalidate(name, invalidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Cookie removeCookie(String name, String domain, String path, boolean invalidate) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            return this.cookies().removeOrInvalidate(name, domain, path, invalidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Set<Cookie> removeCookies(String name, boolean invalidate) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            return this.cookies().removeOrInvalidateAll(name, invalidate);
        }
    }
}

