/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.MultiType;
import java.lang.reflect.Type;
import java.util.Collection;

final class ObjectArrayReaderMultiType
implements ObjectReader {
    final Type[] types;
    final ObjectReader[] readers;

    ObjectArrayReaderMultiType(MultiType multiType) {
        Type[] types = new Type[multiType.size()];
        for (int i = 0; i < multiType.size(); ++i) {
            types[i] = multiType.getType(i);
        }
        this.types = types;
        this.readers = new ObjectReader[types.length];
    }

    ObjectReader getObjectReader(JSONReader jsonReader, int index) {
        ObjectReader objectReader = this.readers[index];
        if (objectReader == null) {
            Type type = this.types[index];
            this.readers[index] = objectReader = jsonReader.getObjectReader(type);
        }
        return objectReader;
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.jsonb) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, 0L);
        }
        if (jsonReader.nextIfNullOrEmptyString()) {
            return null;
        }
        Object[] values2 = new Object[this.types.length];
        if (jsonReader.nextIfArrayStart()) {
            int i = 0;
            while (!jsonReader.nextIfArrayEnd()) {
                Object value;
                if (jsonReader.isReference()) {
                    String reference = jsonReader.readReference();
                    if ("..".equals(reference)) {
                        value = values2;
                    } else {
                        value = null;
                        jsonReader.addResolveTask(values2, i, JSONPath.of(reference));
                    }
                } else {
                    ObjectReader objectReader = this.getObjectReader(jsonReader, i);
                    value = objectReader.readObject(jsonReader, this.types[i], i, features);
                }
                values2[i] = value;
                jsonReader.nextIfComma();
                ++i;
            }
            jsonReader.nextIfComma();
            return values2;
        }
        throw new JSONException(jsonReader.info("TODO"));
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        int entryCnt = jsonReader.startArray();
        if (entryCnt == -1) {
            return null;
        }
        Object[] values2 = new Object[this.types.length];
        for (int i = 0; i < entryCnt; ++i) {
            Object value;
            if (jsonReader.isReference()) {
                String reference = jsonReader.readReference();
                if ("..".equals(reference)) {
                    value = values2;
                } else {
                    value = null;
                    jsonReader.addResolveTask(values2, i, JSONPath.of(reference));
                }
            } else {
                ObjectReader objectReader = this.getObjectReader(jsonReader, i);
                value = objectReader.readObject(jsonReader, this.types[i], i, features);
            }
            values2[i] = value;
        }
        return values2;
    }

    public Object createInstance(Collection collection, long features) {
        return new Object[this.types.length];
    }
}

