/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class JSONReaderUTF16
extends JSONReader {
    static final long CHAR_MASK = JDKUtils.BIG_ENDIAN ? 0xFF00FF00FF00FFL : -71777214294589696L;
    protected final String str;
    protected final char[] chars;
    protected final int length;
    protected final int start;
    protected final int end;
    private int nameBegin;
    private int nameEnd;
    private int nameLength;
    private int referenceBegin;
    private Closeable input;
    private int cacheIndex = -1;

    JSONReaderUTF16(JSONReader.Context ctx, byte[] bytes, int offset, int length) {
        super(ctx, false, false);
        this.str = null;
        this.chars = new char[length / 2];
        int j = 0;
        int bytesEnd = offset + length;
        int i = offset;
        while (i < bytesEnd) {
            byte c0 = bytes[i];
            byte c1 = bytes[i + 1];
            this.chars[j] = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
            i += 2;
            ++j;
        }
        this.start = offset;
        this.end = this.length = j;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = this.chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = this.chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        if (this.ch == '/') {
            this.skipComment();
        }
    }

    JSONReaderUTF16(JSONReader.Context ctx, Reader input) {
        super(ctx, false, false);
        this.input = input;
        this.cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[this.cacheIndex];
        char[] chars = JSONFactory.CHARS_UPDATER.getAndSet(cacheItem, null);
        if (chars == null) {
            chars = new char[8192];
        }
        int off = 0;
        try {
            int n;
            while ((n = input.read(chars, off, chars.length - off)) != -1) {
                if ((off += n) != chars.length) continue;
                int oldCapacity = chars.length;
                int newCapacity = oldCapacity + (oldCapacity >> 1);
                chars = Arrays.copyOf(chars, newCapacity);
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        this.str = null;
        this.chars = chars;
        this.offset = 0;
        this.length = off;
        this.start = 0;
        this.end = this.length;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return;
            }
            this.ch = chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        if (this.ch == '/') {
            this.skipComment();
        }
    }

    JSONReaderUTF16(JSONReader.Context ctx, String str, int offset, int length) {
        super(ctx, false, false);
        this.cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[this.cacheIndex];
        char[] chars = JSONFactory.CHARS_UPDATER.getAndSet(cacheItem, null);
        if (chars == null || chars.length < length) {
            chars = new char[Math.max(length, 8192)];
        }
        str.getChars(offset, offset + length, chars, 0);
        this.str = offset == 0 ? str : null;
        this.chars = chars;
        this.offset = 0;
        this.length = length;
        this.start = 0;
        this.end = this.length;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return;
            }
            this.ch = chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        if (this.ch == '/') {
            this.skipComment();
        }
    }

    JSONReaderUTF16(JSONReader.Context ctx, String str, char[] chars, int offset, int length) {
        super(ctx, false, false);
        this.str = str;
        this.chars = chars;
        this.offset = offset;
        this.length = length;
        this.start = offset;
        this.end = offset + length;
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = chars[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= length) {
                this.ch = (char)26;
                return;
            }
            this.ch = chars[this.offset];
        }
        ++this.offset;
        if (this.ch == '\ufffe' || this.ch == '\ufeff') {
            this.next();
        }
        if (this.ch == '/') {
            this.skipComment();
        }
    }

    JSONReaderUTF16(JSONReader.Context ctx, InputStream input) {
        super(ctx, false, false);
        char[] chars;
        this.input = input;
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(cacheItem, null);
        int bufferSize = ctx.bufferSize;
        if (bytes == null) {
            bytes = new byte[bufferSize];
        }
        try {
            int n;
            int off = 0;
            while ((n = input.read(bytes, off, bytes.length - off)) != -1) {
                if ((off += n) != bytes.length) continue;
                bytes = Arrays.copyOf(bytes, bytes.length + bufferSize);
            }
            if (off % 2 == 1) {
                throw new JSONException("illegal input utf16 bytes, length " + off);
            }
            chars = new char[off / 2];
            int i = 0;
            int j = 0;
            while (i < off) {
                byte c0 = bytes[i];
                byte c1 = bytes[i + 1];
                chars[j] = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                i += 2;
                ++j;
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        finally {
            JSONFactory.BYTES_UPDATER.lazySet(cacheItem, bytes);
        }
        int length = chars.length;
        this.str = null;
        this.chars = chars;
        this.offset = 0;
        this.length = length;
        this.start = 0;
        this.end = length;
        if (this.end == 0) {
            this.ch = (char)26;
            return;
        }
        int offset = 0;
        char ch = chars[offset];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= length) {
                this.ch = (char)26;
                return;
            }
            ch = chars[offset];
        }
        this.ch = ch;
        ++this.offset;
        if (ch == '\ufffe' || ch == '\ufeff') {
            this.next();
        }
        if (this.ch == '/') {
            this.skipComment();
        }
    }

    @Override
    public final byte[] readHex() {
        int quote;
        int ch = this.ch;
        int offset = this.offset;
        char[] chars = this.chars;
        if (ch == 120) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
        }
        if ((quote = ch) != 39 && quote != 34) {
            throw JSONReaderUTF16.syntaxError(offset, ch);
        }
        int start = offset;
        int n = ch = offset == this.end ? 26 : chars[offset++];
        while (true) {
            if (!(ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70)) {
                if (ch == quote) break;
                throw JSONReaderUTF16.syntaxError(offset, ch);
            }
            ch = offset == this.end ? 26 : chars[offset++];
        }
        ch = offset == this.end ? 26 : chars[offset++];
        int len = offset - start - 2;
        if (ch == 26) {
            ++len;
        }
        if (len % 2 != 0) {
            throw JSONReaderUTF16.syntaxError(offset, ch);
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < bytes.length; ++i) {
            char c0 = chars[start + i * 2];
            char c1 = chars[start + i * 2 + 1];
            int b0 = c0 - (c0 <= '9' ? 48 : 55);
            int b1 = c1 - (c1 <= '9' ? 48 : 55);
            bytes[i] = (byte)(b0 << 4 | b1);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch != 44 || offset >= this.end) {
            this.offset = offset;
            this.ch = (char)ch;
            return bytes;
        }
        this.comma = true;
        int n2 = ch = offset == this.end ? 26 : chars[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.offset = offset;
        this.ch = (char)ch;
        if (this.ch == '/') {
            this.skipComment();
        }
        return bytes;
    }

    @Override
    public final boolean isReference() {
        char[] chars = this.chars;
        char ch = this.ch;
        if (ch != '{') {
            return false;
        }
        int offset = this.offset;
        int end = this.end;
        if (offset == end) {
            return false;
        }
        ch = chars[offset];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                return false;
            }
            ch = chars[offset];
        }
        char quote = ch;
        if (offset + 6 >= end || chars[offset + 1] != '$' || chars[offset + 2] != 'r' || chars[offset + 3] != 'e' || chars[offset + 4] != 'f' || chars[offset + 5] != quote) {
            return false;
        }
        ch = chars[offset += 6];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                return false;
            }
            ch = chars[offset];
        }
        if (ch != ':' || offset + 1 >= end) {
            return false;
        }
        ch = chars[++offset];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                return false;
            }
            ch = chars[offset];
        }
        if (ch != quote || offset + 1 < end && chars[offset + 1] == '#') {
            return false;
        }
        this.referenceBegin = offset;
        return true;
    }

    @Override
    public final String readReference() {
        if (this.referenceBegin == this.end) {
            return null;
        }
        char[] chars = this.chars;
        this.offset = this.referenceBegin;
        this.ch = chars[this.offset++];
        String reference = this.readString();
        int ch = this.ch;
        int offset = this.offset;
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch != 125) {
            throw new JSONException("illegal reference : ".concat(reference));
        }
        int n = ch = offset == this.end ? 26 : chars[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n2 = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return reference;
    }

    @Override
    public final boolean nextIfMatch(char m3) {
        char[] chars = this.chars;
        int offset = this.offset;
        char ch = this.ch;
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (char)'\u001a' : chars[offset++];
        }
        if (ch != m3) {
            return false;
        }
        char c = ch = offset == this.end ? (char)'\u001a' : chars[offset++];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (char)'\u001a' : chars[offset++];
        }
        this.offset = offset;
        this.ch = ch;
        if (ch == '/') {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfComma() {
        char[] chars = this.chars;
        int offset = this.offset;
        int ch = this.ch;
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch != 44) {
            return false;
        }
        int n = ch = offset == this.end ? 26 : chars[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.offset = offset;
        this.ch = (char)ch;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfArrayStart() {
        int ch = this.ch;
        if (ch != 91) {
            return false;
        }
        char[] chars = this.chars;
        int offset = this.offset;
        int n = ch = offset == this.end ? 26 : chars[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfArrayEnd() {
        int ch = this.ch;
        if (ch != 93) {
            return false;
        }
        int offset = this.offset;
        char[] chars = this.chars;
        int n = ch = offset == this.end ? 26 : chars[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch == 44) {
            this.comma = true;
            int n2 = ch = offset == this.end ? 26 : chars[offset++];
            while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfNullOrEmptyString() {
        int ch;
        char first = this.ch;
        int end = this.end;
        int offset = this.offset;
        char[] chars = this.chars;
        if (first == 'n' && offset + 2 < end && chars[offset] == 'u' && chars[offset + 1] == 'l' && chars[offset + 2] == 'l') {
            offset += 3;
        } else if ((first == '\"' || first == '\'') && offset < end && chars[offset] == first) {
            ++offset;
        } else {
            return false;
        }
        int n = ch = offset == end ? 26 : chars[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n2 = ch = offset == end ? 26 : chars[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : chars[offset++];
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        char[] chars = this.chars;
        int offset = this.offset;
        if (offset + 1 > this.end || chars[offset] != c1) {
            return false;
        }
        int n = ch = ++offset == this.end ? 26 : chars[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (offset == this.offset + 2 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        char[] chars = this.chars;
        int offset = this.offset;
        if (offset + 2 > this.end || chars[offset] != c1 || chars[offset + 1] != c2) {
            return false;
        }
        int n = ch = (offset += 2) == this.end ? 26 : chars[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (offset == this.offset + 3 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        char[] chars = this.chars;
        int offset = this.offset;
        if (offset + 3 > this.end || chars[offset] != c1 || chars[offset + 1] != c2 || chars[offset + 2] != c3) {
            return false;
        }
        int n = ch = (offset += 3) == this.end ? 26 : chars[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (offset == this.offset + 4 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        char[] chars = this.chars;
        int offset = this.offset;
        if (offset + 4 > this.end || chars[offset] != c1 || chars[offset + 1] != c2 || chars[offset + 2] != c3 || chars[offset + 3] != c4) {
            return false;
        }
        int n = ch = (offset += 4) == this.end ? 26 : chars[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (offset == this.offset + 5 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4, char c5) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        char[] chars = this.chars;
        int offset = this.offset;
        if (offset + 5 > this.end || chars[offset] != c1 || chars[offset + 1] != c2 || chars[offset + 2] != c3 || chars[offset + 3] != c4 || chars[offset + 4] != c5) {
            return false;
        }
        int n = ch = (offset += 5) == this.end ? 26 : chars[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (offset == this.offset + 6 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfSet() {
        char[] chars = this.chars;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 83 && offset + 1 < this.end && chars[offset] == 'e' && chars[offset + 1] == 't') {
            int n = ch = (offset += 2) == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
            this.offset = offset;
            this.ch = (char)ch;
            return true;
        }
        return false;
    }

    @Override
    public final boolean nextIfInfinity() {
        char[] chars = this.chars;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 73 && offset + 6 < this.end && chars[offset] == 'n' && chars[offset + 1] == 'f' && chars[offset + 2] == 'i' && chars[offset + 3] == 'n' && chars[offset + 4] == 'i' && chars[offset + 5] == 't' && chars[offset + 6] == 'y') {
            int n = ch = (offset += 7) == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
            this.offset = offset;
            this.ch = (char)ch;
            return true;
        }
        return false;
    }

    @Override
    public final boolean nextIfObjectStart() {
        int ch = this.ch;
        if (ch != 123) {
            return false;
        }
        char[] chars = this.chars;
        int offset = this.offset;
        int n = ch = offset == this.end ? 26 : chars[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfObjectEnd() {
        int ch = this.ch;
        if (ch != 125) {
            return false;
        }
        int offset = this.offset;
        char[] chars = this.chars;
        int n = ch = offset == this.end ? 26 : chars[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch == 44) {
            this.comma = true;
            int n2 = ch = offset == this.end ? 26 : chars[offset++];
            while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final void next() {
        int ch;
        int offset = this.offset;
        char[] chars = this.chars;
        int n = ch = offset >= this.end ? 26 : chars[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.offset = offset;
        this.ch = (char)ch;
        if (ch == 47) {
            this.skipComment();
        }
    }

    @Override
    public final long readFieldNameHashCodeUnquote() {
        long hashCode;
        this.nameEscape = false;
        int offset = this.offset;
        int end = this.end;
        char[] chars = this.chars;
        int ch = this.ch;
        this.nameBegin = offset - 1;
        int first = ch;
        long nameValue = 0L;
        int i = 0;
        block26: while (offset <= end) {
            switch (ch) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 26: 
                case 32: 
                case 33: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 91: 
                case 93: 
                case 123: 
                case 124: 
                case 125: {
                    this.nameLength = i;
                    int n = this.nameEnd = ch == 26 ? offset : offset - 1;
                    if (ch > 32 || (1L << ch & 0x100003700L) == 0L) break block26;
                    ch = offset == end ? 26 : chars[offset++];
                    break block26;
                }
                default: {
                    if (ch == 92) {
                        this.nameEscape = true;
                        ch = chars[offset++];
                        switch (ch) {
                            case 117: {
                                ch = JSONReaderUTF16.char4(chars[offset], chars[offset + 1], chars[offset + 2], chars[offset + 3]);
                                offset += 4;
                                break;
                            }
                            case 120: {
                                ch = JSONReaderUTF16.char2(chars[offset], chars[offset + 1]);
                                offset += 2;
                                break;
                            }
                            case 34: 
                            case 42: 
                            case 43: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 58: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 64: 
                            case 92: {
                                break;
                            }
                            default: {
                                ch = this.char1(ch);
                            }
                        }
                    }
                    if (ch > 255 || i >= 8 || i == 0 && ch == 0) {
                        nameValue = 0L;
                        ch = first;
                        offset = this.nameBegin + 1;
                        break block26;
                    }
                    byte c = (byte)ch;
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ch = offset == end ? 26 : chars[offset++];
                    ++i;
                    continue block26;
                }
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i2 = 0;
            block27: while (true) {
                if (ch == 92) {
                    this.nameEscape = true;
                    ch = chars[offset++];
                    switch (ch) {
                        case 117: {
                            ch = JSONReaderUTF16.char4(chars[offset], chars[offset + 1], chars[offset + 2], chars[offset + 3]);
                            offset += 4;
                            break;
                        }
                        case 120: {
                            ch = JSONReaderUTF16.char2(chars[offset], chars[offset + 1]);
                            offset += 2;
                            break;
                        }
                        case 34: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 64: 
                        case 92: {
                            break;
                        }
                        default: {
                            ch = this.char1(ch);
                        }
                    }
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                    ch = offset == end ? 26 : chars[offset++];
                } else {
                    switch (ch) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 26: 
                        case 32: 
                        case 33: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 91: 
                        case 93: 
                        case 123: 
                        case 125: {
                            this.nameLength = i2;
                            int n = this.nameEnd = ch == 26 ? offset : offset - 1;
                            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                                ch = offset == end ? 26 : chars[offset++];
                            }
                            break block27;
                        }
                        default: {
                            hashCode ^= (long)ch;
                            hashCode *= 1099511628211L;
                            ch = offset == end ? 26 : chars[offset++];
                        }
                    }
                }
                ++i2;
            }
        }
        if (ch == 58) {
            int n = ch = offset == end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : chars[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return hashCode;
    }

    @Override
    public final long readFieldNameHashCode() {
        int c;
        long hashCode;
        char[] chars = this.chars;
        if (this.ch != '\"' && this.ch != '\'') {
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderUTF16.isFirstIdentifier(this.ch)) {
                return this.readFieldNameHashCodeUnquote();
            }
            if (this.ch == '}' || this.isNull()) {
                return -1L;
            }
            String errorMsg = this.ch == '[' && this.nameBegin > 0 ? "illegal fieldName input " + this.ch + ", previous fieldName " + this.getFieldName() : "illegal fieldName input" + this.ch;
            throw new JSONException(this.info(errorMsg));
        }
        char quote = this.ch;
        this.stringValue = null;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int end = this.end;
        long nameValue = 0L;
        if (offset + 9 < end) {
            char c0 = chars[offset];
            char c1 = chars[offset + 1];
            char c2 = chars[offset + 2];
            char c3 = chars[offset + 3];
            char c4 = chars[offset + 4];
            char c5 = chars[offset + 5];
            char c6 = chars[offset + 6];
            char c7 = chars[offset + 7];
            char c8 = chars[offset + 8];
            if (c0 == quote) {
                nameValue = 0L;
            } else if (c1 == quote && c0 != '\u0000' && c0 != '\\' && c0 <= '\u00ff') {
                nameValue = (byte)c0;
                this.nameLength = 1;
                this.nameEnd = offset + 1;
                offset += 2;
            } else if (c2 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff') {
                nameValue = ((byte)c1 << 8) + c0;
                this.nameLength = 2;
                this.nameEnd = offset + 2;
                offset += 3;
            } else if (c3 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff') {
                nameValue = ((byte)c2 << 16) + (c1 << 8) + c0;
                this.nameLength = 3;
                this.nameEnd = offset + 3;
                offset += 4;
            } else if (c4 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff') {
                nameValue = ((byte)c3 << 24) + (c2 << 16) + (c1 << 8) + c0;
                this.nameLength = 4;
                this.nameEnd = offset + 4;
                offset += 5;
            } else if (c5 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c4 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff' && c4 <= '\u00ff') {
                nameValue = ((long)((byte)c4) << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                this.nameLength = 5;
                this.nameEnd = offset + 5;
                offset += 6;
            } else if (c6 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c4 != '\\' && c5 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff' && c4 <= '\u00ff' && c5 <= '\u00ff') {
                nameValue = ((long)((byte)c5) << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                this.nameLength = 6;
                this.nameEnd = offset + 6;
                offset += 7;
            } else if (c7 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c4 != '\\' && c5 != '\\' && c6 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff' && c4 <= '\u00ff' && c5 <= '\u00ff' && c6 <= '\u00ff') {
                nameValue = ((long)((byte)c6) << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                this.nameLength = 7;
                this.nameEnd = offset + 7;
                offset += 8;
            } else if (c8 == quote && c0 != '\u0000' && c0 != '\\' && c1 != '\\' && c2 != '\\' && c3 != '\\' && c4 != '\\' && c5 != '\\' && c6 != '\\' && c7 != '\\' && c0 <= '\u00ff' && c1 <= '\u00ff' && c2 <= '\u00ff' && c3 <= '\u00ff' && c4 <= '\u00ff' && c5 <= '\u00ff' && c6 <= '\u00ff' && c7 <= '\u00ff') {
                nameValue = ((long)((byte)c7) << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                this.nameLength = 8;
                this.nameEnd = offset + 8;
                offset += 9;
            }
        }
        if (nameValue == 0L) {
            int i = 0;
            while (offset < end) {
                char c2 = chars[offset];
                if (c2 == quote) {
                    if (i == 0) {
                        offset = this.nameBegin;
                        break;
                    }
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    break;
                }
                if (c2 == '\\') {
                    this.nameEscape = true;
                    c2 = chars[++offset];
                    switch (c2) {
                        case 'u': {
                            c2 = JSONReaderUTF16.char4(chars[offset + 1], chars[offset + 2], chars[offset + 3], chars[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 'x': {
                            c2 = JSONReaderUTF16.char2(chars[offset + 1], chars[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            c2 = this.char1(c2);
                        }
                    }
                }
                if (c2 > '\u00ff' || i >= 8 || i == 0 && c2 == '\u0000') {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)c2;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)c2 << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)c2 << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)c2 << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)c2) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)c2) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)c2) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)c2) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++offset;
                ++i;
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                char c3;
                if ((c3 = chars[offset]) == '\\') {
                    this.nameEscape = true;
                    c3 = chars[++offset];
                    switch (c3) {
                        case 'u': {
                            c3 = JSONReaderUTF16.char4(chars[offset + 1], chars[offset + 2], chars[offset + 3], chars[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 'x': {
                            c3 = JSONReaderUTF16.char2(chars[offset + 1], chars[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            c3 = this.char1(c3);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)c3;
                    hashCode *= 1099511628211L;
                } else {
                    if (c3 == quote) {
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        break;
                    }
                    ++offset;
                    hashCode ^= (long)c3;
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        int n = c = offset == end ? 26 : chars[offset++];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = offset == end ? 26 : chars[offset++];
        }
        if (c != 58) {
            throw new JSONException(this.info("expect ':', but " + (char)c));
        }
        int n2 = c = offset == end ? 26 : chars[offset++];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = offset == end ? 26 : chars[offset++];
        }
        this.offset = offset;
        this.ch = (char)c;
        return hashCode;
    }

    @Override
    public final long readValueHashCode() {
        long hashCode;
        char quote = this.ch;
        if (quote != '\"' && quote != '\'') {
            return -1L;
        }
        char[] chars = this.chars;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int end = this.end;
        long nameValue = 0L;
        int i = 0;
        while (offset < end) {
            char ch = chars[offset];
            if (ch == quote) {
                if (i == 0) {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                this.nameLength = i;
                this.nameEnd = offset++;
                break;
            }
            if (ch == '\\') {
                this.nameEscape = true;
                ch = chars[++offset];
                switch (ch) {
                    case 'u': {
                        ch = JSONReaderUTF16.char4(chars[offset + 1], chars[offset + 2], chars[offset + 3], chars[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        ch = JSONReaderUTF16.char2(chars[offset + 1], chars[offset + 2]);
                        offset += 2;
                        break;
                    }
                    default: {
                        ch = this.char1(ch);
                    }
                }
            }
            if (ch > '\u00ff' || i >= 8 || i == 0 && ch == '\u0000') {
                nameValue = 0L;
                offset = this.nameBegin;
                break;
            }
            switch (i) {
                case 0: {
                    nameValue = (byte)ch;
                    break;
                }
                case 1: {
                    nameValue = (long)((byte)ch << 8) + (nameValue & 0xFFL);
                    break;
                }
                case 2: {
                    nameValue = (long)((byte)ch << 16) + (nameValue & 0xFFFFL);
                    break;
                }
                case 3: {
                    nameValue = (long)((byte)ch << 24) + (nameValue & 0xFFFFFFL);
                    break;
                }
                case 4: {
                    nameValue = ((long)((byte)ch) << 32) + (nameValue & 0xFFFFFFFFL);
                    break;
                }
                case 5: {
                    nameValue = ((long)((byte)ch) << 40) + (nameValue & 0xFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    nameValue = ((long)((byte)ch) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    nameValue = ((long)((byte)ch) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                    break;
                }
            }
            ++offset;
            ++i;
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = chars[offset]) == '\\') {
                    this.nameEscape = true;
                    c = chars[++offset];
                    switch (c) {
                        case 'u': {
                            c = JSONReaderUTF16.char4(chars[offset + 1], chars[offset + 2], chars[offset + 3], chars[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 'x': {
                            c = JSONReaderUTF16.char2(chars[offset + 1], chars[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            c = this.char1(c);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                } else {
                    if (c == '\"') {
                        this.nameLength = i2;
                        this.nameEnd = offset++;
                        this.stringValue = null;
                        break;
                    }
                    ++offset;
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                }
                ++i2;
            }
        }
        int c = offset == end ? 26 : chars[offset];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.comma = c == 44;
        if (this.comma) {
            c = ++offset == end ? 26 : chars[offset];
            while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                c = chars[++offset];
            }
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    @Override
    public final long getNameHashCodeLCase() {
        int offset;
        long nameValue = 0L;
        char[] chars = this.chars;
        int i = 0;
        for (offset = this.nameBegin; offset < this.end; ++offset) {
            char c1;
            char c = chars[offset];
            if (c == '\\') {
                c = chars[++offset];
                switch (c) {
                    case 'u': {
                        c = JSONReaderUTF16.char4(chars[offset + 1], chars[offset + 2], chars[offset + 3], chars[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        c = JSONReaderUTF16.char2(chars[offset + 1], chars[offset + 2]);
                        offset += 2;
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            if (c > '\u00ff' || i >= 8 || i == 0 && c == '\u0000') {
                nameValue = 0L;
                offset = this.nameBegin;
                break;
            }
            if ((c == '_' || c == '-' || c == ' ') && (c1 = chars[offset + 1]) != '\"' && c1 != '\'' && c1 != c) continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            switch (i) {
                case 0: {
                    nameValue = (byte)c;
                    break;
                }
                case 1: {
                    nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                    break;
                }
                case 2: {
                    nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                    break;
                }
                case 3: {
                    nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                    break;
                }
                case 4: {
                    nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                    break;
                }
                case 5: {
                    nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                    break;
                }
            }
            ++i;
        }
        if (nameValue != 0L) {
            return nameValue;
        }
        long hashCode = -3750763034362895579L;
        while (offset < this.end) {
            char c1;
            char c = chars[offset];
            if (c == '\\') {
                c = chars[++offset];
                switch (c) {
                    case 'u': {
                        c = JSONReaderUTF16.char4(chars[offset + 1], chars[offset + 2], chars[offset + 3], chars[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        c = JSONReaderUTF16.char2(chars[offset + 1], chars[offset + 2]);
                        offset += 2;
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            if ((c == '_' || c == '-' || c == ' ') && (c1 = chars[++offset]) != '\"' && c1 != '\'' && c1 != c) continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public final String getFieldName() {
        if (!this.nameEscape) {
            if (this.str != null) {
                return this.str.substring(this.nameBegin, this.nameEnd);
            }
            return new String(this.chars, this.nameBegin, this.nameEnd - this.nameBegin);
        }
        char[] buf = new char[this.nameLength];
        char[] chars = this.chars;
        int offset = this.nameBegin;
        int i = 0;
        while (offset < this.nameEnd) {
            char c = chars[offset];
            if (c == '\\') {
                c = chars[++offset];
                switch (c) {
                    case 'u': {
                        c = JSONReaderUTF16.char4(chars[offset + 1], chars[offset + 2], chars[offset + 3], chars[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        c = JSONReaderUTF16.char2(chars[offset + 1], chars[offset + 2]);
                        offset += 2;
                        break;
                    }
                    case '\"': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': 
                    case '\\': {
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            buf[i] = c;
            ++offset;
            ++i;
        }
        return new String(buf);
    }

    @Override
    public final String readFieldName() {
        char quote = this.ch;
        if (quote != '\"' && quote != '\'') {
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderUTF16.isFirstIdentifier(quote)) {
                return this.readFieldNameUnquote();
            }
            return null;
        }
        char[] chars = this.chars;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int end = this.end;
        int nameBegin = this.nameBegin;
        int i = 0;
        while (offset < end) {
            char c = chars[offset];
            if (c == '\\') {
                this.nameEscape = true;
                offset += (c = chars[offset + 1]) == 'u' ? 6 : (c == 'x' ? 4 : 2);
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    c = offset < end ? chars[offset] : (char)'\u001a';
                    while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                        c = chars[++offset];
                    }
                    if (c != ':') {
                        throw new JSONException("syntax error : " + offset);
                    }
                    char c2 = c = ++offset == end ? (char)'\u001a' : chars[offset];
                    while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
                        c = chars[++offset];
                    }
                    this.offset = offset + 1;
                    this.ch = c;
                    break;
                }
                ++offset;
            }
            ++i;
        }
        if (this.nameEnd < nameBegin) {
            throw new JSONException("syntax error : " + offset);
        }
        if (!this.nameEscape) {
            long nameValue0 = -1L;
            long nameValue1 = -1L;
            switch (this.nameLength) {
                case 1: {
                    return TypeUtils.toString(chars[nameBegin]);
                }
                case 2: {
                    return TypeUtils.toString(chars[nameBegin], chars[nameBegin + 1]);
                }
                case 3: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2) break;
                    nameValue0 = (c2 << 16) + (c1 << 8) + c0;
                    break;
                }
                case 4: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3) break;
                    nameValue0 = (c3 << 24) + (c2 << 16) + (c1 << 8) + c0;
                    break;
                }
                case 5: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    char c4 = chars[nameBegin + 4];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4) break;
                    nameValue0 = ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    break;
                }
                case 6: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    char c4 = chars[nameBegin + 4];
                    char c5 = chars[nameBegin + 5];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5) break;
                    nameValue0 = ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    break;
                }
                case 7: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    char c4 = chars[nameBegin + 4];
                    char c5 = chars[nameBegin + 5];
                    char c6 = chars[nameBegin + 6];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6) break;
                    nameValue0 = ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    break;
                }
                case 8: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    char c4 = chars[nameBegin + 4];
                    char c5 = chars[nameBegin + 5];
                    char c6 = chars[nameBegin + 6];
                    char c7 = chars[nameBegin + 7];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7) break;
                    nameValue0 = ((long)c7 << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    break;
                }
                case 9: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    char c4 = chars[nameBegin + 4];
                    char c5 = chars[nameBegin + 5];
                    char c6 = chars[nameBegin + 6];
                    char c7 = chars[nameBegin + 7];
                    char c8 = chars[nameBegin + 8];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8) break;
                    nameValue0 = c0;
                    nameValue1 = ((long)c8 << 56) + ((long)c7 << 48) + ((long)c6 << 40) + ((long)c5 << 32) + ((long)c4 << 24) + ((long)c3 << 16) + ((long)c2 << 8) + (long)c1;
                    break;
                }
                case 10: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    char c4 = chars[nameBegin + 4];
                    char c5 = chars[nameBegin + 5];
                    char c6 = chars[nameBegin + 6];
                    char c7 = chars[nameBegin + 7];
                    char c8 = chars[nameBegin + 8];
                    char c9 = chars[nameBegin + 9];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9) break;
                    nameValue0 = (c1 << 8) + c0;
                    nameValue1 = ((long)c9 << 56) + ((long)c8 << 48) + ((long)c7 << 40) + ((long)c6 << 32) + ((long)c5 << 24) + ((long)c4 << 16) + ((long)c3 << 8) + (long)c2;
                    break;
                }
                case 11: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    char c4 = chars[nameBegin + 4];
                    char c5 = chars[nameBegin + 5];
                    char c6 = chars[nameBegin + 6];
                    char c7 = chars[nameBegin + 7];
                    char c8 = chars[nameBegin + 8];
                    char c9 = chars[nameBegin + 9];
                    char c10 = chars[nameBegin + 10];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10) break;
                    nameValue0 = (c2 << 16) + (c1 << 8) + c0;
                    nameValue1 = ((long)c10 << 56) + ((long)c9 << 48) + ((long)c8 << 40) + ((long)c7 << 32) + ((long)c6 << 24) + ((long)c5 << 16) + ((long)c4 << 8) + (long)c3;
                    break;
                }
                case 12: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    char c4 = chars[nameBegin + 4];
                    char c5 = chars[nameBegin + 5];
                    char c6 = chars[nameBegin + 6];
                    char c7 = chars[nameBegin + 7];
                    char c8 = chars[nameBegin + 8];
                    char c9 = chars[nameBegin + 9];
                    char c10 = chars[nameBegin + 10];
                    char c11 = chars[nameBegin + 11];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11) break;
                    nameValue0 = (c3 << 24) + (c2 << 16) + (c1 << 8) + c0;
                    nameValue1 = ((long)c11 << 56) + ((long)c10 << 48) + ((long)c9 << 40) + ((long)c8 << 32) + ((long)c7 << 24) + ((long)c6 << 16) + ((long)c5 << 8) + (long)c4;
                    break;
                }
                case 13: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    char c4 = chars[nameBegin + 4];
                    char c5 = chars[nameBegin + 5];
                    char c6 = chars[nameBegin + 6];
                    char c7 = chars[nameBegin + 7];
                    char c8 = chars[nameBegin + 8];
                    char c9 = chars[nameBegin + 9];
                    char c10 = chars[nameBegin + 10];
                    char c11 = chars[nameBegin + 11];
                    char c12 = chars[nameBegin + 12];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11 || (c12 & 0xFF) != c12) break;
                    nameValue0 = ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    nameValue1 = ((long)c12 << 56) + ((long)c11 << 48) + ((long)c10 << 40) + ((long)c9 << 32) + ((long)c8 << 24) + ((long)c7 << 16) + ((long)c6 << 8) + (long)c5;
                    break;
                }
                case 14: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    char c4 = chars[nameBegin + 4];
                    char c5 = chars[nameBegin + 5];
                    char c6 = chars[nameBegin + 6];
                    char c7 = chars[nameBegin + 7];
                    char c8 = chars[nameBegin + 8];
                    char c9 = chars[nameBegin + 9];
                    char c10 = chars[nameBegin + 10];
                    char c11 = chars[nameBegin + 11];
                    char c12 = chars[nameBegin + 12];
                    char c13 = chars[nameBegin + 13];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11 || (c12 & 0xFF) != c12 || (c13 & 0xFF) != c13) break;
                    nameValue0 = ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    nameValue1 = ((long)c13 << 56) + ((long)c12 << 48) + ((long)c11 << 40) + ((long)c10 << 32) + ((long)c9 << 24) + ((long)c8 << 16) + ((long)c7 << 8) + (long)c6;
                    break;
                }
                case 15: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    char c4 = chars[nameBegin + 4];
                    char c5 = chars[nameBegin + 5];
                    char c6 = chars[nameBegin + 6];
                    char c7 = chars[nameBegin + 7];
                    char c8 = chars[nameBegin + 8];
                    char c9 = chars[nameBegin + 9];
                    char c10 = chars[nameBegin + 10];
                    char c11 = chars[nameBegin + 11];
                    char c12 = chars[nameBegin + 12];
                    char c13 = chars[nameBegin + 13];
                    char c14 = chars[nameBegin + 14];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11 || (c12 & 0xFF) != c12 || (c13 & 0xFF) != c13 || (c14 & 0xFF) != c14) break;
                    nameValue0 = ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    nameValue1 = ((long)c14 << 56) + ((long)c13 << 48) + ((long)c12 << 40) + ((long)c11 << 32) + ((long)c10 << 24) + ((long)c9 << 16) + ((long)c8 << 8) + (long)c7;
                    break;
                }
                case 16: {
                    char c0 = chars[nameBegin];
                    char c1 = chars[nameBegin + 1];
                    char c2 = chars[nameBegin + 2];
                    char c3 = chars[nameBegin + 3];
                    char c4 = chars[nameBegin + 4];
                    char c5 = chars[nameBegin + 5];
                    char c6 = chars[nameBegin + 6];
                    char c7 = chars[nameBegin + 7];
                    char c8 = chars[nameBegin + 8];
                    char c9 = chars[nameBegin + 9];
                    char c10 = chars[nameBegin + 10];
                    char c11 = chars[nameBegin + 11];
                    char c12 = chars[nameBegin + 12];
                    char c13 = chars[nameBegin + 13];
                    char c14 = chars[nameBegin + 14];
                    char c15 = chars[nameBegin + 15];
                    if ((c0 & 0xFF) != c0 || (c1 & 0xFF) != c1 || (c2 & 0xFF) != c2 || (c3 & 0xFF) != c3 || (c4 & 0xFF) != c4 || (c5 & 0xFF) != c5 || (c6 & 0xFF) != c6 || (c7 & 0xFF) != c7 || (c8 & 0xFF) != c8 || (c9 & 0xFF) != c9 || (c10 & 0xFF) != c10 || (c11 & 0xFF) != c11 || (c12 & 0xFF) != c12 || (c13 & 0xFF) != c13 || (c14 & 0xFF) != c14 || (c15 & 0xFF) != c15) break;
                    nameValue0 = ((long)c7 << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + ((long)c3 << 24) + ((long)c2 << 16) + ((long)c1 << 8) + (long)c0;
                    nameValue1 = ((long)c15 << 56) + ((long)c14 << 48) + ((long)c13 << 40) + ((long)c12 << 32) + ((long)c11 << 24) + ((long)c10 << 16) + ((long)c9 << 8) + (long)c8;
                    break;
                }
            }
            if (nameValue0 != -1L) {
                if (nameValue1 != -1L) {
                    long nameValue01 = nameValue0 ^ nameValue1;
                    int indexMask = (int)(nameValue01 ^ nameValue01 >>> 32) & JSONFactory.NAME_CACHE2.length - 1;
                    JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                    if (entry == null) {
                        String name = this.str != null ? this.str.substring(nameBegin, this.nameEnd) : new String(chars, nameBegin, this.nameEnd - nameBegin);
                        JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(name, nameValue0, nameValue1);
                        return name;
                    }
                    if (entry.value0 == nameValue0 && entry.value1 == nameValue1) {
                        return entry.name;
                    }
                } else {
                    int indexMask = (int)(nameValue0 ^ nameValue0 >>> 32) & JSONFactory.NAME_CACHE.length - 1;
                    JSONFactory.NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                    if (entry == null) {
                        String name = this.str != null ? this.str.substring(nameBegin, this.nameEnd) : new String(chars, nameBegin, this.nameEnd - nameBegin);
                        JSONFactory.NAME_CACHE[indexMask] = new JSONFactory.NameCacheEntry(name, nameValue0);
                        return name;
                    }
                    if (entry.value == nameValue0) {
                        return entry.name;
                    }
                }
            }
            if (this.str != null) {
                return this.str.substring(nameBegin, this.nameEnd);
            }
            return new String(chars, nameBegin, this.nameEnd - nameBegin);
        }
        return this.getFieldName();
    }

    @Override
    public final boolean skipName() {
        char ch;
        char quote = this.ch;
        if (quote != '\"' && quote != '\'') {
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L) {
                this.readFieldNameHashCodeUnquote();
                return true;
            }
            throw this.notSupportName();
        }
        int offset = this.offset;
        char[] chars = this.chars;
        while (true) {
            if ((ch = chars[offset++]) == '\\') {
                offset += (ch = chars[offset]) == 'u' ? 5 : (ch == 'x' ? 3 : 1);
                continue;
            }
            if (ch == quote) break;
        }
        char c = ch = offset == this.end ? (char)'\u001a' : chars[offset++];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (char)'\u001a' : chars[offset++];
        }
        if (ch != ':') {
            throw JSONReaderUTF16.syntaxError(ch);
        }
        char c2 = ch = offset == this.end ? (char)'\u001a' : chars[offset++];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (char)'\u001a' : chars[offset++];
        }
        this.offset = offset;
        this.ch = ch;
        return true;
    }

    @Override
    public final int readInt32Value() {
        boolean overflow;
        boolean negative = false;
        int ch = this.ch;
        int offset = this.offset;
        int end = this.end;
        char[] chars = this.chars;
        int intValue = 0;
        int quote = 0;
        if (ch == 34 || ch == 39) {
            quote = ch;
            ch = chars[offset++];
        }
        if (ch == 45) {
            negative = true;
            ch = chars[offset++];
        } else if (ch == 43) {
            ch = chars[offset++];
        } else if (ch == 44) {
            throw this.numberError();
        }
        boolean bl = overflow = ch < 48 || ch > 57;
        while (ch >= 48 && ch <= 57) {
            int intValue10 = intValue * 10 + (ch - 48);
            if (intValue10 < intValue) {
                overflow = true;
                break;
            }
            intValue = intValue10;
            ch = offset == end ? 26 : chars[offset++];
        }
        if (ch == 46 || ch == 101 || ch == 69 || ch == 116 || ch == 102 || ch == 110 || ch == 123 || ch == 91 || quote != 0 && ch != quote) {
            overflow = true;
        }
        if (overflow) {
            this.readNumber0();
            return this.getInt32Value();
        }
        if (quote != 0) {
            int n = ch = offset == end ? 26 : chars[offset++];
        }
        if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
            int n = ch = offset == end ? 26 : chars[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : chars[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return negative ? -intValue : intValue;
    }

    @Override
    public final Integer readInt32() {
        boolean overflow;
        boolean negative = false;
        int ch = this.ch;
        int offset = this.offset;
        char[] chars = this.chars;
        int intValue = 0;
        int quote = 0;
        if (ch == 34 || ch == 39) {
            quote = ch;
            ch = chars[offset++];
        }
        if (ch == 45) {
            negative = true;
            ch = chars[offset++];
        } else if (ch == 43) {
            ch = chars[offset++];
        } else if (ch == 44) {
            throw this.numberError();
        }
        boolean bl = overflow = ch < 48 || ch > 57;
        while (ch >= 48 && ch <= 57) {
            int intValue10 = intValue * 10 + (ch - 48);
            if (intValue10 < intValue) {
                overflow = true;
                break;
            }
            intValue = intValue10;
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch == 46 || ch == 101 || ch == 69 || ch == 116 || ch == 102 || ch == 110 || ch == 123 || ch == 91 || quote != 0 && ch != quote) {
            overflow = true;
        }
        if (overflow) {
            this.readNumber0();
            if (this.wasNull) {
                return null;
            }
            return this.getInt32Value();
        }
        if (quote != 0) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return negative ? -intValue : intValue;
    }

    @Override
    public final long readInt64Value() {
        boolean overflow;
        boolean negative = false;
        int ch = this.ch;
        int offset = this.offset;
        char[] chars = this.chars;
        long longValue = 0L;
        int quote = 0;
        if (ch == 34 || ch == 39) {
            quote = ch;
            ch = chars[offset++];
        }
        if (ch == 45) {
            negative = true;
            ch = chars[offset++];
        } else if (ch == 43) {
            ch = chars[offset++];
        } else if (ch == 44) {
            throw this.numberError();
        }
        boolean bl = overflow = ch < 48 || ch > 57;
        while (ch >= 48 && ch <= 57) {
            long intValue10 = longValue * 10L + (long)(ch - 48);
            if (intValue10 < longValue) {
                overflow = true;
                break;
            }
            longValue = intValue10;
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch == 46 || ch == 101 || ch == 69 || ch == 116 || ch == 102 || ch == 110 || ch == 123 || ch == 91 || quote != 0 && ch != quote) {
            overflow = true;
        }
        if (overflow) {
            this.readNumber0();
            return this.getInt64Value();
        }
        if (quote != 0) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return negative ? -longValue : longValue;
    }

    @Override
    public final Long readInt64() {
        boolean overflow;
        boolean negative = false;
        int ch = this.ch;
        int offset = this.offset;
        char[] chars = this.chars;
        long longValue = 0L;
        int quote = 0;
        if (ch == 34 || ch == 39) {
            quote = ch;
            ch = chars[offset++];
        }
        if (ch == 45) {
            negative = true;
            ch = chars[offset++];
        } else if (ch == 43) {
            ch = chars[offset++];
        } else if (ch == 44) {
            throw this.numberError();
        }
        boolean bl = overflow = ch < 48 || ch > 57;
        while (ch >= 48 && ch <= 57) {
            long intValue10 = longValue * 10L + (long)(ch - 48);
            if (intValue10 < longValue) {
                overflow = true;
                break;
            }
            longValue = intValue10;
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch == 46 || ch == 101 || ch == 69 || ch == 116 || ch == 102 || ch == 110 || ch == 123 || ch == 91 || quote != 0 && ch != quote) {
            overflow = true;
        }
        if (overflow) {
            this.readNumber0();
            if (this.wasNull) {
                return null;
            }
            return this.getInt64Value();
        }
        this.wasNull = false;
        if (quote != 0) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return negative ? -longValue : longValue;
    }

    @Override
    public final double readDoubleValue() {
        long intValue10;
        boolean valid = false;
        this.wasNull = false;
        boolean value = false;
        double doubleValue = 0.0;
        char[] chars = this.chars;
        int quote = 0;
        int ch = this.ch;
        int offset = this.offset;
        if ((ch == 34 || ch == 39) && (ch = chars[offset++]) == (quote = ch)) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
            this.ch = (char)ch;
            this.offset = offset;
            this.nextIfComma();
            this.wasNull = true;
            return 0.0;
        }
        int start = offset;
        if (ch == 45) {
            this.negative = true;
            ch = chars[offset++];
        } else {
            this.negative = false;
            if (ch == 43) {
                ch = chars[offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (ch >= 48 && ch <= 57) {
            valid = true;
            if (!overflow) {
                intValue10 = longValue * 10L + (long)(ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                } else {
                    longValue = intValue10;
                }
            }
            if (offset == this.end) {
                ch = 26;
                ++offset;
                break;
            }
            ch = chars[offset++];
        }
        this.scale = 0;
        if (ch == 46) {
            this.valueType = (byte)2;
            ch = chars[offset++];
            while (ch >= 48 && ch <= 57) {
                valid = true;
                this.scale = (short)(this.scale + 1);
                if (!overflow) {
                    intValue10 = longValue * 10L + (long)(ch - 48);
                    if (intValue10 < longValue) {
                        overflow = true;
                    } else {
                        longValue = intValue10;
                    }
                }
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = chars[offset++];
            }
        }
        int expValue = 0;
        if (ch == 101 || ch == 69) {
            boolean negativeExp = false;
            if ((ch = chars[offset++]) == 45) {
                negativeExp = true;
                ch = chars[offset++];
            } else if (ch == 43) {
                ch = chars[offset++];
            }
            while (ch >= 48 && ch <= 57) {
                valid = true;
                int byteVal = ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 2047) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = chars[offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (offset == start) {
            if (ch == 110 && chars[offset] == 'u' && chars[offset + 1] == 'l' && chars[offset + 2] == 'l') {
                offset += 3;
                valid = true;
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                value = true;
                ch = offset == this.end ? 26 : chars[offset++];
            } else if (ch == 116 && chars[offset] == 'r' && chars[offset + 1] == 'u' && chars[offset + 2] == 'e') {
                valid = true;
                value = true;
                doubleValue = 1.0;
                ch = (offset += 3) == this.end ? 26 : chars[offset++];
            } else if (ch == 102 && chars[offset] == 'a' && chars[offset + 1] == 'l' && chars[offset + 2] == 's' && chars[offset + 3] == 'e') {
                valid = true;
                doubleValue = 0.0;
                value = true;
                ch = (offset += 4) == this.end ? 26 : chars[offset++];
            } else if (ch == 78 && chars[offset] == 'a' && chars[offset + 1] == 'N') {
                valid = true;
                doubleValue = Double.NaN;
                value = true;
                ch = (offset += 2) == this.end ? 26 : chars[offset++];
            } else if (ch == 123 && quote == 0) {
                valid = true;
                this.ch = (char)ch;
                this.offset = offset;
                Map<String, Object> obj = this.readObject();
                if (!obj.isEmpty()) {
                    throw new JSONException(this.info());
                }
                offset = this.offset;
                ch = this.ch;
                value = true;
                this.wasNull = true;
            } else if (ch == 91 && quote == 0) {
                valid = true;
                this.ch = (char)ch;
                this.offset = offset;
                List array = this.readArray();
                if (!array.isEmpty()) {
                    throw new JSONException(this.info());
                }
                offset = this.offset;
                ch = this.ch;
                value = true;
                this.wasNull = true;
            }
        }
        int len = offset - start;
        String str = null;
        if (quote != 0) {
            if (ch != quote) {
                this.offset = offset - 1;
                this.ch = (char)quote;
                str = this.readString();
                offset = this.offset;
            }
            int n = ch = offset == this.end ? 26 : chars[offset++];
        }
        if (!value) {
            if (!overflow) {
                if (longValue == 0L) {
                    if (this.scale == 1) {
                        doubleValue = 0.0;
                        value = true;
                    }
                } else {
                    int scale = this.scale - expValue;
                    if (scale == 0) {
                        doubleValue = longValue;
                        if (this.negative) {
                            doubleValue = -doubleValue;
                        }
                        value = true;
                    } else if ((long)((double)longValue) == longValue) {
                        if (0 < scale && scale < JSONFactory.DOUBLE_10_POW.length) {
                            doubleValue = (double)longValue / JSONFactory.DOUBLE_10_POW[scale];
                            if (this.negative) {
                                doubleValue = -doubleValue;
                            }
                            value = true;
                        } else if (0 > scale && scale > -JSONFactory.DOUBLE_10_POW.length) {
                            doubleValue = (double)longValue * JSONFactory.DOUBLE_10_POW[-scale];
                            if (this.negative) {
                                doubleValue = -doubleValue;
                            }
                            value = true;
                        }
                    }
                    if (!value && scale > -128 && scale < 128) {
                        doubleValue = TypeUtils.doubleValue(this.negative ? -1 : 1, longValue, scale);
                        value = true;
                    }
                }
            }
            if (!value) {
                if (str != null) {
                    try {
                        doubleValue = Double.parseDouble(str);
                    }
                    catch (NumberFormatException ex) {
                        throw new JSONException(this.info(), ex);
                    }
                } else {
                    doubleValue = TypeUtils.parseDouble(chars, start - 1, len);
                }
            }
            if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
                int n = ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        if (!valid) {
            throw new JSONException(this.info("illegal input error"));
        }
        this.ch = (char)ch;
        this.offset = offset;
        return doubleValue;
    }

    @Override
    public final float readFloatValue() {
        long intValue10;
        boolean valid = false;
        this.wasNull = false;
        boolean value = false;
        float floatValue = 0.0f;
        char[] chars = this.chars;
        int quote = 0;
        int ch = this.ch;
        int offset = this.offset;
        if ((ch == 34 || ch == 39) && (ch = chars[offset++]) == (quote = ch)) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
            this.ch = (char)ch;
            this.offset = offset;
            this.nextIfComma();
            this.wasNull = true;
            return 0.0f;
        }
        int start = offset;
        if (ch == 45) {
            this.negative = true;
            ch = chars[offset++];
        } else {
            this.negative = false;
            if (ch == 43) {
                ch = chars[offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (ch >= 48 && ch <= 57) {
            valid = true;
            if (!overflow) {
                intValue10 = longValue * 10L + (long)(ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                } else {
                    longValue = intValue10;
                }
            }
            if (offset == this.end) {
                ch = 26;
                ++offset;
                break;
            }
            ch = chars[offset++];
        }
        this.scale = 0;
        if (ch == 46) {
            this.valueType = (byte)2;
            ch = chars[offset++];
            while (ch >= 48 && ch <= 57) {
                valid = true;
                this.scale = (short)(this.scale + 1);
                if (!overflow) {
                    intValue10 = longValue * 10L + (long)(ch - 48);
                    if (intValue10 < longValue) {
                        overflow = true;
                    } else {
                        longValue = intValue10;
                    }
                }
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = chars[offset++];
            }
        }
        int expValue = 0;
        if (ch == 101 || ch == 69) {
            boolean negativeExp = false;
            if ((ch = chars[offset++]) == 45) {
                negativeExp = true;
                ch = chars[offset++];
            } else if (ch == 43) {
                ch = chars[offset++];
            }
            while (ch >= 48 && ch <= 57) {
                valid = true;
                int byteVal = ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 2047) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = chars[offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (offset == start) {
            if (ch == 110 && chars[offset] == 'u' && chars[offset + 1] == 'l' && chars[offset + 2] == 'l') {
                offset += 3;
                valid = true;
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                value = true;
                ch = offset == this.end ? 26 : chars[offset++];
            } else if (ch == 116 && chars[offset] == 'r' && chars[offset + 1] == 'u' && chars[offset + 2] == 'e') {
                valid = true;
                value = true;
                floatValue = 1.0f;
                ch = (offset += 3) == this.end ? 26 : chars[offset++];
            } else if (ch == 102 && chars[offset] == 'a' && chars[offset + 1] == 'l' && chars[offset + 2] == 's' && chars[offset + 3] == 'e') {
                valid = true;
                floatValue = 0.0f;
                value = true;
                ch = (offset += 4) == this.end ? 26 : chars[offset++];
            } else if (ch == 78 && chars[offset] == 'a' && chars[offset + 1] == 'N') {
                valid = true;
                value = true;
                floatValue = Float.NaN;
                ch = (offset += 2) == this.end ? 26 : chars[offset++];
            } else if (ch == 123 && quote == 0) {
                valid = true;
                this.ch = (char)ch;
                this.offset = offset;
                Map<String, Object> obj = this.readObject();
                if (!obj.isEmpty()) {
                    throw new JSONException(this.info());
                }
                ch = this.ch;
                offset = this.offset;
                value = true;
                this.wasNull = true;
            } else if (ch == 91 && quote == 0) {
                this.ch = (char)ch;
                this.offset = offset;
                valid = true;
                List array = this.readArray();
                if (!array.isEmpty()) {
                    throw new JSONException(this.info());
                }
                ch = this.ch;
                offset = this.offset;
                value = true;
                this.wasNull = true;
            }
        }
        int len = offset - start;
        String str = null;
        if (quote != 0) {
            if (ch != quote) {
                overflow = true;
                this.offset = offset - 1;
                this.ch = (char)quote;
                str = this.readString();
                offset = this.offset;
            }
            int n = ch = offset >= this.end ? 26 : chars[offset++];
        }
        if (!value) {
            if (!overflow) {
                int scale = this.scale - expValue;
                if (scale == 0) {
                    floatValue = longValue;
                    if (this.negative) {
                        floatValue = -floatValue;
                    }
                    value = true;
                } else if ((long)((float)longValue) == longValue) {
                    if (0 < scale && scale < JSONFactory.FLOAT_10_POW.length) {
                        floatValue = (float)longValue / JSONFactory.FLOAT_10_POW[scale];
                        if (this.negative) {
                            floatValue = -floatValue;
                        }
                    } else if (0 > scale && scale > -JSONFactory.FLOAT_10_POW.length) {
                        floatValue = (float)longValue * JSONFactory.FLOAT_10_POW[-scale];
                        if (this.negative) {
                            floatValue = -floatValue;
                        }
                    }
                }
                if (!value && scale > -128 && scale < 128) {
                    floatValue = TypeUtils.floatValue(this.negative ? -1 : 1, longValue, scale);
                    value = true;
                }
            }
            if (!value) {
                if (str != null) {
                    try {
                        floatValue = Float.parseFloat(str);
                    }
                    catch (NumberFormatException ex) {
                        throw new JSONException(this.info(), ex);
                    }
                } else {
                    floatValue = TypeUtils.parseFloat(chars, start - 1, len);
                }
            }
            if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
                int n = ch = offset >= this.end ? 26 : chars[offset++];
            }
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset >= this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset >= this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset >= this.end ? 26 : chars[offset++];
            }
        }
        if (!valid) {
            throw new JSONException(this.info("illegal input error"));
        }
        this.ch = (char)ch;
        this.offset = offset;
        return floatValue;
    }

    private void skipString() {
        char[] chars = this.chars;
        int offset = this.offset;
        char quote = this.ch;
        char ch = chars[offset++];
        while (true) {
            if (ch == '\\') {
                if (offset >= this.end) {
                    throw new JSONException(this.info("illegal string, end"));
                }
                if ((ch = chars[offset++]) == 'u') {
                    offset += 4;
                } else if (ch == 'x') {
                    offset += 2;
                } else if (ch != '\\' && ch != '\"') {
                    this.char1(ch);
                }
                ch = chars[offset++];
                continue;
            }
            if (ch == quote) {
                ch = offset == this.end ? chars[offset++] : (char)'\u001a';
                break;
            }
            ch = offset == this.end ? chars[offset++] : (char)'\u001a';
        }
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = chars[offset++];
        }
        this.comma = ch == ',';
        if (this.comma) {
            if (offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return;
            }
            ch = chars[offset];
            while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                if (++offset >= this.end) {
                    this.offset = offset;
                    this.ch = (char)26;
                    return;
                }
                ch = chars[offset];
            }
            ++offset;
        } else if (ch != '\u001a' && ch != '}' && ch != ']' && ch != '\u001a') {
            throw this.error(offset, ch);
        }
        this.offset = offset;
        this.ch = ch;
    }

    @Override
    public final String getString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        int length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            return new String(this.chars, this.nameBegin, length);
        }
        char[] chars = this.chars;
        char[] buf = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (true) {
            char c;
            if ((c = chars[offset]) == '\\') {
                c = chars[++offset];
                switch (c) {
                    case 'u': {
                        c = JSONReaderUTF16.char4(chars[offset + 1], chars[offset + 2], chars[offset + 3], chars[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        c = JSONReaderUTF16.char2(chars[offset + 1], chars[offset + 2]);
                        offset += 2;
                        break;
                    }
                    case '\"': 
                    case '\\': {
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            buf[i] = c;
            ++offset;
            ++i;
        }
        this.stringValue = new String(buf);
        return this.stringValue;
    }

    protected final void readString0() {
        String str;
        int offset;
        char[] chars = this.chars;
        char quote = this.ch;
        int start = offset = this.offset;
        this.valueEscape = false;
        int i = 0;
        while (true) {
            char c;
            if ((c = chars[offset]) == '\\') {
                this.valueEscape = true;
                offset += (c = chars[offset + 1]) == 'u' ? 6 : (c == 'x' ? 4 : 2);
            } else {
                if (c == quote) break;
                ++offset;
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            char[] buf = new char[valueLength];
            offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = this.chars[offset]) == '\\') {
                    if ((c = this.chars[++offset]) == 'u') {
                        c = JSONReaderUTF16.char4(chars[offset + 1], chars[offset + 2], chars[offset + 3], chars[offset + 4]);
                        offset += 4;
                    } else if (c == 'x') {
                        c = JSONReaderUTF16.char2(chars[offset + 1], chars[offset + 2]);
                        offset += 2;
                    } else if (c != '\\' && c != '\"') {
                        c = this.char1(c);
                    }
                } else if (c == '\"') break;
                buf[i2] = c;
                ++offset;
                ++i2;
            }
            str = new String(buf);
        } else {
            str = new String(chars, this.offset, offset - this.offset);
        }
        int b = ++offset == this.end ? 26 : chars[offset];
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = chars[++offset];
        }
        this.comma = b == 44;
        if (this.comma) {
            this.offset = offset + 1;
            this.ch = chars[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = chars[this.offset++];
            }
        } else {
            this.offset = offset + 1;
            this.ch = (char)b;
        }
        this.stringValue = str;
    }

    @Override
    public String readString() {
        if (this.ch == '\"' || this.ch == '\'') {
            int ch;
            String str;
            int valueLength;
            int offset;
            char[] chars = this.chars;
            char quote = this.ch;
            int start = offset = this.offset;
            boolean valueEscape = false;
            int i = 0;
            char c0 = '\u0000';
            char c1 = '\u0000';
            char c2 = '\u0000';
            boolean quoted = false;
            int upperBound = offset + (this.end - offset & 0xFFFFFFFC);
            while (offset < upperBound) {
                c0 = chars[offset];
                c1 = chars[offset + 1];
                c2 = chars[offset + 2];
                char c3 = chars[offset + 3];
                if (c0 == '\\' || c1 == '\\' || c2 == '\\' || c3 == '\\') break;
                if (c0 == quote || c1 == quote || c2 == quote || c3 == quote) {
                    quoted = true;
                    break;
                }
                offset += 4;
                i += 4;
            }
            if (quoted) {
                if (c0 != quote) {
                    if (c1 == quote) {
                        ++offset;
                        ++i;
                    } else if (c2 == quote) {
                        offset += 2;
                        i += 2;
                    } else {
                        offset += 3;
                        i += 3;
                    }
                }
                valueLength = i;
            } else {
                while (true) {
                    if (offset >= this.end) {
                        throw new JSONException(this.info("invalid escape character EOI"));
                    }
                    char c = chars[offset];
                    if (c == '\\') {
                        valueEscape = true;
                        offset += (c = chars[offset + 1]) == 'u' ? 6 : (c == 'x' ? 4 : 2);
                    } else {
                        if (c == quote) {
                            valueLength = i;
                            break;
                        }
                        ++offset;
                    }
                    ++i;
                }
            }
            if (valueEscape) {
                char[] buf = new char[valueLength];
                offset = start;
                int i2 = 0;
                while (true) {
                    char c;
                    if ((c = chars[offset]) == '\\') {
                        c = chars[++offset];
                        switch (c) {
                            case 'u': {
                                c = JSONReaderUTF16.char4(chars[offset + 1], chars[offset + 2], chars[offset + 3], chars[offset + 4]);
                                offset += 4;
                                break;
                            }
                            case 'x': {
                                c = JSONReaderUTF16.char2(chars[offset + 1], chars[offset + 2]);
                                offset += 2;
                                break;
                            }
                            case '\"': 
                            case '\\': {
                                break;
                            }
                            case 'b': {
                                c = '\b';
                                break;
                            }
                            case 't': {
                                c = '\t';
                                break;
                            }
                            case 'n': {
                                c = '\n';
                                break;
                            }
                            case 'f': {
                                c = '\f';
                                break;
                            }
                            case 'r': {
                                c = '\r';
                                break;
                            }
                            default: {
                                c = this.char1(c);
                                break;
                            }
                        }
                    } else if (c == quote) break;
                    buf[i2] = c;
                    ++offset;
                    ++i2;
                }
                str = JDKUtils.STRING_CREATOR_JDK8 != null ? JDKUtils.STRING_CREATOR_JDK8.apply(buf, Boolean.TRUE) : new String(buf);
            } else {
                int strlen = offset - start;
                str = strlen == 1 && (c0 = chars[start]) < '\u0080' ? TypeUtils.toString(c0) : (strlen == 2 && (c0 = chars[start]) < '\u0080' && (c1 = chars[start + 1]) < '\u0080' ? TypeUtils.toString(c0, c1) : (this.str != null && (JDKUtils.JVM_VERSION > 8 || JDKUtils.ANDROID) ? this.str.substring(start, offset) : new String(chars, start, offset - start)));
            }
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            if (str.isEmpty() && (this.context.features & JSONReader.Feature.EmptyStringAsNull.mask) != 0L) {
                str = null;
            }
            int n = ch = ++offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
            this.comma = ch == 44;
            if (this.comma) {
                int n2 = ch = offset == this.end ? 26 : chars[offset++];
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    ch = offset == this.end ? 26 : chars[offset++];
                }
            }
            this.ch = (char)ch;
            this.offset = offset;
            return str;
        }
        return this.readStringNotMatch();
    }

    @Override
    public final void skipValue() {
        char[] chars = this.chars;
        int ch = this.ch;
        int offset = this.offset;
        int end = this.end;
        this.comma = false;
        block0 : switch (ch) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                boolean sign;
                boolean bl = sign = ch == 45 || ch == 43;
                if (sign) {
                    if (offset < end) {
                        ch = chars[offset++];
                    } else {
                        throw JSONReaderUTF16.numberError(offset, ch);
                    }
                }
                boolean dot = ch == 46;
                boolean num = false;
                if (!dot && ch >= 48 && ch <= 57) {
                    num = true;
                    do {
                        int n = ch = offset == end ? 26 : chars[offset++];
                    } while (ch >= 48 && ch <= 57);
                }
                if (num && (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83)) {
                    ch = chars[offset++];
                }
                boolean small = false;
                if (ch == 46) {
                    small = true;
                    int n = ch = offset == end ? 26 : chars[offset++];
                    if (ch >= 48 && ch <= 57) {
                        do {
                            int n2 = ch = offset == end ? 26 : chars[offset++];
                        } while (ch >= 48 && ch <= 57);
                    }
                }
                if (!num && !small) {
                    throw JSONReaderUTF16.numberError(offset, ch);
                }
                if (ch == 101 || ch == 69) {
                    ch = chars[offset++];
                    boolean eSign = false;
                    if (ch == 43 || ch == 45) {
                        eSign = true;
                        if (offset < end) {
                            ch = chars[offset++];
                        } else {
                            throw JSONReaderUTF16.numberError(offset, ch);
                        }
                    }
                    if (ch >= 48 && ch <= 57) {
                        do {
                            int n = ch = offset == end ? 26 : chars[offset++];
                        } while (ch >= 48 && ch <= 57);
                    } else if (eSign) {
                        throw JSONReaderUTF16.numberError(offset, ch);
                    }
                }
                if (ch != 76 && ch != 70 && ch != 68 && ch != 66 && ch != 83) break;
                ch = offset == end ? 26 : chars[offset++];
                break;
            }
            case 116: {
                if (offset + 3 > end) {
                    throw this.error(offset, ch);
                }
                if (chars[offset] != 'r' || chars[offset + 1] != 'u' || chars[offset + 2] != 'e') {
                    throw this.error(offset, ch);
                }
                ch = (offset += 3) == end ? 26 : chars[offset++];
                break;
            }
            case 102: {
                if (offset + 4 > end) {
                    throw this.error(offset, ch);
                }
                if (chars[offset] != 'a' || chars[offset + 1] != 'l' || chars[offset + 2] != 's' || chars[offset + 3] != 'e') {
                    throw this.error(offset, ch);
                }
                ch = (offset += 4) == end ? 26 : chars[offset++];
                break;
            }
            case 110: {
                if (offset + 3 > end) {
                    throw this.error(offset, ch);
                }
                if (chars[offset] != 'u' || chars[offset + 1] != 'l' || chars[offset + 2] != 'l') {
                    throw this.error(offset, ch);
                }
                ch = (offset += 3) == end ? 26 : chars[offset++];
                break;
            }
            case 34: 
            case 39: {
                int quote = ch;
                ch = chars[offset++];
                while (true) {
                    if (ch == 92) {
                        if ((ch = chars[offset++]) == 117) {
                            offset += 4;
                        } else if (ch == 120) {
                            offset += 2;
                        } else if (ch != 92 && ch != 34) {
                            this.char1(ch);
                        }
                        ch = chars[offset++];
                        continue;
                    }
                    if (ch == quote) {
                        ch = offset == end ? 26 : chars[offset++];
                        break block0;
                    }
                    ch = chars[offset++];
                }
            }
            default: {
                if (ch == 91) {
                    this.next();
                    int i = 0;
                    while (true) {
                        if (this.ch == ']') {
                            this.comma = false;
                            offset = this.offset;
                            ch = offset == end ? 26 : chars[offset++];
                            break block0;
                        }
                        if (i != 0 && !this.comma) {
                            throw this.valueError();
                        }
                        this.comma = false;
                        this.skipValue();
                        ++i;
                    }
                }
                if (ch == 123) {
                    this.next();
                    while (true) {
                        if (this.ch == '}') {
                            this.comma = false;
                            offset = this.offset;
                            ch = offset == end ? 26 : chars[offset++];
                            break block0;
                        }
                        this.skipName();
                        this.skipValue();
                    }
                }
                if (ch != 83 || !this.nextIfSet()) {
                    throw this.error(offset, ch);
                }
                this.skipValue();
                ch = this.ch;
                offset = this.offset;
            }
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : chars[offset++];
        }
        if (ch == 44) {
            this.comma = true;
            int n = ch = offset == end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : chars[offset++];
            }
        }
        if (!this.comma && ch != 125 && ch != 93 && ch != 26) {
            throw this.error(offset, ch);
        }
        if (this.comma && (ch == 125 || ch == 93 || ch == 26)) {
            throw this.error(offset, ch);
        }
        this.ch = (char)ch;
        this.offset = offset;
    }

    @Override
    public final void skipComment() {
        boolean multi;
        int ch;
        int offset = this.offset;
        if (offset + 1 >= this.end) {
            throw new JSONException(this.info());
        }
        char[] chars = this.chars;
        if ((ch = chars[offset++]) == 42) {
            multi = true;
        } else if (ch == 47) {
            multi = false;
        } else {
            return;
        }
        ch = chars[offset++];
        while (true) {
            boolean endOfComment = false;
            if (multi) {
                if (ch == 42 && offset <= this.end && chars[offset] == '/') {
                    ++offset;
                    endOfComment = true;
                }
            } else {
                boolean bl = endOfComment = ch == 10;
            }
            if (endOfComment) {
                if (offset >= this.end) {
                    ch = 26;
                    break;
                }
                ch = chars[offset];
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    if (++offset >= this.end) {
                        ch = 26;
                        break;
                    }
                    ch = chars[offset];
                }
                ++offset;
                break;
            }
            if (offset >= this.end) {
                ch = 26;
                break;
            }
            ch = chars[offset++];
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
    }

    @Override
    public final void readNumber0() {
        int digit;
        int multmin;
        boolean valid = false;
        this.wasNull = false;
        this.mag0 = 0;
        this.mag1 = 0;
        this.mag2 = 0;
        this.mag3 = 0;
        this.negative = false;
        this.exponent = 0;
        this.scale = 0;
        int firstOffset = this.offset;
        char[] chars = this.chars;
        int ch = this.ch;
        int offset = this.offset;
        int quote = 0;
        if ((ch == 34 || ch == 39) && (ch = chars[offset++]) == (quote = ch)) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
            this.ch = (char)ch;
            this.offset = offset;
            this.comma = this.nextIfComma();
            this.wasNull = true;
            this.valueType = (byte)5;
            return;
        }
        int start = offset;
        if (ch == 45) {
            if (offset == this.end) {
                throw new JSONException(this.info("illegal input"));
            }
            multmin = -214748364;
            this.negative = true;
            ch = chars[offset++];
        } else {
            if (ch == 43) {
                if (offset == this.end) {
                    throw new JSONException(this.info("illegal input"));
                }
                ch = chars[offset++];
            }
            multmin = -214748364;
        }
        boolean intOverflow = false;
        this.valueType = 1;
        while (ch >= 48 && ch <= 57) {
            valid = true;
            if (!intOverflow) {
                digit = ch - 48;
                this.mag3 *= 10;
                if (this.mag3 < multmin) {
                    intOverflow = true;
                } else {
                    this.mag3 -= digit;
                    if (this.mag3 < multmin) {
                        intOverflow = true;
                    }
                }
            }
            if (offset == this.end) {
                ch = 26;
                ++offset;
                break;
            }
            ch = chars[offset++];
        }
        if (ch == 46) {
            this.valueType = (byte)2;
            ch = chars[offset++];
            while (ch >= 48 && ch <= 57) {
                valid = true;
                if (!intOverflow) {
                    digit = ch - 48;
                    this.mag3 *= 10;
                    if (this.mag3 < multmin) {
                        intOverflow = true;
                    } else {
                        this.mag3 -= digit;
                        if (this.mag3 < multmin) {
                            intOverflow = true;
                        }
                    }
                }
                this.scale = (short)(this.scale + 1);
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = chars[offset++];
            }
        }
        if (intOverflow) {
            int numDigits;
            int numStart = this.negative ? start : start - 1;
            int n = numDigits = this.scale > 0 ? offset - 2 - numStart : offset - 1 - numStart;
            if (numDigits > 38) {
                this.valueType = (byte)8;
                if (this.negative) {
                    --numStart;
                }
                this.stringValue = new String(chars, numStart, offset - 1 - numStart);
            } else {
                this.bigInt(chars, numStart, offset - 1);
            }
        } else {
            this.mag3 = -this.mag3;
        }
        if (ch == 101 || ch == 69) {
            boolean negativeExp = false;
            int expValue = 0;
            if ((ch = chars[offset++]) == 45) {
                negativeExp = true;
                ch = chars[offset++];
            } else if (ch == 43) {
                ch = chars[offset++];
            }
            while (ch >= 48 && ch <= 57) {
                valid = true;
                int byteVal = ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 2047) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (offset == this.end) {
                    ch = 26;
                    break;
                }
                ch = chars[offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (offset == start) {
            if (ch == 110) {
                if (chars[offset] == 'u' && chars[offset + 1] == 'l' && chars[offset + 2] == 'l') {
                    valid = true;
                    this.wasNull = true;
                    this.valueType = (byte)5;
                    ch = (offset += 3) == this.end ? 26 : chars[offset++];
                }
            } else if (ch == 116 && chars[offset] == 'r' && chars[offset + 1] == 'u' && chars[offset + 2] == 'e') {
                valid = true;
                this.boolValue = true;
                this.valueType = (byte)4;
                ch = (offset += 3) == this.end ? 26 : chars[offset++];
            } else if (ch == 102 && chars[offset] == 'a' && chars[offset + 1] == 'l' && chars[offset + 2] == 's' && chars[offset + 3] == 'e') {
                valid = true;
                this.boolValue = false;
                this.valueType = (byte)4;
                ch = (offset += 4) == this.end ? 26 : chars[offset++];
            } else {
                if (ch == 123 && quote == 0) {
                    this.offset = offset;
                    this.ch = (char)ch;
                    this.complex = this.readObject();
                    this.valueType = (byte)6;
                    return;
                }
                if (ch == 91 && quote == 0) {
                    this.offset = offset;
                    this.ch = (char)ch;
                    this.complex = this.readArray();
                    this.valueType = (byte)7;
                    return;
                }
            }
        }
        if (quote != 0) {
            if (ch != quote) {
                this.offset = firstOffset;
                this.ch = (char)quote;
                this.readString0();
                this.valueType = (byte)3;
                return;
            }
            int n = ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
            switch (ch) {
                case 66: {
                    if (intOverflow || this.valueType == 2) break;
                    this.valueType = (byte)9;
                    break;
                }
                case 83: {
                    if (intOverflow || this.valueType == 2) break;
                    this.valueType = (byte)10;
                    break;
                }
                case 76: {
                    if (offset - start >= 19 || this.valueType == 2) break;
                    this.valueType = (byte)11;
                    break;
                }
                case 70: {
                    this.valueType = (byte)12;
                    break;
                }
                case 68: {
                    this.valueType = (byte)13;
                    break;
                }
            }
            int n = ch = offset == this.end ? 26 : chars[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        if (!valid) {
            throw new JSONException(this.info("illegal input error"));
        }
        this.offset = offset;
        this.ch = (char)ch;
    }

    @Override
    public final boolean readIfNull() {
        char[] chars = this.chars;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 110 && chars[offset] == 'u' && chars[offset + 1] == 'l' && chars[offset + 2] == 'l') {
            ch = offset + 3 == this.end ? 26 : chars[offset + 3];
            offset += 4;
        } else {
            return false;
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return true;
    }

    @Override
    public final Date readNullOrNewDate() {
        Date date = null;
        char[] chars = this.chars;
        int offset = this.offset;
        int ch = this.ch;
        if (offset + 2 < this.end && chars[offset] == 'u' && chars[offset + 1] == 'l' && chars[offset + 2] == 'l') {
            ch = offset + 3 == this.end ? 26 : chars[offset + 3];
            offset += 4;
        } else if (offset + 1 < this.end && chars[offset] == 'e' && chars[offset + 1] == 'w') {
            ch = offset + 3 == this.end ? 26 : chars[offset + 2];
            offset += 3;
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                if (offset >= this.end) {
                    ch = 26;
                    continue;
                }
                ch = chars[offset++];
            }
            if (offset + 4 < this.end && ch == 68 && chars[offset] == 'a' && chars[offset + 1] == 't' && chars[offset + 2] == 'e') {
                ch = offset + 3 == this.end ? 26 : chars[offset + 3];
                offset += 4;
            } else {
                throw new JSONException("json syntax error, not match new Date" + offset);
            }
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
            if (ch != 40 || offset >= this.end) {
                throw new JSONException("json syntax error, not match new Date" + offset);
            }
            ch = chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
            this.ch = (char)ch;
            this.offset = offset;
            long millis = this.readInt64Value();
            ch = this.ch;
            offset = this.offset;
            if (ch != 41) {
                throw new JSONException("json syntax error, not match new Date" + offset);
            }
            ch = offset == this.end ? 26 : chars[offset++];
            date = new Date(millis);
        } else {
            throw new JSONException("json syntax error, not match null or new Date" + offset);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return date;
    }

    @Override
    public final boolean isNull() {
        return this.ch == 'n' && this.offset < this.end && this.chars[this.offset] == 'u';
    }

    @Override
    public final boolean nextIfNull() {
        if (this.ch == 'n' && this.offset + 2 < this.end && this.chars[this.offset] == 'u') {
            this.readNull();
            return true;
        }
        return false;
    }

    @Override
    public final void readNull() {
        int ch;
        char[] chars = this.chars;
        int offset = this.offset;
        if (chars[offset] == 'u' && chars[offset + 1] == 'l' && chars[offset + 2] == 'l') {
            ch = offset + 3 == this.end ? 26 : chars[offset + 3];
            offset += 4;
        } else {
            throw new JSONException("json syntax error, not match null, offset " + offset);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
    }

    @Override
    public final BigDecimal readBigDecimal() {
        long r;
        boolean valid = false;
        char[] chars = this.chars;
        int ch = this.ch;
        int offset = this.offset;
        boolean value = false;
        BigDecimal decimal = null;
        int quote = 0;
        if ((ch == 34 || ch == 39) && (ch = chars[offset++]) == (quote = ch)) {
            this.ch = (char)(offset == this.end ? 26 : chars[offset++]);
            this.offset = offset;
            this.nextIfComma();
            return null;
        }
        int start = offset;
        if (ch == 45) {
            this.negative = true;
            ch = chars[offset++];
        } else {
            this.negative = false;
            if (ch == 43) {
                ch = chars[offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (ch >= 48 && ch <= 57) {
            valid = true;
            if (!overflow) {
                r = longValue * 10L;
                if ((longValue | 0xAL) >>> 31 == 0L || r / 10L == longValue) {
                    longValue = r + (long)(ch - 48);
                } else {
                    overflow = true;
                }
            }
            if (offset == this.end) {
                ch = 26;
                ++offset;
                break;
            }
            ch = chars[offset++];
        }
        if (longValue < 0L) {
            overflow = true;
        }
        this.scale = 0;
        if (ch == 46) {
            this.valueType = (byte)2;
            ch = chars[offset++];
            while (ch >= 48 && ch <= 57) {
                valid = true;
                this.scale = (short)(this.scale + 1);
                if (!overflow) {
                    r = longValue * 10L;
                    if ((longValue | 0xAL) >>> 31 == 0L || r / 10L == longValue) {
                        longValue = r + (long)(ch - 48);
                    } else {
                        overflow = true;
                    }
                }
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = chars[offset++];
            }
        }
        int expValue = 0;
        if (ch == 101 || ch == 69) {
            boolean negativeExp;
            if ((negativeExp = (ch = chars[offset++]) == 45) || ch == 43) {
                ch = chars[offset++];
            }
            while (ch >= 48 && ch <= 57) {
                valid = true;
                int byteVal = ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 2047) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = chars[offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (offset == start) {
            if (ch == 110 && chars[offset++] == 'u' && chars[offset++] == 'l' && chars[offset++] == 'l') {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                value = true;
                ch = offset == this.end ? 26 : chars[offset];
                ++offset;
                valid = true;
            } else if (ch == 116 && offset + 3 <= this.end && chars[offset] == 'r' && chars[offset + 1] == 'u' && chars[offset + 2] == 'e') {
                valid = true;
                value = true;
                decimal = BigDecimal.ONE;
                ch = (offset += 3) == this.end ? 26 : chars[offset];
                ++offset;
            } else if (ch == 102 && offset + 4 <= this.end && chars[offset] == 'a' && chars[offset + 1] == 'l' && chars[offset + 2] == 's' && chars[offset + 3] == 'e') {
                valid = true;
                decimal = BigDecimal.ZERO;
                value = true;
                ch = (offset += 4) == this.end ? 26 : chars[offset];
                ++offset;
            } else {
                if (ch == 123 && quote == 0) {
                    JSONObject jsonObject = new JSONObject();
                    this.readObject((Object)jsonObject, 0L);
                    this.wasNull = false;
                    return this.decimal(jsonObject);
                }
                if (ch == 91 && quote == 0) {
                    List array = this.readArray();
                    if (!array.isEmpty()) {
                        throw new JSONException(this.info());
                    }
                    this.wasNull = true;
                    return null;
                }
            }
        }
        int len = offset - start;
        if (quote != 0) {
            if (ch != quote) {
                String str = this.readString();
                try {
                    return TypeUtils.toBigDecimal(str);
                }
                catch (NumberFormatException e) {
                    throw new JSONException(this.info(e.getMessage()), e);
                }
            }
            int n = ch = offset >= this.end ? 26 : chars[offset++];
        }
        if (!value) {
            if (expValue == 0 && !overflow && longValue != 0L) {
                decimal = BigDecimal.valueOf(this.negative ? -longValue : longValue, this.scale);
                value = true;
            }
            if (!value) {
                decimal = TypeUtils.parseBigDecimal(chars, start - 1, len);
            }
            if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
                int n = ch = offset >= this.end ? 26 : chars[offset++];
            }
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        if (!valid) {
            throw new JSONException(this.info("illegal input error"));
        }
        this.ch = (char)ch;
        this.offset = offset;
        return decimal;
    }

    @Override
    public final UUID readUUID() {
        int i;
        char ch = this.ch;
        if (ch == 'n') {
            this.readNull();
            return null;
        }
        if (ch != '\"' && ch != '\'') {
            throw new JSONException(this.info("syntax error, can not read uuid"));
        }
        char quote = ch;
        char[] chars = this.chars;
        int offset = this.offset;
        long hi = 0L;
        long lo = 0L;
        if (offset + 36 < chars.length && chars[offset + 36] == quote && chars[offset + 8] == '-' && chars[offset + 13] == '-' && chars[offset + 18] == '-' && chars[offset + 23] == '-') {
            for (i = 0; i < 8; ++i) {
                hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i] - 48];
            }
            for (i = 9; i < 13; ++i) {
                hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i] - 48];
            }
            for (i = 14; i < 18; ++i) {
                hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i] - 48];
            }
            for (i = 19; i < 23; ++i) {
                lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i] - 48];
            }
            for (i = 24; i < 36; ++i) {
                lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i] - 48];
            }
            offset += 37;
        } else if (offset + 32 < chars.length && chars[offset + 32] == quote) {
            for (i = 0; i < 16; ++i) {
                hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i] - 48];
            }
            for (i = 16; i < 32; ++i) {
                lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[chars[offset + i] - 48];
            }
            offset += 33;
        } else {
            String str = this.readString();
            if (str.isEmpty()) {
                return null;
            }
            return UUID.fromString(str);
        }
        char c = ch = offset == this.end ? (char)'\u001a' : chars[offset++];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (char)'\u001a' : chars[offset++];
        }
        this.offset = offset;
        this.comma = ch == ',';
        if (this.comma) {
            this.next();
        } else {
            this.ch = ch;
        }
        return new UUID(hi, lo);
    }

    @Override
    public final int getStringLength() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("string length only support string input");
        }
        char quote = this.ch;
        int len = 0;
        int i = this.offset;
        char[] chars = this.chars;
        int i8 = i + 8;
        if (i8 < this.end && i8 < chars.length && chars[i] != quote && chars[i + 1] != quote && chars[i + 2] != quote && chars[i + 3] != quote && chars[i + 4] != quote && chars[i + 5] != quote && chars[i + 6] != quote && chars[i + 7] != quote) {
            i += 8;
            len += 8;
        }
        while (i < this.end && chars[i] != quote) {
            ++i;
            ++len;
        }
        return len;
    }

    @Override
    protected final LocalDateTime readLocalDateTime14() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime14(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 15;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime12() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime12(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 13;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime16() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime16(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 17;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime17() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime17(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 18;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime18() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime18(this.chars, this.offset);
        this.offset += 19;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalTime readLocalTime5() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime5(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 6;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime6() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime6(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 7;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime7() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime7(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 8;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime8() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime8(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 9;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime9() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime8(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 10;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    public final LocalDate readLocalDate8() {
        LocalDate ldt;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate8(this.chars, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        this.offset += 9;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate9() {
        LocalDate ldt;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate9(this.chars, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        this.offset += 10;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate10() {
        LocalDate ldt;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate10(this.chars, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        if (ldt == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate11() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localDate only support string input");
        }
        LocalDate ldt = DateUtils.parseLocalDate11(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 12;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate() {
        char[] chars = this.chars;
        int offset = this.offset;
        if (this.ch == '\"' || this.ch == '\'') {
            JSONReader.Context context = this.context;
            if (context.dateFormat == null || context.formatyyyyMMddhhmmss19 || context.formatyyyyMMddhhmmssT19 || context.formatyyyyMMdd8 || context.formatISO8601) {
                char quote = this.ch;
                int c10 = offset + 10;
                if (c10 < chars.length && c10 < this.end && chars[offset + 4] == '-' && chars[offset + 7] == '-' && chars[offset + 10] == quote) {
                    char y0 = chars[offset];
                    char y1 = chars[offset + 1];
                    char y2 = chars[offset + 2];
                    char y3 = chars[offset + 3];
                    char m0 = chars[offset + 5];
                    char m1 = chars[offset + 6];
                    char d0 = chars[offset + 8];
                    char d1 = chars[offset + 9];
                    if (y0 >= '0' && y0 <= '9' && y1 >= '0' && y1 <= '9' && y2 >= '0' && y2 <= '9' && y3 >= '0' && y3 <= '9') {
                        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
                        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
                            int month = (m0 - 48) * 10 + (m1 - 48);
                            if (d0 >= '0' && d0 <= '9' && d1 >= '0' && d1 <= '9') {
                                LocalDate ldt;
                                int dom = (d0 - 48) * 10 + (d1 - 48);
                                try {
                                    ldt = year == 0 && month == 0 && dom == 0 ? null : LocalDate.of(year, month, dom);
                                }
                                catch (DateTimeException ex) {
                                    throw new JSONException(this.info("read date error"), ex);
                                }
                                this.offset = offset + 11;
                                this.next();
                                this.comma = this.ch == ',';
                                if (this.comma) {
                                    this.next();
                                }
                                return ldt;
                            }
                        }
                    }
                }
            }
        }
        return super.readLocalDate();
    }

    @Override
    public final OffsetDateTime readOffsetDateTime() {
        ZonedDateTime zdt;
        char[] chars = this.chars;
        int offset = this.offset;
        JSONReader.Context context = this.context;
        if ((this.ch == '\"' || this.ch == '\'') && (context.dateFormat == null || context.formatyyyyMMddhhmmss19 || context.formatyyyyMMddhhmmssT19 || context.formatyyyyMMdd8 || context.formatISO8601)) {
            char c10;
            char quote = this.ch;
            int off21 = offset + 19;
            if (off21 < chars.length && off21 < this.end && chars[offset + 4] == '-' && chars[offset + 7] == '-' && ((c10 = chars[offset + 10]) == ' ' || c10 == 'T') && chars[offset + 13] == ':' && chars[offset + 16] == ':') {
                int start;
                LocalDate localDate;
                char y0 = chars[offset];
                char y1 = chars[offset + 1];
                char y2 = chars[offset + 2];
                char y3 = chars[offset + 3];
                char m0 = chars[offset + 5];
                char m1 = chars[offset + 6];
                char d0 = chars[offset + 8];
                char d1 = chars[offset + 9];
                char h0 = chars[offset + 11];
                char h1 = chars[offset + 12];
                char i0 = chars[offset + 14];
                char i1 = chars[offset + 15];
                char s0 = chars[offset + 17];
                char s1 = chars[offset + 18];
                if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
                    ZonedDateTime zdt2 = this.readZonedDateTime();
                    return zdt2 == null ? null : zdt2.toOffsetDateTime();
                }
                int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
                if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
                    ZonedDateTime zdt3 = this.readZonedDateTime();
                    return zdt3 == null ? null : zdt3.toOffsetDateTime();
                }
                int month = (m0 - 48) * 10 + (m1 - 48);
                if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
                    ZonedDateTime zdt4 = this.readZonedDateTime();
                    return zdt4 == null ? null : zdt4.toOffsetDateTime();
                }
                int dom = (d0 - 48) * 10 + (d1 - 48);
                if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
                    ZonedDateTime zdt5 = this.readZonedDateTime();
                    return zdt5 == null ? null : zdt5.toOffsetDateTime();
                }
                int hour = (h0 - 48) * 10 + (h1 - 48);
                if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
                    ZonedDateTime zdt6 = this.readZonedDateTime();
                    return zdt6 == null ? null : zdt6.toOffsetDateTime();
                }
                int minute = (i0 - 48) * 10 + (i1 - 48);
                if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
                    ZonedDateTime zdt7 = this.readZonedDateTime();
                    return zdt7 == null ? null : zdt7.toOffsetDateTime();
                }
                int second = (s0 - 48) * 10 + (s1 - 48);
                try {
                    localDate = year == 0 && month == 0 && dom == 0 ? null : LocalDate.of(year, month, dom);
                }
                catch (DateTimeException ex) {
                    throw new JSONException(this.info("read date error"), ex);
                }
                int nanoSize = -1;
                int len = 0;
                int end = offset + 31;
                for (int i = start = offset + 19; i < end && i < this.end && i < chars.length; ++i) {
                    if (chars[i] != quote || chars[i - 1] != 'Z') continue;
                    nanoSize = i - start - 2;
                    len = i - offset + 1;
                    break;
                }
                if (nanoSize != -1 || len == 21) {
                    int nano = nanoSize <= 0 ? 0 : DateUtils.readNanos(chars, nanoSize, offset + 20);
                    LocalTime localTime = LocalTime.of(hour, minute, second, nano);
                    LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
                    OffsetDateTime oft = OffsetDateTime.of(ldt, ZoneOffset.UTC);
                    this.offset += len;
                    this.next();
                    this.comma = this.ch == ',';
                    if (this.comma) {
                        this.next();
                    }
                    return oft;
                }
            }
        }
        return (zdt = this.readZonedDateTime()) == null ? null : zdt.toOffsetDateTime();
    }

    @Override
    public final OffsetTime readOffsetTime() {
        char[] chars = this.chars;
        int offset = this.offset;
        JSONReader.Context context = this.context;
        if ((this.ch == '\"' || this.ch == '\'') && context.dateFormat == null) {
            char quote = this.ch;
            int off10 = offset + 8;
            if (off10 < chars.length && off10 < this.end && chars[offset + 2] == ':' && chars[offset + 5] == ':') {
                ZoneOffset zoneOffset;
                int start;
                char h0 = chars[offset];
                char h1 = chars[offset + 1];
                char i0 = chars[offset + 3];
                char i1 = chars[offset + 4];
                char s0 = chars[offset + 6];
                char s1 = chars[offset + 7];
                if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
                    throw new JSONException(this.info("illegal offsetTime"));
                }
                int hour = (h0 - 48) * 10 + (h1 - 48);
                if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
                    throw new JSONException(this.info("illegal offsetTime"));
                }
                int minute = (i0 - 48) * 10 + (i1 - 48);
                if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
                    throw new JSONException(this.info("illegal offsetTime"));
                }
                int second = (s0 - 48) * 10 + (s1 - 48);
                int nanoSize = -1;
                int len = 0;
                int end = offset + 25;
                for (int i = start = offset + 8; i < end && i < this.end && i < chars.length; ++i) {
                    char b = chars[i];
                    if (nanoSize == -1 && (b == 'Z' || b == '+' || b == '-')) {
                        nanoSize = i - start - 1;
                    }
                    if (b != quote) continue;
                    len = i - offset;
                    break;
                }
                int nano = nanoSize <= 0 ? 0 : DateUtils.readNanos(chars, nanoSize, offset + 9);
                int zoneOffsetSize = len - 9 - nanoSize;
                if (zoneOffsetSize <= 1) {
                    zoneOffset = ZoneOffset.UTC;
                } else {
                    String zonedId = new String(chars, offset + 9 + nanoSize, zoneOffsetSize);
                    zoneOffset = ZoneOffset.of(zonedId);
                }
                LocalTime localTime = LocalTime.of(hour, minute, second, nano);
                OffsetTime oft = OffsetTime.of(localTime, zoneOffset);
                this.offset += len + 1;
                this.next();
                this.comma = this.ch == ',';
                if (this.comma) {
                    this.next();
                }
                return oft;
            }
        }
        throw new JSONException(this.info("illegal offsetTime"));
    }

    @Override
    protected final ZonedDateTime readZonedDateTimeX(int len) {
        ZonedDateTime zdt;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        if (len < 19) {
            return null;
        }
        char[] chars = this.chars;
        if (len == 30 && chars[this.offset + 29] == 'Z') {
            LocalDateTime ldt = DateUtils.parseLocalDateTime29(chars, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        } else if (len == 29 && chars[this.offset + 28] == 'Z') {
            LocalDateTime ldt = DateUtils.parseLocalDateTime28(chars, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        } else if (len == 28 && chars[this.offset + 27] == 'Z') {
            LocalDateTime ldt = DateUtils.parseLocalDateTime27(chars, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        } else if (len == 27 && chars[this.offset + 26] == 'Z') {
            LocalDateTime ldt = DateUtils.parseLocalDateTime26(chars, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        } else {
            zdt = DateUtils.parseZonedDateTime(chars, this.offset, len, this.context.zoneId);
        }
        if (zdt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return zdt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime19() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime19(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 20;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime20() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime20(this.chars, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 21;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final long readMillis19() {
        char quote = this.ch;
        if (quote != '\"' && quote != '\'') {
            throw new JSONException("date only support string input");
        }
        if (this.offset + 18 >= this.end) {
            this.wasNull = true;
            return 0L;
        }
        long millis = DateUtils.parseMillis19(this.chars, this.offset, this.context.zoneId);
        if (this.chars[this.offset + 19] != quote) {
            throw new JSONException(this.info("illegal date input"));
        }
        this.offset += 20;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return millis;
    }

    @Override
    protected final LocalDateTime readLocalDateTimeX(int len) {
        LocalDateTime ldt;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        if (this.chars[this.offset + len - 1] == 'Z') {
            ZonedDateTime zdt = DateUtils.parseZonedDateTime(this.chars, this.offset, len);
            ldt = zdt.toInstant().atZone(this.context.getZoneId()).toLocalDateTime();
        } else {
            ldt = DateUtils.parseLocalDateTimeX(this.chars, this.offset, len);
        }
        if (ldt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalTime readLocalTime10() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime10(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime11() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime11(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 12;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime12() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime12(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 13;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime18() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime18(this.chars, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 19;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    public final String readPattern() {
        int ch;
        int offset;
        if (this.ch != '/') {
            throw new JSONException("illegal pattern");
        }
        char[] chars = this.chars;
        int start = offset = this.offset;
        while (offset < this.end && chars[offset] != '/') {
            ++offset;
        }
        String str = new String(chars, start, offset - start);
        int n = ch = ++offset == this.end ? 26 : chars[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n2 = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return str;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final boolean readBoolValue() {
        boolean val;
        this.wasNull = false;
        char[] chars = this.chars;
        int offset = this.offset;
        char ch = this.ch;
        if (ch == 't' && offset + 2 < chars.length && chars[offset] == 'r' && chars[offset + 1] == 'u' && chars[offset + 2] == 'e') {
            offset += 3;
            val = true;
        } else if (ch == 'f' && offset + 3 < chars.length && chars[offset] == 'a' && chars[offset + 1] == 'l' && chars[offset + 2] == 's' && chars[offset + 3] == 'e') {
            offset += 4;
            val = false;
        } else {
            if (ch == '-' || ch >= '0' && ch <= '9') {
                this.readNumber();
                if (this.valueType != 1) return false;
                if ((this.context.features & JSONReader.Feature.NonZeroNumberCastToBooleanAsTrue.mask) != 0L) {
                    if (this.mag0 != 0) return true;
                    if (this.mag1 != 0) return true;
                    if (this.mag2 != 0) return true;
                    if (this.mag3 != 0) return true;
                    return false;
                }
                if (this.mag0 != 0) return false;
                if (this.mag1 != 0) return false;
                if (this.mag2 != 0) return false;
                if (this.mag3 != 1) return false;
                return true;
            }
            if (ch == 'n' && offset + 2 < chars.length && chars[offset] == 'u' && chars[offset + 1] == 'l' && chars[offset + 2] == 'l') {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("boolean value not support input null"));
                }
                this.wasNull = true;
                offset += 3;
                val = false;
            } else {
                if (ch != '\"') {
                    if (ch != '[') throw new JSONException("syntax error : " + ch);
                    this.next();
                    boolean val2 = this.readBoolValue();
                    if (this.nextIfMatch(']')) return val2;
                    throw new JSONException("not closed square brackets, expect ] but found : " + ch);
                }
                if (offset + 1 < chars.length && chars[offset + 1] == '\"') {
                    char c0 = chars[offset];
                    offset += 2;
                    if (c0 == '0' || c0 == 'N') {
                        val = false;
                    } else {
                        if (c0 != '1') {
                            if (c0 != 'Y') throw new JSONException("can not convert to boolean : " + c0);
                        }
                        val = true;
                    }
                } else {
                    String str = this.readString();
                    if ("true".equalsIgnoreCase(str)) {
                        return true;
                    }
                    if ("false".equalsIgnoreCase(str)) {
                        return false;
                    }
                    if (!str.isEmpty()) {
                        if (!"null".equalsIgnoreCase(str)) throw new JSONException("can not convert to boolean : " + str);
                    }
                    this.wasNull = true;
                    return false;
                }
            }
        }
        char c = ch = offset == this.end ? (char)'\u001a' : chars[offset++];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (char)'\u001a' : chars[offset++];
        }
        this.comma = ch == ',';
        if (this.comma) {
            char c2 = ch = offset == this.end ? (char)'\u001a' : chars[offset++];
            while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? (char)'\u001a' : chars[offset++];
            }
        }
        this.offset = offset;
        this.ch = ch;
        return val;
    }

    @Override
    public final String info(String message) {
        int line = 1;
        int column = 0;
        int i = 0;
        while (i < this.offset & i < this.end) {
            if (this.chars[i] == '\n') {
                column = 0;
                ++line;
            }
            ++i;
            ++column;
        }
        StringBuilder buf = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            buf.append(message).append(", ");
        }
        buf.append("offset ").append(this.offset).append(", character ").append(this.ch).append(", line ").append(line).append(", column ").append(column).append(", fastjson-version ").append("2.0.52").append(line > 1 ? (char)'\n' : ' ');
        int MAX_OUTPUT_LENGTH = 65535;
        buf.append(this.chars, this.start, Math.min(this.length, 65535));
        return buf.toString();
    }

    @Override
    public final void close() {
        if (this.cacheIndex != -1 && this.chars.length < 0x400000) {
            JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[this.cacheIndex];
            JSONFactory.CHARS_UPDATER.lazySet(cacheItem, this.chars);
        }
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public final int getRawInt() {
        if (this.offset + 3 < this.chars.length) {
            return JSONReaderUTF16.getInt(this.chars, this.offset - 1);
        }
        return 0;
    }

    static int getInt(char[] chars, int offset) {
        long int64Val = JDKUtils.UNSAFE.getLong(chars, JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(offset << 1));
        if ((int64Val & CHAR_MASK) != 0L) {
            return 0;
        }
        if (JDKUtils.BIG_ENDIAN) {
            int64Val >>= 8;
        }
        return (int)(int64Val & 0xFFL | (int64Val & 0xFF0000L) >> 8 | (int64Val & 0xFF00000000L) >> 16 | (int64Val & 0xFF000000000000L) >> 24);
    }

    @Override
    public final long getRawLong() {
        if (this.offset + 7 < this.chars.length) {
            return JSONReaderUTF16.getLong(this.chars, this.offset - 1);
        }
        return 0L;
    }

    static long getLong(char[] chars, int offset) {
        long int64Val1;
        long arrayOffset = JDKUtils.ARRAY_CHAR_BASE_OFFSET + (long)(offset << 1);
        long int64Val0 = JDKUtils.UNSAFE.getLong(chars, arrayOffset);
        if (((int64Val0 | (int64Val1 = JDKUtils.UNSAFE.getLong(chars, arrayOffset + 8L))) & CHAR_MASK) != 0L) {
            return 0L;
        }
        if (JDKUtils.BIG_ENDIAN) {
            int64Val0 >>= 8;
            int64Val1 >>= 8;
        }
        return int64Val0 & 0xFFL | (int64Val0 & 0xFF0000L) >> 8 | (int64Val0 & 0xFF00000000L) >> 16 | (int64Val0 & 0xFF000000000000L) >> 24 | (int64Val1 & 0xFFL) << 32 | (int64Val1 & 0xFF0000L) << 24 | (int64Val1 & 0xFF00000000L) << 16 | (int64Val1 & 0xFF000000000000L) << 8;
    }

    @Override
    public final boolean nextIfName8Match0() {
        char[] chars = this.chars;
        int offset = this.offset;
        if ((offset += 7) == this.end) {
            this.ch = (char)26;
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName8Match1() {
        char[] chars = this.chars;
        int offset = this.offset;
        if ((offset += 8) >= this.end || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName8Match2() {
        char[] chars = this.chars;
        int offset = this.offset;
        if ((offset += 9) >= this.end || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match2() {
        char[] chars = this.chars;
        int offset = this.offset + 4;
        if (offset >= this.end || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match3() {
        char[] chars = this.chars;
        int offset = this.offset + 5;
        if (offset >= this.end || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match4(byte c4) {
        char[] chars = this.chars;
        int offset = this.offset + 6;
        if (offset >= this.end || chars[offset - 3] != c4 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match5(int name1) {
        char[] chars = this.chars;
        int offset = this.offset + 7;
        if (offset >= this.end || JSONReaderUTF16.getInt(chars, offset - 4) != name1) {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match6(int name1) {
        char[] chars = this.chars;
        int offset = this.offset + 8;
        if (offset >= this.end || JSONReaderUTF16.getInt(chars, offset - 5) != name1 || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match7(int name1) {
        char[] chars = this.chars;
        int offset = this.offset + 9;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getInt(chars, offset - 6) != name1 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match8(int name1, byte c8) {
        char[] chars = this.chars;
        int offset = this.offset + 10;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getInt(chars, offset - 7) != name1 || chars[offset - 3] != c8 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match9(long name1) {
        char[] chars = this.chars;
        int offset = this.offset + 11;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 8) != name1) {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match10(long name1) {
        char[] chars = this.chars;
        int offset = this.offset + 12;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 9) != name1 || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match11(long name1) {
        char[] chars = this.chars;
        int offset = this.offset + 13;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 10) != name1 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match12(long name1, byte name2) {
        char[] bytes = this.chars;
        int offset = this.offset + 14;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(bytes, offset - 11) != name1 || bytes[offset - 3] != name2 || bytes[offset - 2] != '\"' || bytes[offset - 1] != ':') {
            return false;
        }
        char c = bytes[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = bytes[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match13(long name1, int name2) {
        char[] chars = this.chars;
        int offset = this.offset + 15;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 12) != name1 || JSONReaderUTF16.getInt(chars, offset - 4) != name2) {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match14(long name1, int name2) {
        char[] chars = this.chars;
        int offset = this.offset + 16;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 13) != name1 || JSONReaderUTF16.getInt(chars, offset - 5) != name2 || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match15(long name1, int name2) {
        char[] chars = this.chars;
        int offset = this.offset + 17;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 14) != name1 || JSONReaderUTF16.getInt(chars, offset - 6) != name2 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match16(long name1, int name2, byte name3) {
        char[] chars = this.chars;
        int offset = this.offset + 18;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 15) != name1 || JSONReaderUTF16.getInt(chars, offset - 7) != name2 || chars[offset - 3] != name3 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match17(long name1, long name2) {
        char[] chars = this.chars;
        int offset = this.offset + 19;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 16) != name1 || JSONReaderUTF16.getLong(chars, offset - 8) != name2) {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match18(long name1, long name2) {
        char[] chars = this.chars;
        int offset = this.offset + 20;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 17) != name1 || JSONReaderUTF16.getLong(chars, offset - 9) != name2 || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match19(long name1, long name2) {
        char[] chars = this.chars;
        int offset = this.offset + 21;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 18) != name1 || JSONReaderUTF16.getLong(chars, offset - 10) != name2 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match20(long name1, long name2, byte name3) {
        char[] chars = this.chars;
        int offset = this.offset + 22;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 19) != name1 || JSONReaderUTF16.getLong(chars, offset - 11) != name2 || chars[offset - 3] != name3 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match21(long name1, long name2, int name3) {
        char[] chars = this.chars;
        int offset = this.offset + 23;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 20) != name1 || JSONReaderUTF16.getLong(chars, offset - 12) != name2 || JSONReaderUTF16.getInt(chars, offset - 4) != name3) {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match22(long name1, long name2, int name3) {
        char[] chars = this.chars;
        int offset = this.offset + 24;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 21) != name1 || JSONReaderUTF16.getLong(chars, offset - 13) != name2 || JSONReaderUTF16.getInt(chars, offset - 5) != name3 || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match23(long name1, long name2, int name3) {
        char[] chars = this.chars;
        int offset = this.offset + 25;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 22) != name1 || JSONReaderUTF16.getLong(chars, offset - 14) != name2 || JSONReaderUTF16.getInt(chars, offset - 6) != name3 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match24(long name1, long name2, int name3, byte name4) {
        char[] chars = this.chars;
        int offset = this.offset + 26;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 23) != name1 || JSONReaderUTF16.getLong(chars, offset - 15) != name2 || JSONReaderUTF16.getInt(chars, offset - 7) != name3 || chars[offset - 3] != name4 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match25(long name1, long name2, long name3) {
        char[] chars = this.chars;
        int offset = this.offset + 27;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 24) != name1 || JSONReaderUTF16.getLong(chars, offset - 16) != name2 || JSONReaderUTF16.getLong(chars, offset - 8) != name3) {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match26(long name1, long name2, long name3) {
        char[] bytes = this.chars;
        int offset = this.offset + 28;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(bytes, offset - 25) != name1 || JSONReaderUTF16.getLong(bytes, offset - 17) != name2 || JSONReaderUTF16.getLong(bytes, offset - 9) != name3 || bytes[offset - 1] != ':') {
            return false;
        }
        char c = this.chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = this.chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match27(long name1, long name2, long name3) {
        char[] bytes = this.chars;
        int offset = this.offset + 29;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(bytes, offset - 26) != name1 || JSONReaderUTF16.getLong(bytes, offset - 18) != name2 || JSONReaderUTF16.getLong(bytes, offset - 10) != name3 || bytes[offset - 2] != '\"' || bytes[offset - 1] != ':') {
            return false;
        }
        char c = this.chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = this.chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match28(long name1, long name2, long name3, byte c29) {
        char[] chars = this.chars;
        int offset = this.offset + 30;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 27) != name1 || JSONReaderUTF16.getLong(chars, offset - 19) != name2 || JSONReaderUTF16.getLong(chars, offset - 11) != name3 || chars[offset - 3] != c29 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match29(long name1, long name2, long name3, int name4) {
        char[] chars = this.chars;
        int offset = this.offset + 31;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 28) != name1 || JSONReaderUTF16.getLong(chars, offset - 20) != name2 || JSONReaderUTF16.getLong(chars, offset - 12) != name3 || JSONReaderUTF16.getInt(chars, offset - 4) != name4) {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match30(long name1, long name2, long name3, int name4) {
        char[] chars = this.chars;
        int offset = this.offset + 32;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 29) != name1 || JSONReaderUTF16.getLong(chars, offset - 21) != name2 || JSONReaderUTF16.getLong(chars, offset - 13) != name3 || JSONReaderUTF16.getInt(chars, offset - 5) != name4 || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match31(long name1, long name2, long name3, int name4) {
        char[] chars = this.chars;
        int offset = this.offset + 33;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 30) != name1 || JSONReaderUTF16.getLong(chars, offset - 22) != name2 || JSONReaderUTF16.getLong(chars, offset - 14) != name3 || JSONReaderUTF16.getInt(chars, offset - 6) != name4 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match32(long name1, long name2, long name3, int name4, byte c32) {
        char[] chars = this.chars;
        int offset = this.offset + 34;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 31) != name1 || JSONReaderUTF16.getLong(chars, offset - 23) != name2 || JSONReaderUTF16.getLong(chars, offset - 15) != name3 || JSONReaderUTF16.getInt(chars, offset - 7) != name4 || chars[offset - 3] != c32 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match33(long name1, long name2, long name3, long name4) {
        char[] chars = this.chars;
        int offset = this.offset + 35;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 32) != name1 || JSONReaderUTF16.getLong(chars, offset - 24) != name2 || JSONReaderUTF16.getLong(chars, offset - 16) != name3 || JSONReaderUTF16.getLong(chars, offset - 8) != name4) {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match34(long name1, long name2, long name3, long name4) {
        char[] chars = this.chars;
        int offset = this.offset + 36;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 33) != name1 || JSONReaderUTF16.getLong(chars, offset - 25) != name2 || JSONReaderUTF16.getLong(chars, offset - 17) != name3 || JSONReaderUTF16.getLong(chars, offset - 9) != name4 || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match35(long name1, long name2, long name3, long name4) {
        char[] chars = this.chars;
        int offset = this.offset + 37;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 34) != name1 || JSONReaderUTF16.getLong(chars, offset - 26) != name2 || JSONReaderUTF16.getLong(chars, offset - 18) != name3 || JSONReaderUTF16.getLong(chars, offset - 10) != name4 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match36(long name1, long name2, long name3, long name4, byte c36) {
        char[] chars = this.chars;
        int offset = this.offset + 38;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 35) != name1 || JSONReaderUTF16.getLong(chars, offset - 27) != name2 || JSONReaderUTF16.getLong(chars, offset - 19) != name3 || JSONReaderUTF16.getLong(chars, offset - 11) != name4 || chars[offset - 3] != c36 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match37(long name1, long name2, long name3, long name4, int name5) {
        char[] chars = this.chars;
        int offset = this.offset + 39;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 36) != name1 || JSONReaderUTF16.getLong(chars, offset - 28) != name2 || JSONReaderUTF16.getLong(chars, offset - 20) != name3 || JSONReaderUTF16.getLong(chars, offset - 12) != name4 || JSONReaderUTF16.getInt(chars, offset - 4) != name5) {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match38(long name1, long name2, long name3, long name4, int name5) {
        char[] chars = this.chars;
        int offset = this.offset + 40;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 37) != name1 || JSONReaderUTF16.getLong(chars, offset - 29) != name2 || JSONReaderUTF16.getLong(chars, offset - 21) != name3 || JSONReaderUTF16.getLong(chars, offset - 13) != name4 || JSONReaderUTF16.getInt(chars, offset - 5) != name5 || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match39(long name1, long name2, long name3, long name4, int name5) {
        char[] chars = this.chars;
        int offset = this.offset + 41;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 38) != name1 || JSONReaderUTF16.getLong(chars, offset - 30) != name2 || JSONReaderUTF16.getLong(chars, offset - 22) != name3 || JSONReaderUTF16.getLong(chars, offset - 14) != name4 || JSONReaderUTF16.getInt(chars, offset - 6) != name5 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match40(long name1, long name2, long name3, long name4, int name5, byte c40) {
        char[] chars = this.chars;
        int offset = this.offset + 42;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 39) != name1 || JSONReaderUTF16.getLong(chars, offset - 31) != name2 || JSONReaderUTF16.getLong(chars, offset - 23) != name3 || JSONReaderUTF16.getLong(chars, offset - 15) != name4 || JSONReaderUTF16.getInt(chars, offset - 7) != name5 || chars[offset - 3] != c40 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match41(long name1, long name2, long name3, long name4, long name5) {
        char[] chars = this.chars;
        int offset = this.offset + 43;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 40) != name1 || JSONReaderUTF16.getLong(chars, offset - 32) != name2 || JSONReaderUTF16.getLong(chars, offset - 24) != name3 || JSONReaderUTF16.getLong(chars, offset - 16) != name4 || JSONReaderUTF16.getLong(chars, offset - 8) != name5) {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match42(long name1, long name2, long name3, long name4, long name5) {
        char[] chars = this.chars;
        int offset = this.offset + 44;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 41) != name1 || JSONReaderUTF16.getLong(chars, offset - 33) != name2 || JSONReaderUTF16.getLong(chars, offset - 25) != name3 || JSONReaderUTF16.getLong(chars, offset - 17) != name4 || JSONReaderUTF16.getLong(chars, offset - 9) != name5 || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match43(long name1, long name2, long name3, long name4, long name5) {
        char[] chars = this.chars;
        int offset = this.offset + 45;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 42) != name1 || JSONReaderUTF16.getLong(chars, offset - 34) != name2 || JSONReaderUTF16.getLong(chars, offset - 26) != name3 || JSONReaderUTF16.getLong(chars, offset - 18) != name4 || JSONReaderUTF16.getLong(chars, offset - 10) != name5 || chars[offset - 2] != '\"' || chars[offset - 1] != ':') {
            return false;
        }
        char c = chars[offset++];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = chars[offset++];
        }
        this.offset = offset;
        this.ch = c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match2() {
        char[] chars = this.chars;
        int offset = this.offset + 3;
        if (offset >= this.end) {
            return false;
        }
        int c = chars[offset];
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : chars[offset];
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match3() {
        char[] chars = this.chars;
        int offset = this.offset + 4;
        if (offset >= this.end) {
            return false;
        }
        if (chars[offset - 1] != '\"') {
            return false;
        }
        int c = chars[offset];
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : chars[offset];
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match4(byte c4) {
        char[] chars = this.chars;
        int offset = this.offset + 5;
        if (offset >= this.end) {
            return false;
        }
        if (chars[offset - 2] != c4 || chars[offset - 1] != '\"') {
            return false;
        }
        int c = chars[offset];
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : chars[offset];
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match5(byte c4, byte c5) {
        char[] chars = this.chars;
        int offset = this.offset + 6;
        if (offset >= this.end) {
            return false;
        }
        if (chars[offset - 3] != c4 || chars[offset - 2] != c5 || chars[offset - 1] != '\"') {
            return false;
        }
        int c = chars[offset];
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : chars[offset];
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match6(int name1) {
        char[] chars = this.chars;
        int offset = this.offset + 7;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getInt(chars, offset - 4) != name1) {
            return false;
        }
        int c = chars[offset];
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : chars[offset];
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match7(int name1) {
        char[] chars = this.chars;
        int offset = this.offset + 8;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getInt(chars, offset - 5) != name1 || chars[offset - 1] != '\"') {
            return false;
        }
        int c = chars[offset];
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : chars[offset];
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match8(int name1, byte c8) {
        char[] chars = this.chars;
        int offset = this.offset + 9;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getInt(chars, offset - 6) != name1 || chars[offset - 2] != c8 || chars[offset - 1] != '\"') {
            return false;
        }
        int c = chars[offset];
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : chars[offset];
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match9(int name1, byte c8, byte c9) {
        char[] chars = this.chars;
        int offset = this.offset + 10;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getInt(chars, offset - 7) != name1 || chars[offset - 3] != c8 || chars[offset - 2] != c9 || chars[offset - 1] != '\"') {
            return false;
        }
        int c = chars[offset];
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : chars[offset];
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match10(long name1) {
        char[] chars = this.chars;
        int offset = this.offset + 11;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 8) != name1) {
            return false;
        }
        int c = chars[offset];
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : chars[offset];
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match11(long name1) {
        char[] chars = this.chars;
        int offset = this.offset + 12;
        if (offset >= this.end) {
            return false;
        }
        if (JSONReaderUTF16.getLong(chars, offset - 9) != name1 || chars[offset - 1] != '\"') {
            return false;
        }
        int c = chars[offset];
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : chars[offset];
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = chars[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }
}

