/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.server.app.configuration;

import com.alibaba.arthas.tunnel.server.TunnelServer;
import com.alibaba.arthas.tunnel.server.app.configuration.ArthasProperties;
import com.alibaba.arthas.tunnel.server.cluster.TunnelClusterStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class TunnelServerConfiguration {
    @Autowired
    ArthasProperties arthasProperties;

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean
    public TunnelServer tunnelServer(@Autowired(required=false) TunnelClusterStore tunnelClusterStore) {
        TunnelServer tunnelServer = new TunnelServer();
        tunnelServer.setHost(this.arthasProperties.getServer().getHost());
        tunnelServer.setPort(this.arthasProperties.getServer().getPort());
        tunnelServer.setSsl(this.arthasProperties.getServer().isSsl());
        tunnelServer.setPath(this.arthasProperties.getServer().getPath());
        tunnelServer.setClientConnectHost(this.arthasProperties.getServer().getClientConnectHost());
        if (tunnelClusterStore != null) {
            tunnelServer.setTunnelClusterStore(tunnelClusterStore);
        }
        return tunnelServer;
    }
}

