/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.server.app.web;

import com.alibaba.arthas.tunnel.server.AgentClusterInfo;
import com.alibaba.arthas.tunnel.server.app.configuration.ArthasProperties;
import com.alibaba.arthas.tunnel.server.cluster.TunnelClusterStore;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DetailAPIController {
    private static final Logger logger = LoggerFactory.getLogger(DetailAPIController.class);
    @Autowired
    ArthasProperties arthasProperties;
    @Autowired(required=false)
    private TunnelClusterStore tunnelClusterStore;

    @RequestMapping(value={"/api/tunnelApps"})
    @ResponseBody
    public Set<String> tunnelApps(HttpServletRequest request, Model model) {
        if (!this.arthasProperties.isEnableDetailPages()) {
            throw new IllegalAccessError("not allow");
        }
        HashSet<String> result = new HashSet<String>();
        if (this.tunnelClusterStore != null) {
            Collection<String> agentIds = this.tunnelClusterStore.allAgentIds();
            for (String id : agentIds) {
                String appName = DetailAPIController.findAppNameFromAgentId(id);
                if (appName != null) {
                    result.add(appName);
                    continue;
                }
                logger.warn("illegal agentId: " + id);
            }
        }
        return result;
    }

    @RequestMapping(value={"/api/tunnelAgentInfo"})
    @ResponseBody
    public Map<String, AgentClusterInfo> tunnelAgentIds(@RequestParam(value="app", required=true) String appName, HttpServletRequest request, Model model) {
        if (!this.arthasProperties.isEnableDetailPages()) {
            throw new IllegalAccessError("not allow");
        }
        if (this.tunnelClusterStore != null) {
            Map<String, AgentClusterInfo> agentInfos = this.tunnelClusterStore.agentInfo(appName);
            return agentInfos;
        }
        return Collections.emptyMap();
    }

    @RequestMapping(value={"/api/tunnelAgents"})
    @ResponseBody
    public Map<String, Object> tunnelAgentIds(@RequestParam(value="agentId", required=true) String agentId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean success = false;
        try {
            AgentClusterInfo info = this.tunnelClusterStore.findAgent(agentId);
            if (info != null) {
                success = true;
            }
        }
        catch (Throwable e) {
            logger.error("try to find agentId error, id: {}", (Object)agentId, (Object)e);
        }
        result.put("success", success);
        return result;
    }

    private static String findAppNameFromAgentId(String id) {
        int index = id.indexOf(95);
        if (index < 0 || index >= id.length()) {
            return null;
        }
        return id.substring(0, index);
    }
}

