/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.server;

import com.alibaba.arthas.tunnel.server.AgentInfo;
import com.alibaba.arthas.tunnel.server.ClientConnectionInfo;
import com.alibaba.arthas.tunnel.server.TunnelSocketServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelServer {
    private static final Logger logger = LoggerFactory.getLogger(TunnelServer.class);
    private boolean ssl;
    private String host;
    private int port;
    private Map<String, AgentInfo> agentInfoMap = new ConcurrentHashMap();
    private Map<String, ClientConnectionInfo> clientConnectionInfoMap = new ConcurrentHashMap();
    private EventLoopGroup bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("arthas-TunnelServer-boss", true));
    private EventLoopGroup workerGroup = new NioEventLoopGroup((ThreadFactory)new DefaultThreadFactory("arthas-TunnelServer-worker", true));
    private Channel channel;

    public void start() throws Exception {
        SslContext sslCtx;
        if (this.ssl) {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
        } else {
            sslCtx = null;
        }
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new TunnelSocketServerInitializer(this, sslCtx));
        this.channel = StringUtils.isBlank((CharSequence)this.host) ? b.bind(this.port).sync().channel() : b.bind(this.host, this.port).sync().channel();
        logger.info("Tunnel server listen at {}:{}", (Object)this.host, (Object)this.port);
        this.workerGroup.scheduleWithFixedDelay((Runnable)new /* Unavailable Anonymous Inner Class!! */, 60L, 60L, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.close();
        }
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    public Optional<AgentInfo> findAgent(String id) {
        return Optional.ofNullable(this.agentInfoMap.get(id));
    }

    public void addAgent(String id, AgentInfo agentInfo) {
        this.agentInfoMap.put(id, agentInfo);
    }

    public AgentInfo removeAgent(String id) {
        return (AgentInfo)this.agentInfoMap.remove(id);
    }

    public Optional<ClientConnectionInfo> findClientConnection(String id) {
        return Optional.ofNullable(this.clientConnectionInfoMap.get(id));
    }

    public void addClientConnectionInfo(String id, ClientConnectionInfo clientConnectionInfo) {
        this.clientConnectionInfoMap.put(id, clientConnectionInfo);
    }

    public ClientConnectionInfo removeClientConnectionInfo(String id) {
        return (ClientConnectionInfo)this.clientConnectionInfoMap.remove(id);
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Map<String, AgentInfo> getAgentInfoMap() {
        return this.agentInfoMap;
    }

    public void setAgentInfoMap(Map<String, AgentInfo> agentInfoMap) {
        this.agentInfoMap = agentInfoMap;
    }

    public Map<String, ClientConnectionInfo> getClientConnectionInfoMap() {
        return this.clientConnectionInfoMap;
    }

    public void setClientConnectionInfoMap(Map<String, ClientConnectionInfo> clientConnectionInfoMap) {
        this.clientConnectionInfoMap = clientConnectionInfoMap;
    }

    static /* synthetic */ Map access$000(TunnelServer x0) {
        return x0.agentInfoMap;
    }

    static /* synthetic */ Map access$100(TunnelServer x0) {
        return x0.clientConnectionInfoMap;
    }
}

