/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.server;

import com.alibaba.arthas.tunnel.server.AgentInfo;
import com.alibaba.arthas.tunnel.server.ClientConnectionInfo;
import com.alibaba.arthas.tunnel.server.TunnelServer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class TunnelSocketFrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(TunnelSocketFrameHandler.class);
    private TunnelServer tunnelServer;

    public TunnelSocketFrameHandler(TunnelServer tunnelServer) {
        this.tunnelServer = tunnelServer;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
            WebSocketServerProtocolHandler.HandshakeComplete handshake = (WebSocketServerProtocolHandler.HandshakeComplete)evt;
            String uri = handshake.requestUri();
            logger.info("websocket handshake complete, uri: {}", (Object)uri);
            MultiValueMap parameters = UriComponentsBuilder.fromUriString((String)uri).build().getQueryParams();
            String method = (String)parameters.getFirst((Object)"method");
            if ("connectArthas".equals(method)) {
                this.connectArthas(ctx, parameters);
            } else if ("agentRegister".equals(method)) {
                this.agentRegister(ctx, uri);
            }
            if ("openTunnel".equals(method)) {
                String clientConnectionId = (String)parameters.getFirst((Object)"clientConnectionId");
                this.openTunnel(ctx, clientConnectionId);
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
    }

    private void connectArthas(ChannelHandlerContext tunnelSocketCtx, MultiValueMap<String, String> parameters) throws URISyntaxException {
        List agentId = (List)parameters.getOrDefault((Object)"id", Collections.emptyList());
        if (agentId.isEmpty()) {
            logger.error("arthas agent id can not be null, parameters: ", parameters);
            throw new IllegalArgumentException("arthas agent id can not be null");
        }
        logger.info("try to connect to arthas agent, id: " + (String)agentId.get(0));
        Optional findAgent = this.tunnelServer.findAgent((String)agentId.get(0));
        if (findAgent.isPresent()) {
            ChannelHandlerContext agentCtx = ((AgentInfo)findAgent.get()).getChannelHandlerContext();
            String clientConnectionId = RandomStringUtils.random((int)20, (boolean)true, (boolean)true).toUpperCase();
            logger.info("random clientConnectionId: " + clientConnectionId);
            URI uri = new URI("response", null, "/", "method=startTunnel&id=" + (String)agentId.get(0) + "&clientConnectionId=" + clientConnectionId, null);
            logger.info("startTunnel response: " + uri);
            ClientConnectionInfo clientConnectionInfo = new ClientConnectionInfo();
            SocketAddress remoteAddress = tunnelSocketCtx.channel().remoteAddress();
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                clientConnectionInfo.setHost(inetSocketAddress.getHostString());
                clientConnectionInfo.setPort(inetSocketAddress.getPort());
            }
            clientConnectionInfo.setChannelHandlerContext(tunnelSocketCtx);
            Promise promise = GlobalEventExecutor.INSTANCE.newPromise();
            promise.addListener((GenericFutureListener)new /* Unavailable Anonymous Inner Class!! */);
            clientConnectionInfo.setPromise(promise);
            this.tunnelServer.addClientConnectionInfo(clientConnectionId, clientConnectionInfo);
            tunnelSocketCtx.channel().closeFuture().addListener((GenericFutureListener)new /* Unavailable Anonymous Inner Class!! */);
            agentCtx.channel().writeAndFlush((Object)new TextWebSocketFrame(uri.toString()));
            logger.info("browser connect waitting for arthas agent open tunnel");
            boolean watiResult = promise.awaitUninterruptibly(20L, TimeUnit.SECONDS);
            if (watiResult) {
                logger.info("browser connect wait for arthas agent open tunnel success, agentId: {}, clientConnectionId: {}", (Object)agentId, (Object)clientConnectionId);
            } else {
                logger.error("browser connect wait for arthas agent open tunnel timeout, agentId: {}, clientConnectionId: {}", (Object)agentId, (Object)clientConnectionId);
                tunnelSocketCtx.close();
            }
        } else {
            tunnelSocketCtx.channel().writeAndFlush((Object)new CloseWebSocketFrame(2000, "Can not find arthas agent by id: " + agentId));
            logger.error("Can not find arthas agent by id: {}", (Object)agentId);
            throw new IllegalArgumentException("Can not find arthas agent by id: " + agentId);
        }
    }

    private void agentRegister(ChannelHandlerContext ctx, String requestUri) throws URISyntaxException {
        String id = RandomStringUtils.random((int)20, (boolean)true, (boolean)true).toUpperCase();
        QueryStringDecoder queryDecoder = new QueryStringDecoder(requestUri);
        List idList = (List)queryDecoder.parameters().get("id");
        if (idList != null && !idList.isEmpty()) {
            id = (String)idList.get(0);
        }
        String finalId = id;
        URI responseUri = new URI("response", null, "/", "method=agentRegister&id=" + id, null);
        AgentInfo info = new AgentInfo();
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
            info.setHost(inetSocketAddress.getHostString());
            info.setPort(inetSocketAddress.getPort());
        }
        info.setChannelHandlerContext(ctx);
        this.tunnelServer.addAgent(id, info);
        ctx.channel().closeFuture().addListener((GenericFutureListener)new /* Unavailable Anonymous Inner Class!! */);
        ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(responseUri.toString()));
    }

    private void openTunnel(ChannelHandlerContext ctx, String clientConnectionId) {
        Optional infoOptional = this.tunnelServer.findClientConnection(clientConnectionId);
        if (infoOptional.isPresent()) {
            ClientConnectionInfo info = (ClientConnectionInfo)infoOptional.get();
            logger.info("openTunnel clientConnectionId:" + clientConnectionId);
            Promise promise = info.getPromise();
            promise.setSuccess((Object)ctx.channel());
        } else {
            logger.error("Can not find client connection by id: {}", (Object)clientConnectionId);
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ TunnelServer access$100(TunnelSocketFrameHandler x0) {
        return x0.tunnelServer;
    }
}

