/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.taobao.arthas.mcp.server.util.Assert;
import com.taobao.arthas.mcp.server.util.Utils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonParser {
    private static final Logger logger = LoggerFactory.getLogger(JsonParser.class);
    private static final ObjectMapper OBJECT_MAPPER = JsonParser.createObjectMapper();
    private static final List<ValueFilter> JSON_FILTERS = new CopyOnWriteArrayList<ValueFilter>();

    public static void registerFilter(ValueFilter filter) {
        if (filter != null) {
            JSON_FILTERS.add(filter);
        }
    }

    public static void clearFilters() {
        JSON_FILTERS.clear();
    }

    private static ObjectMapper createObjectMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).addModule((Module)new JavaTimeModule())).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build();
    }

    private JsonParser() {
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    public static <T> T fromJson(String json, Class<T> type) {
        Assert.notNull(json, "json cannot be null");
        Assert.notNull(type, "type cannot be null");
        try {
            return (T)JSON.parseObject((String)json, type);
        }
        catch (Exception ex) {
            try {
                return (T)OBJECT_MAPPER.readValue(json, type);
            }
            catch (JsonProcessingException jacksonEx) {
                throw new IllegalStateException("Conversion from JSON to " + type.getName() + " failed", ex);
            }
        }
    }

    public static <T> T fromJson(String json, Type type) {
        Assert.notNull(json, "json cannot be null");
        Assert.notNull(type, "type cannot be null");
        try {
            return (T)JSON.parseObject((String)json, (Type)type);
        }
        catch (Exception ex) {
            try {
                return (T)OBJECT_MAPPER.readValue(json, OBJECT_MAPPER.constructType(type));
            }
            catch (JsonProcessingException jacksonEx) {
                throw new IllegalStateException("Conversion from JSON to " + type.getTypeName() + " failed", ex);
            }
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> type) {
        Assert.notNull(json, "json cannot be null");
        Assert.notNull(type, "type cannot be null");
        try {
            return (T)OBJECT_MAPPER.readValue(json, type);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException("Conversion from JSON to " + type.getType().getTypeName() + " failed", ex);
        }
    }

    public static String toJson(Object object) {
        if (object == null) {
            return "null";
        }
        try {
            String result = JSON_FILTERS.isEmpty() ? JSON.toJSONString((Object)object) : JSON.toJSONString((Object)object, (Filter[])((Filter[])JSON_FILTERS.toArray(new ValueFilter[0])), (JSONWriter.Feature[])new JSONWriter.Feature[0]);
            return result != null ? result : "{}";
        }
        catch (Exception ex) {
            logger.warn("FastJSON2 with MCP filter serialization failed for {}, falling back to Jackson: {}", (Object)object.getClass().getSimpleName(), (Object)ex.getMessage());
            try {
                String result = OBJECT_MAPPER.writeValueAsString(object);
                return result != null ? result : "{}";
            }
            catch (JsonProcessingException jacksonEx) {
                logger.error("Both FastJSON2 and Jackson serialization failed", (Throwable)ex);
                return "{\"error\":\"Serialization failed\"}";
            }
        }
    }

    public static Object toTypedObject(Object value, Class<?> type) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        Class<?> javaType = JsonParser.resolvePrimitiveIfNecessary(type);
        if (javaType == String.class) {
            return value.toString();
        }
        if (javaType == Byte.class) {
            return Byte.parseByte(value.toString());
        }
        if (javaType == Integer.class) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return bigDecimal.intValueExact();
        }
        if (javaType == Short.class) {
            return Short.parseShort(value.toString());
        }
        if (javaType == Long.class) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return bigDecimal.longValueExact();
        }
        if (javaType == Double.class) {
            return Double.parseDouble(value.toString());
        }
        if (javaType == Float.class) {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (javaType == Boolean.class) {
            return Boolean.parseBoolean(value.toString());
        }
        if (javaType == Character.class) {
            String s = value.toString();
            if (s.length() == 1) {
                return Character.valueOf(s.charAt(0));
            }
            throw new IllegalArgumentException("Cannot convert to char: " + value);
        }
        if (javaType.isEnum()) {
            Class<?> enumType = javaType;
            return Enum.valueOf(enumType, value.toString());
        }
        String json = JsonParser.toJson(value);
        return JsonParser.fromJson(json, javaType);
    }

    public static Class<?> resolvePrimitiveIfNecessary(Class<?> type) {
        if (type.isPrimitive()) {
            return Utils.getWrapperClassForPrimitive(type);
        }
        return type;
    }
}

