/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.protocol.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class McpServerProperties {
    private final String name;
    private final String version;
    private final String instructions;
    private final boolean toolChangeNotification;
    private final boolean resourceChangeNotification;
    private final boolean promptChangeNotification;
    private final boolean resourceSubscribe;
    private final String mcpEndpoint;
    private final Duration requestTimeout;
    private final Duration initializationTimeout;
    private final ObjectMapper objectMapper;
    private final ServerProtocol protocol;
    private Map<String, String> toolResponseMimeType = new HashMap<String, String>();

    private McpServerProperties(Builder builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.instructions = builder.instructions;
        this.toolChangeNotification = builder.toolChangeNotification;
        this.resourceChangeNotification = builder.resourceChangeNotification;
        this.promptChangeNotification = builder.promptChangeNotification;
        this.resourceSubscribe = builder.resourceSubscribe;
        this.mcpEndpoint = builder.mcpEndpoint;
        this.requestTimeout = builder.requestTimeout;
        this.initializationTimeout = builder.initializationTimeout;
        this.objectMapper = builder.objectMapper;
        this.protocol = builder.protocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public boolean isToolChangeNotification() {
        return this.toolChangeNotification;
    }

    public boolean isResourceChangeNotification() {
        return this.resourceChangeNotification;
    }

    public boolean isPromptChangeNotification() {
        return this.promptChangeNotification;
    }

    public boolean isResourceSubscribe() {
        return this.resourceSubscribe;
    }

    public String getMcpEndpoint() {
        return this.mcpEndpoint;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public Duration getInitializationTimeout() {
        return this.initializationTimeout;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public ServerProtocol getProtocol() {
        return this.protocol;
    }

    public Map<String, String> getToolResponseMimeType() {
        return this.toolResponseMimeType;
    }

    public void setToolResponseMimeType(Map<String, String> toolResponseMimeType) {
        this.toolResponseMimeType = toolResponseMimeType;
    }

    public static class Builder {
        private String name = "mcp-server";
        private String version = "1.0.0";
        private String instructions;
        private boolean toolChangeNotification = true;
        private boolean resourceChangeNotification = false;
        private boolean promptChangeNotification = false;
        private boolean resourceSubscribe = false;
        private String bindAddress = "localhost";
        private int port = 8080;
        private String mcpEndpoint = "/mcp";
        private Duration requestTimeout = Duration.ofSeconds(10L);
        private Duration initializationTimeout = Duration.ofSeconds(30L);
        private ObjectMapper objectMapper;
        private ServerProtocol protocol = ServerProtocol.STREAMABLE;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public Builder toolChangeNotification(boolean toolChangeNotification) {
            this.toolChangeNotification = toolChangeNotification;
            return this;
        }

        public Builder resourceChangeNotification(boolean resourceChangeNotification) {
            this.resourceChangeNotification = resourceChangeNotification;
            return this;
        }

        public Builder promptChangeNotification(boolean promptChangeNotification) {
            this.promptChangeNotification = promptChangeNotification;
            return this;
        }

        public Builder resourceSubscribe(boolean resourceSubscribe) {
            this.resourceSubscribe = resourceSubscribe;
            return this;
        }

        public Builder mcpEndpoint(String mcpEndpoint) {
            this.mcpEndpoint = mcpEndpoint;
            return this;
        }

        public Builder requestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder initializationTimeout(Duration initializationTimeout) {
            this.initializationTimeout = initializationTimeout;
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder protocol(ServerProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public McpServerProperties build() {
            return new McpServerProperties(this);
        }
    }

    public static enum ServerProtocol {
        STREAMABLE,
        STATELESS;

    }
}

