/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.protocol.server.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.taobao.arthas.mcp.server.protocol.server.DefaultMcpTransportContext;
import com.taobao.arthas.mcp.server.protocol.server.McpStatelessServerHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpTransportContext;
import com.taobao.arthas.mcp.server.protocol.server.McpTransportContextExtractor;
import com.taobao.arthas.mcp.server.protocol.spec.McpError;
import com.taobao.arthas.mcp.server.protocol.spec.McpSchema;
import com.taobao.arthas.mcp.server.util.Assert;
import com.taobao.arthas.mcp.server.util.McpAuthExtractor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpStatelessHttpRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(McpStatelessHttpRequestHandler.class);
    public static final String UTF_8 = "UTF-8";
    public static final String APPLICATION_JSON = "application/json";
    public static final String TEXT_EVENT_STREAM = "text/event-stream";
    public static final String ACCEPT = "Accept";
    private static final String FAILED_TO_SEND_ERROR_RESPONSE = "Failed to send error response: {}";
    private final ObjectMapper objectMapper;
    private final String mcpEndpoint;
    private McpStatelessServerHandler mcpHandler;
    private final McpTransportContextExtractor<FullHttpRequest> contextExtractor;
    private final AtomicBoolean isClosing = new AtomicBoolean(false);

    public McpStatelessHttpRequestHandler(ObjectMapper objectMapper, String mcpEndpoint, McpTransportContextExtractor<FullHttpRequest> contextExtractor) {
        Assert.notNull(objectMapper, "objectMapper must not be null");
        Assert.notNull(mcpEndpoint, "mcpEndpoint must not be null");
        Assert.notNull(contextExtractor, "contextExtractor must not be null");
        this.objectMapper = objectMapper;
        this.mcpEndpoint = mcpEndpoint;
        this.contextExtractor = contextExtractor;
    }

    public void setMcpHandler(McpStatelessServerHandler mcpHandler) {
        this.mcpHandler = mcpHandler;
    }

    public CompletableFuture<Void> closeGracefully() {
        return CompletableFuture.supplyAsync(() -> {
            this.isClosing.set(true);
            return null;
        });
    }

    protected void handle(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        String uri = request.uri();
        if (!uri.endsWith(this.mcpEndpoint)) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND, new McpError((Object)"Endpoint not found"));
            return;
        }
        if (this.isClosing.get()) {
            this.sendError(ctx, HttpResponseStatus.SERVICE_UNAVAILABLE, new McpError((Object)"Server is shutting down"));
            return;
        }
        HttpMethod method = request.method();
        if (method == HttpMethod.GET) {
            this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED, new McpError((Object)"GET method not allowed for stateless transport"));
        } else if (method == HttpMethod.POST) {
            this.handlePostRequest(ctx, request);
        } else {
            this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED, new McpError((Object)"Only POST method is supported"));
        }
    }

    private void handlePostRequest(ChannelHandlerContext ctx, FullHttpRequest request) {
        McpTransportContext transportContext = this.contextExtractor.extract(request, new DefaultMcpTransportContext());
        Object authSubject = McpAuthExtractor.extractAuthSubjectFromContext(ctx);
        transportContext.put("mcp.auth.subject", authSubject);
        String accept = request.headers().get(ACCEPT);
        if (accept == null || !accept.contains(APPLICATION_JSON) || !accept.contains(TEXT_EVENT_STREAM)) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST, new McpError((Object)"Both application/json and text/event-stream required in Accept header"));
            return;
        }
        try {
            ByteBuf content = request.content();
            String body = content.toString(CharsetUtil.UTF_8);
            McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage(this.objectMapper, body);
            if (message instanceof McpSchema.JSONRPCRequest) {
                McpSchema.JSONRPCRequest jsonrpcRequest = (McpSchema.JSONRPCRequest)message;
                try {
                    ((CompletableFuture)this.mcpHandler.handleRequest(transportContext, jsonrpcRequest).thenAccept(jsonrpcResponse -> {
                        try {
                            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)this.objectMapper.writeValueAsString(jsonrpcResponse), (Charset)CharsetUtil.UTF_8));
                            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)APPLICATION_JSON);
                            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
                            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
                            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        }
                        catch (Exception e) {
                            logger.error("Failed to serialize response: {}", (Object)e.getMessage());
                            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, new McpError((Object)("Failed to serialize response: " + e.getMessage())));
                        }
                    })).exceptionally(e -> {
                        logger.error("Failed to handle request: {}", (Object)e.getMessage());
                        this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, new McpError((Object)("Failed to handle request: " + e.getMessage())));
                        return null;
                    });
                }
                catch (Exception e2) {
                    logger.error("Failed to handle request: {}", (Object)e2.getMessage());
                    this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, new McpError((Object)("Failed to handle request: " + e2.getMessage())));
                }
            } else if (message instanceof McpSchema.JSONRPCNotification) {
                McpSchema.JSONRPCNotification jsonrpcNotification = (McpSchema.JSONRPCNotification)message;
                try {
                    ((CompletableFuture)this.mcpHandler.handleNotification(transportContext, jsonrpcNotification).thenRun(() -> {
                        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED);
                        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
                        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
                        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    })).exceptionally(e -> {
                        logger.error("Failed to handle notification: {}", (Object)e.getMessage());
                        this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, new McpError((Object)("Failed to handle notification: " + e.getMessage())));
                        return null;
                    });
                }
                catch (Exception e3) {
                    logger.error("Failed to handle notification: {}", (Object)e3.getMessage());
                    this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, new McpError((Object)("Failed to handle notification: " + e3.getMessage())));
                }
            } else {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST, new McpError((Object)"The server accepts either requests or notifications"));
            }
        }
        catch (IOException | IllegalArgumentException e4) {
            logger.error("Failed to deserialize message: {}", (Object)e4.getMessage());
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST, new McpError((Object)"Invalid message format"));
        }
        catch (Exception e5) {
            logger.error("Unexpected error handling message: {}", (Object)e5.getMessage());
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, new McpError((Object)("Unexpected error: " + e5.getMessage())));
        }
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, McpError mcpError) {
        try {
            String jsonError = this.objectMapper.writeValueAsString((Object)mcpError);
            ByteBuf content = Unpooled.copiedBuffer((CharSequence)jsonError, (Charset)CharsetUtil.UTF_8);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)APPLICATION_JSON);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        catch (Exception e) {
            logger.error(FAILED_TO_SEND_ERROR_RESPONSE, (Object)e.getMessage());
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

