/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.tool.function.monitor200;

import com.taobao.arthas.mcp.server.tool.ToolContext;
import com.taobao.arthas.mcp.server.tool.annotation.Tool;
import com.taobao.arthas.mcp.server.tool.annotation.ToolParam;
import com.taobao.arthas.mcp.server.tool.function.AbstractArthasTool;

public class TimeTunnelTool
extends AbstractArthasTool {
    public static final int DEFAULT_NUMBER_OF_EXECUTIONS = 3;
    public static final int DEFAULT_POLL_INTERVAL_MS = 100;
    public static final int DEFAULT_MAX_MATCH_COUNT = 50;

    @Tool(name="tt", description="TimeTunnel \u65f6\u7a7a\u96a7\u9053\u5de5\u5177: \u65b9\u6cd5\u6267\u884c\u6570\u636e\u7684\u65f6\u7a7a\u96a7\u9053\uff0c\u8bb0\u5f55\u4e0b\u6307\u5b9a\u65b9\u6cd5\u6bcf\u6b21\u8c03\u7528\u7684\u5165\u53c2\u548c\u8fd4\u56de\u4fe1\u606f\uff0c\u5bf9\u5e94 Arthas \u7684 tt \u547d\u4ee4\u3002\u652f\u6301\u8bb0\u5f55\u3001\u5217\u8868\u3001\u641c\u7d22\u3001\u67e5\u770b\u8be6\u60c5\u3001\u91cd\u653e\u3001\u5220\u9664\u7b49\u64cd\u4f5c\u3002", streamable=true)
    public String timeTunnel(@ToolParam(description="\u64cd\u4f5c\u7c7b\u578b: record/t(\u8bb0\u5f55), list/l(\u5217\u8868), search/s(\u641c\u7d22), info/i(\u67e5\u770b\u8be6\u60c5), replay/p(\u91cd\u653e), delete/d(\u5220\u9664), deleteAll/da(\u5220\u9664\u6240\u6709)\uff0c\u9ed8\u8ba4record") String action, @ToolParam(description="\u7c7b\u540d\u8868\u8fbe\u5f0f\u5339\u914d\uff0c\u652f\u6301\u901a\u914d\u7b26\uff0c\u5982demo.MathGame\u6216*Test\u3002record\u64cd\u4f5c\u65f6\u5fc5\u9700", required=false) String classPattern, @ToolParam(description="\u65b9\u6cd5\u540d\u8868\u8fbe\u5f0f\u5339\u914d\uff0c\u652f\u6301\u901a\u914d\u7b26\uff0c\u5982primeFactors\u6216*method\u3002record\u64cd\u4f5c\u65f6\u5fc5\u9700", required=false) String methodPattern, @ToolParam(description="OGNL\u6761\u4ef6\u8868\u8fbe\u5f0f\uff0c\u6ee1\u8db3\u6761\u4ef6\u7684\u8c03\u7528\u624d\u4f1a\u88ab\u8bb0\u5f55\uff0c\u5982params[0]<0\u6216'params.length==1'", required=false) String condition, @ToolParam(description="\u8bb0\u5f55\u6b21\u6570\u9650\u5236\uff0c\u9ed8\u8ba4\u503c\u4e3a 3\u3002\u8fbe\u5230\u6307\u5b9a\u6b21\u6570\u540e\u81ea\u52a8\u505c\u6b62\uff08\u4ec5record\u64cd\u4f5c\uff09", required=false) Integer numberOfExecutions, @ToolParam(description="\u5f00\u542f\u6b63\u5219\u8868\u8fbe\u5f0f\u5339\u914d\uff0c\u9ed8\u8ba4\u4e3a\u901a\u914d\u7b26\u5339\u914d\uff0c\u9ed8\u8ba4false", required=false) Boolean regex, @ToolParam(description="\u6307\u5b9a\u7d22\u5f15\uff0c\u7528\u4e8einfo/replay/delete\u7b49\u64cd\u4f5c", required=false) Integer index, @ToolParam(description="\u641c\u7d22\u8868\u8fbe\u5f0f\uff0c\u7528\u4e8esearch\u64cd\u4f5c\uff0c\u652f\u6301OGNL\u8868\u8fbe\u5f0f\u5982'method.name==\"primeFactors\"'", required=false) String searchExpression, @ToolParam(description="Class\u6700\u5927\u5339\u914d\u6570\u91cf\uff0c\u9632\u6b62\u5339\u914d\u5230\u7684Class\u6570\u91cf\u592a\u591a\u5bfc\u81f4JVM\u6302\u8d77\uff0c\u9ed8\u8ba450", required=false) Integer maxMatchCount, ToolContext toolContext) {
        String ttAction = this.normalizeAction(action);
        int execCount = this.getDefaultValue(numberOfExecutions, 3);
        int maxMatch = this.getDefaultValue(maxMatchCount, 50);
        this.validateParameters(ttAction, classPattern, methodPattern, index, searchExpression);
        StringBuilder cmd = this.buildCommand("tt");
        switch (ttAction) {
            case "record": {
                cmd = this.buildRecordCommand(cmd, classPattern, methodPattern, condition, execCount, maxMatch, regex);
                break;
            }
            case "list": {
                cmd = this.buildListCommand(cmd, searchExpression);
                break;
            }
            case "info": {
                cmd.append(" -i ").append(index);
                break;
            }
            case "search": {
                cmd.append(" -s '").append(searchExpression.trim()).append("'");
                break;
            }
            case "replay": {
                cmd.append(" -i ").append(index).append(" -p");
                break;
            }
            case "delete": {
                cmd.append(" -i ").append(index).append(" -d");
                break;
            }
            case "deleteall": {
                cmd.append(" --delete-all");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported action: " + ttAction + ". Supported actions: record(t), list(l), info(i), search(s), replay(p), delete(d), deleteAll(da)");
            }
        }
        return this.executeStreamable(toolContext, cmd.toString(), execCount, 100, "TimeTunnel recording completed successfully");
    }

    private void validateParameters(String action, String classPattern, String methodPattern, Integer index, String searchExpression) {
        switch (action) {
            case "record": {
                if (classPattern == null || classPattern.trim().isEmpty()) {
                    throw new IllegalArgumentException("classPattern is required for record operation");
                }
                if (methodPattern != null && !methodPattern.trim().isEmpty()) break;
                throw new IllegalArgumentException("methodPattern is required for record operation");
            }
            case "info": 
            case "replay": {
                if (index != null) break;
                throw new IllegalArgumentException(action + " operation requires index parameter");
            }
            case "search": {
                if (searchExpression != null && !searchExpression.trim().isEmpty()) break;
                throw new IllegalArgumentException("search operation requires searchExpression parameter");
            }
            case "delete": {
                if (index != null) break;
                throw new IllegalArgumentException("delete operation requires index parameter");
            }
            case "list": 
            case "deleteall": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported action: " + action);
            }
        }
    }

    private String normalizeAction(String action) {
        String normalizedAction;
        if (action == null || action.trim().isEmpty()) {
            return "record";
        }
        switch (normalizedAction = action.trim().toLowerCase()) {
            case "record": 
            case "r": 
            case "-t": 
            case "t": {
                return "record";
            }
            case "list": 
            case "l": 
            case "-l": {
                return "list";
            }
            case "info": 
            case "i": 
            case "-i": {
                return "info";
            }
            case "search": 
            case "s": 
            case "-s": {
                return "search";
            }
            case "replay": 
            case "p": 
            case "-p": {
                return "replay";
            }
            case "delete": 
            case "d": 
            case "-d": {
                return "delete";
            }
            case "deleteall": 
            case "da": 
            case "--delete-all": {
                return "deleteall";
            }
        }
        return normalizedAction;
    }

    private StringBuilder buildRecordCommand(StringBuilder cmd, String classPattern, String methodPattern, String condition, int execCount, int maxMatch, Boolean regex) {
        cmd.append(" -t");
        cmd.append(" -n ").append(execCount);
        cmd.append(" -m ").append(maxMatch);
        if (Boolean.TRUE.equals(regex)) {
            cmd.append(" -E");
        }
        cmd.append(" '").append(classPattern.trim()).append("'");
        cmd.append(" '").append(methodPattern.trim()).append("'");
        if (condition != null && !condition.trim().isEmpty()) {
            cmd.append(" '").append(condition.trim()).append("'");
        }
        return cmd;
    }

    private StringBuilder buildListCommand(StringBuilder cmd, String searchExpression) {
        cmd.append(" -l");
        if (searchExpression != null && !searchExpression.trim().isEmpty()) {
            cmd.append(" '").append(searchExpression.trim()).append("'");
        }
        return cmd;
    }
}

