/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.tool;

import com.taobao.arthas.mcp.server.tool.DefaultToolCallback;
import com.taobao.arthas.mcp.server.tool.ToolCallback;
import com.taobao.arthas.mcp.server.tool.ToolCallbackProvider;
import com.taobao.arthas.mcp.server.tool.annotation.Tool;
import com.taobao.arthas.mcp.server.tool.definition.ToolDefinition;
import com.taobao.arthas.mcp.server.tool.definition.ToolDefinitions;
import com.taobao.arthas.mcp.server.tool.execution.DefaultToolCallResultConverter;
import com.taobao.arthas.mcp.server.tool.execution.ToolCallResultConverter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultToolCallbackProvider
implements ToolCallbackProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultToolCallbackProvider.class);
    private static final String DEFAULT_TOOL_BASE_PACKAGE = "com.taobao.arthas.mcp.server.tool.function";
    private final ToolCallResultConverter toolCallResultConverter = new DefaultToolCallResultConverter();
    private ToolCallback[] toolCallbacks;
    private String toolBasePackage = "com.taobao.arthas.mcp.server.tool.function";

    public void setToolBasePackage(String toolBasePackage) {
        this.toolBasePackage = toolBasePackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ToolCallback[] getToolCallbacks() {
        if (this.toolCallbacks == null) {
            DefaultToolCallbackProvider defaultToolCallbackProvider = this;
            synchronized (defaultToolCallbackProvider) {
                if (this.toolCallbacks == null) {
                    this.toolCallbacks = this.scanForToolCallbacks();
                }
            }
        }
        return this.toolCallbacks;
    }

    private ToolCallback[] scanForToolCallbacks() {
        ArrayList<ToolCallback> callbacks = new ArrayList<ToolCallback>();
        try {
            logger.info("Starting to scan for tool callbacks in package: {}", (Object)this.toolBasePackage);
            this.scanPackageForToolMethods(this.toolBasePackage, callbacks);
            logger.info("Found {} tool callbacks", (Object)callbacks.size());
        }
        catch (Exception e) {
            logger.error("Failed to scan for tool callbacks: {}", (Object)e.getMessage(), (Object)e);
        }
        return callbacks.toArray(new ToolCallback[0]);
    }

    private void scanPackageForToolMethods(String packageName, List<ToolCallback> callbacks) throws IOException {
        String packageDirName = packageName.replace('.', '/');
        ClassLoader classLoader = DefaultToolCallbackProvider.class.getClassLoader();
        logger.info("Using classloader: {} for scanning package: {}", (Object)classLoader, (Object)packageName);
        Enumeration<URL> resources = classLoader.getResources(packageDirName);
        if (!resources.hasMoreElements()) {
            logger.warn("No resources found for package: {}", (Object)packageName);
            return;
        }
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String protocol = resource.getProtocol();
            logger.info("Found resource: {} with protocol: {}", (Object)resource, (Object)protocol);
            if ("file".equals(protocol)) {
                String filePath = URLDecoder.decode(resource.getFile(), StandardCharsets.UTF_8.name());
                logger.info("Scanning directory: {}", (Object)filePath);
                this.scanDirectory(new File(filePath), packageName, callbacks);
                continue;
            }
            if ("jar".equals(protocol)) {
                JarURLConnection jarConn = (JarURLConnection)resource.openConnection();
                JarFile jarFile = jarConn.getJarFile();
                try {
                    logger.info("Scanning jar file: {}", (Object)jarFile.getName());
                    this.scanJarEntries(jarFile, packageDirName, callbacks);
                    continue;
                }
                finally {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    continue;
                }
            }
            logger.warn("Unsupported protocol: {} for resource: {}", (Object)protocol, (Object)resource);
        }
    }

    private void scanDirectory(File directory, String packageName, List<ToolCallback> callbacks) {
        if (!directory.exists() || !directory.isDirectory()) {
            logger.warn("Directory does not exist or is not a directory: {}", (Object)directory);
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            logger.warn("Failed to list files in directory: {}", (Object)directory);
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.scanDirectory(file, packageName + "." + file.getName(), callbacks);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = packageName + "." + file.getName().substring(0, file.getName().length() - 6);
            logger.debug("Processing class: {}", (Object)className);
            this.processClass(className, callbacks);
        }
    }

    private void scanJarEntries(JarFile jarFile, String packageDirName, List<ToolCallback> callbacks) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(packageDirName) || !name.endsWith(".class")) continue;
            String className = name.substring(0, name.length() - 6).replace('/', '.');
            logger.debug("Processing jar entry: {}", (Object)className);
            this.processClass(className, callbacks);
        }
    }

    private void processClass(String className, List<ToolCallback> callbacks) {
        try {
            Class<?> clazz = Class.forName(className, false, DefaultToolCallbackProvider.class.getClassLoader());
            if (clazz.isInterface() || clazz.isEnum() || clazz.isAnnotation()) {
                return;
            }
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Tool.class)) continue;
                this.registerToolMethod(clazz, method, callbacks);
            }
        }
        catch (Throwable t) {
            logger.warn("Error loading class {}: {}", new Object[]{className, t.getMessage(), t});
        }
    }

    private void registerToolMethod(Class<?> clazz, Method method, List<ToolCallback> callbacks) {
        try {
            ToolDefinition toolDefinition = ToolDefinitions.from(method);
            Object toolObject = Modifier.isStatic(method.getModifiers()) ? null : clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DefaultToolCallback callback = DefaultToolCallback.builder().toolDefinition(toolDefinition).toolMethod(method).toolObject(toolObject).toolCallResultConverter(this.toolCallResultConverter).build();
            callbacks.add(callback);
            logger.info("Registered tool: {} from class: {}", (Object)toolDefinition.getName(), (Object)clazz.getName());
        }
        catch (Exception e) {
            logger.error("Failed to register tool {}.{}, error: {}", new Object[]{clazz.getName(), method.getName(), e.getMessage(), e});
        }
    }
}

