/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.mcp.server.protocol.server;

import com.taobao.arthas.mcp.server.CommandExecutor;
import com.taobao.arthas.mcp.server.protocol.server.McpStatelessNotificationHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpStatelessRequestHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpStatelessServerHandler;
import com.taobao.arthas.mcp.server.protocol.server.McpTransportContext;
import com.taobao.arthas.mcp.server.protocol.spec.McpError;
import com.taobao.arthas.mcp.server.protocol.spec.McpSchema;
import com.taobao.arthas.mcp.server.session.ArthasCommandContext;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultMcpStatelessServerHandler
implements McpStatelessServerHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMcpStatelessServerHandler.class);
    Map<String, McpStatelessRequestHandler<?>> requestHandlers;
    Map<String, McpStatelessNotificationHandler> notificationHandlers;
    private final CommandExecutor commandExecutor;

    public DefaultMcpStatelessServerHandler(Map<String, McpStatelessRequestHandler<?>> requestHandlers, Map<String, McpStatelessNotificationHandler> notificationHandlers, CommandExecutor commandExecutor) {
        this.requestHandlers = requestHandlers;
        this.notificationHandlers = notificationHandlers;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public CompletableFuture<McpSchema.JSONRPCResponse> handleRequest(McpTransportContext ctx, McpSchema.JSONRPCRequest req) {
        ArthasCommandContext commandContext = this.createCommandContext();
        McpStatelessRequestHandler<?> handler = this.requestHandlers.get(req.getMethod());
        if (handler == null) {
            CompletableFuture<McpSchema.JSONRPCResponse> f = new CompletableFuture<McpSchema.JSONRPCResponse>();
            f.completeExceptionally(new McpError((Object)("Missing handler for request type: " + req.getMethod())));
            return f;
        }
        try {
            CompletableFuture<?> result = handler.handle(ctx, commandContext, req.getParams());
            return result.handle((r, ex) -> {
                if (ex != null) {
                    Throwable cause = ex instanceof CompletionException ? ex.getCause() : ex;
                    return new McpSchema.JSONRPCResponse("2.0", req.getId(), null, new McpSchema.JSONRPCResponse.JSONRPCError(-32603, cause.getMessage(), null));
                }
                return new McpSchema.JSONRPCResponse("2.0", req.getId(), r, null);
            });
        }
        catch (Throwable t) {
            CompletableFuture<McpSchema.JSONRPCResponse> f = new CompletableFuture<McpSchema.JSONRPCResponse>();
            f.completeExceptionally(t);
            return f;
        }
    }

    @Override
    public CompletableFuture<Void> handleNotification(McpTransportContext ctx, McpSchema.JSONRPCNotification note) {
        McpStatelessNotificationHandler handler = this.notificationHandlers.get(note.getMethod());
        if (handler == null) {
            logger.warn("Missing handler for notification: {}", (Object)note.getMethod());
            return CompletableFuture.completedFuture(null);
        }
        try {
            return handler.handle(ctx, note.getParams());
        }
        catch (Throwable t) {
            CompletableFuture<Void> f = new CompletableFuture<Void>();
            f.completeExceptionally(t);
            return f;
        }
    }

    private ArthasCommandContext createCommandContext() {
        return new ArthasCommandContext(this.commandExecutor);
    }
}

