/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.proxy;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.google.protobuf.GeneratedMessageV3;
import com.taobao.arthas.common.Pair;
import com.taobao.arthas.grpcweb.proxy.CorsUtils;
import com.taobao.arthas.grpcweb.proxy.GrpcServiceConnectionManager;
import com.taobao.arthas.grpcweb.proxy.GrpcWebClientInterceptor;
import com.taobao.arthas.grpcweb.proxy.MessageDeframer;
import com.taobao.arthas.grpcweb.proxy.MessageUtils;
import com.taobao.arthas.grpcweb.proxy.MetadataUtil;
import com.taobao.arthas.grpcweb.proxy.SendGrpcWebResponse;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class GrpcWebRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private final GrpcServiceConnectionManager grpcServiceConnectionManager;

    public GrpcWebRequestHandler(GrpcServiceConnectionManager g) {
        this.grpcServiceConnectionManager = g;
    }

    public void handle(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (req.method().equals((Object)HttpMethod.OPTIONS)) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            CorsUtils.updateCorsHeader(response.headers());
            ctx.writeAndFlush((Object)response);
            return;
        }
        String contentTypeStr = req.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        MessageUtils.ContentType contentType = MessageUtils.validateContentType(contentTypeStr);
        SendGrpcWebResponse sendResponse = new SendGrpcWebResponse(ctx, req);
        try {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(req.uri());
            String pathInfo = queryStringDecoder.path();
            Pair<String, String> classAndMethodNames = this.getClassAndMethod(pathInfo);
            String className = (String)classAndMethodNames.getFirst();
            String methodName = (String)classAndMethodNames.getSecond();
            Class<?> cls = this.getClassObject(className);
            if (cls == null) {
                logger.error("cannot find service impl in the request, className: " + className);
                sendResponse.returnUnimplementedStatusCode(className);
                return;
            }
            CountDownLatch latch = new CountDownLatch(1);
            GrpcWebClientInterceptor interceptor = new GrpcWebClientInterceptor(latch, sendResponse);
            Channel channel = this.grpcServiceConnectionManager.getChannelWithClientInterceptor(interceptor);
            AbstractStub asyncStub = this.getRpcStub(channel, cls, "newStub");
            Metadata headers = MetadataUtil.getHtpHeaders(req.headers());
            if (!headers.keys().isEmpty()) {
                asyncStub = MetadataUtils.attachHeaders((AbstractStub)asyncStub, (Metadata)headers);
            }
            Method asyncStubCall = this.getRpcMethod(asyncStub, methodName);
            ByteBuf content = req.content();
            ByteBufInputStream in = new ByteBufInputStream(content);
            MessageDeframer deframer = new MessageDeframer();
            Object inObj = null;
            if (deframer.processInput((InputStream)in, contentType)) {
                inObj = MessageUtils.getInputProtobufObj(asyncStubCall, deframer.getMessageBytes());
            }
            ManagedChannel managedChannel = this.grpcServiceConnectionManager.getChannel();
            asyncStubCall.invoke((Object)asyncStub, inObj, new GrpcCallResponseReceiver(sendResponse, latch, managedChannel));
            if (!latch.await(1000L, TimeUnit.MILLISECONDS)) {
                logger.warn("grpc call took too long!");
            }
        }
        catch (Exception e) {
            logger.error("try to invoke grpc serivce error, uri: {}", (Object)req.uri(), (Object)e);
            sendResponse.writeError(Status.UNAVAILABLE.withCause((Throwable)e));
        }
    }

    private Pair<String, String> getClassAndMethod(String pathInfo) throws IllegalArgumentException {
        String[] rpcClassAndMethodTokens = pathInfo.substring(1).split("/");
        if (rpcClassAndMethodTokens.length != 2) {
            throw new IllegalArgumentException("incorrect pathinfo: " + pathInfo);
        }
        String rpcClassName = rpcClassAndMethodTokens[0];
        String rpcMethodNameRecvd = rpcClassAndMethodTokens[1];
        String rpcMethodName = rpcMethodNameRecvd.substring(0, 1).toLowerCase() + rpcMethodNameRecvd.substring(1);
        return new Pair((Object)rpcClassName, (Object)rpcMethodName);
    }

    private Class<?> getClassObject(String className) {
        Class<?> rpcClass = null;
        try {
            rpcClass = Class.forName(className + "Grpc");
        }
        catch (ClassNotFoundException e) {
            logger.info("no such class " + className);
        }
        return rpcClass;
    }

    private AbstractStub getRpcStub(Channel ch, Class cls, String stubName) {
        try {
            Method m = cls.getDeclaredMethod(stubName, Channel.class);
            return (AbstractStub)m.invoke(null, ch);
        }
        catch (Exception e) {
            logger.warn("Error when fetching " + stubName + " for: " + cls.getName());
            throw new IllegalArgumentException(e);
        }
    }

    private Method getRpcMethod(Object stub, String rpcMethodName) {
        for (Method m : stub.getClass().getMethods()) {
            if (!m.getName().equals(rpcMethodName)) continue;
            return m;
        }
        throw new IllegalArgumentException("Couldn't find rpcmethod: " + rpcMethodName);
    }

    private static class GrpcCallResponseReceiver<Object>
    implements StreamObserver {
        private final SendGrpcWebResponse sendResponse;
        private final CountDownLatch latch;
        private final ManagedChannel channel;

        GrpcCallResponseReceiver(SendGrpcWebResponse s, CountDownLatch c, ManagedChannel channel) {
            this.sendResponse = s;
            this.latch = c;
            this.channel = channel;
        }

        public void onNext(Object resp) {
            byte[] outB = ((GeneratedMessageV3)resp).toByteArray();
            if (!this.sendResponse.writeResponse(outB)) {
                this.channel.shutdownNow();
                logger.error("Grpc shutdown from grpc web proxy client");
            }
        }

        public void onError(Throwable t) {
            Status s = Status.fromThrowable((Throwable)t);
            this.sendResponse.writeError(s);
            this.latch.countDown();
        }

        public void onCompleted() {
            this.sendResponse.writeTrailer(Status.OK, null);
            this.latch.countDown();
        }
    }
}

