/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.proxy;

import com.taobao.arthas.grpcweb.proxy.SendGrpcWebResponse;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.CountDownLatch;

class GrpcWebClientInterceptor
implements ClientInterceptor {
    private final CountDownLatch latch;
    private final SendGrpcWebResponse sendResponse;

    GrpcWebClientInterceptor(CountDownLatch latch, SendGrpcWebResponse send) {
        this.latch = latch;
        this.sendResponse = send;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel channel) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(channel.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start(new MetadataResponseListener(responseListener), headers);
            }
        };
    }

    class MetadataResponseListener<T>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<T> {
        private boolean headersSent;

        MetadataResponseListener(ClientCall.Listener<T> responseListener) {
            super(responseListener);
            this.headersSent = false;
        }

        public void onHeaders(Metadata h) {
            GrpcWebClientInterceptor.this.sendResponse.writeHeaders(h);
            this.headersSent = true;
        }

        public void onClose(Status s, Metadata t) {
            if (this.headersSent) {
                GrpcWebClientInterceptor.this.sendResponse.writeTrailer(s, t);
                GrpcWebClientInterceptor.this.latch.countDown();
            }
            super.onClose(s, t);
        }
    }
}

