/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.grpc.objectUtils;

import io.arthas.api.ArthasServices;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class JavaObjectConverter {
    private static final int MAX_DEPTH = 5;

    public static ArthasServices.JavaObject toJavaObject(Object obj) {
        return JavaObjectConverter.toJavaObject(obj, 0);
    }

    public static ArthasServices.JavaObject toJavaObjectWithExpand(Object obj, int expand) {
        int depth = expand <= 0 ? 4 : (expand >= 5 ? 0 : 5 - expand);
        return JavaObjectConverter.toJavaObject(obj, depth);
    }

    public static ArthasServices.JavaObject toJavaObject(Object obj, int depth) {
        if (depth >= 5) {
            return null;
        }
        if (obj == null) {
            return ArthasServices.JavaObject.newBuilder().setNullValue(ArthasServices.NullValue.getDefaultInstance()).build();
        }
        ArthasServices.JavaObject.Builder objectBuilder = ArthasServices.JavaObject.newBuilder();
        Class<?> objClazz = obj.getClass();
        objectBuilder.setClassName(objClazz.getName());
        if (JavaObjectConverter.isBasicType(objClazz)) {
            return objectBuilder.setBasicValue(JavaObjectConverter.createBasicValue(obj)).build();
        }
        if (obj instanceof Collection) {
            return objectBuilder.setCollection(JavaObjectConverter.createCollectionValue((Collection)obj, depth)).build();
        }
        if (obj instanceof Map) {
            return objectBuilder.setMap(JavaObjectConverter.createMapValue((Map)obj, depth)).build();
        }
        if (objClazz.isArray()) {
            return objectBuilder.setArrayValue(JavaObjectConverter.toArrayValue(obj, depth)).build();
        }
        Field[] fields = objClazz.getDeclaredFields();
        ArrayList<ArthasServices.JavaField> javaFields = new ArrayList<ArthasServices.JavaField>();
        for (Field field : fields) {
            field.setAccessible(true);
            ArthasServices.JavaField.Builder fieldBuilder = ArthasServices.JavaField.newBuilder();
            fieldBuilder.setName(field.getName());
            try {
                Object fieldValue = field.get(obj);
                Class<?> fieldType = field.getType();
                if (fieldValue == null) {
                    fieldBuilder.setNullValue(ArthasServices.NullValue.newBuilder().setClassName(fieldType.getName()).build());
                } else if (fieldType.isArray()) {
                    ArthasServices.ArrayValue arrayValue = JavaObjectConverter.toArrayValue(fieldValue, depth + 1);
                    if (arrayValue != null) {
                        fieldBuilder.setArrayValue(arrayValue);
                    } else {
                        fieldBuilder.setUnexpandedObject(ArthasServices.UnexpandedObject.newBuilder().setClassName(fieldType.getName()).build());
                    }
                } else if (fieldType.isPrimitive() || JavaObjectConverter.isBasicType(fieldType)) {
                    ArthasServices.BasicValue basicValue = JavaObjectConverter.createBasicValue(fieldValue);
                    fieldBuilder.setBasicValue(basicValue);
                } else if (fieldValue instanceof Collection) {
                    fieldBuilder.setCollection(JavaObjectConverter.createCollectionValue((Collection)fieldValue, depth));
                } else if (fieldValue instanceof Map) {
                    fieldBuilder.setMap(JavaObjectConverter.createMapValue((Map)fieldValue, depth));
                } else {
                    ArthasServices.JavaObject nestedObject = JavaObjectConverter.toJavaObject(fieldValue, depth + 1);
                    if (nestedObject != null) {
                        fieldBuilder.setObjectValue(nestedObject);
                    } else {
                        fieldBuilder.setUnexpandedObject(ArthasServices.UnexpandedObject.newBuilder().setClassName(fieldType.getName()).build());
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            javaFields.add(fieldBuilder.build());
        }
        objectBuilder.setFields(ArthasServices.JavaFields.newBuilder().addAllFields(javaFields).build());
        return objectBuilder.build();
    }

    private static ArthasServices.ArrayValue toArrayValue(Object array, int depth) {
        if (array == null || depth >= 5) {
            return null;
        }
        ArthasServices.ArrayValue.Builder arrayBuilder = ArthasServices.ArrayValue.newBuilder();
        Class<?> componentType = array.getClass().getComponentType();
        arrayBuilder.setClassName(componentType.getName());
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            if (element != null) {
                if (componentType.isArray()) {
                    ArthasServices.ArrayValue nestedArrayValue = JavaObjectConverter.toArrayValue(element, depth + 1);
                    if (nestedArrayValue != null) {
                        arrayBuilder.addElements(ArthasServices.ArrayElement.newBuilder().setArrayValue(nestedArrayValue));
                        continue;
                    }
                    arrayBuilder.addElements(ArthasServices.ArrayElement.newBuilder().setUnexpandedObject(ArthasServices.UnexpandedObject.newBuilder().setClassName(element.getClass().getName()).build()));
                    continue;
                }
                if (componentType.isPrimitive() || JavaObjectConverter.isBasicType(componentType)) {
                    ArthasServices.BasicValue basicValue = JavaObjectConverter.createBasicValue(element);
                    arrayBuilder.addElements(ArthasServices.ArrayElement.newBuilder().setBasicValue(basicValue));
                    continue;
                }
                ArthasServices.JavaObject nestedObject = JavaObjectConverter.toJavaObject(element, depth + 1);
                if (nestedObject != null) {
                    arrayBuilder.addElements(ArthasServices.ArrayElement.newBuilder().setObjectValue(nestedObject));
                    continue;
                }
                arrayBuilder.addElements(ArthasServices.ArrayElement.newBuilder().setUnexpandedObject(ArthasServices.UnexpandedObject.newBuilder().setClassName(element.getClass().getName()).build()));
                continue;
            }
            arrayBuilder.addElements(ArthasServices.ArrayElement.newBuilder().setNullValue(ArthasServices.NullValue.newBuilder().setClassName(componentType.getName()).build()));
        }
        return arrayBuilder.build();
    }

    private static ArthasServices.MapValue createMapValue(Map<?, ?> map, int depth) {
        ArthasServices.MapValue.Builder builder = ArthasServices.MapValue.newBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            ArthasServices.MapEntry mapEntry = ArthasServices.MapEntry.newBuilder().setKey(JavaObjectConverter.toJavaObject(entry.getKey(), depth)).setValue(JavaObjectConverter.toJavaObject(entry.getValue(), depth)).build();
            builder.addEntries(mapEntry);
        }
        return builder.build();
    }

    private static ArthasServices.CollectionValue createCollectionValue(Collection<?> collection, int depth) {
        ArthasServices.CollectionValue.Builder builder = ArthasServices.CollectionValue.newBuilder();
        for (Object o : collection) {
            builder.addElements(JavaObjectConverter.toJavaObject(o, depth));
        }
        return builder.build();
    }

    private static ArthasServices.BasicValue createBasicValue(Object value) {
        ArthasServices.BasicValue.Builder builder = ArthasServices.BasicValue.newBuilder();
        if (value instanceof Integer) {
            builder.setInt((Integer)value);
        } else if (value instanceof Long) {
            builder.setLong((Long)value);
        } else if (value instanceof Float) {
            builder.setFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            builder.setDouble((Double)value);
        } else if (value instanceof Boolean) {
            builder.setBoolean((Boolean)value);
        } else if (value instanceof String) {
            builder.setString((String)value);
        }
        return builder.build();
    }

    private static boolean isBasicType(Class<?> clazz) {
        return String.class.equals(clazz) || Integer.class.equals(clazz) || Long.class.equals(clazz) || Float.class.equals(clazz) || Double.class.equals(clazz) || Boolean.class.equals(clazz);
    }
}

