/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.grpc.service;

import com.google.protobuf.Empty;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.model.SystemPropertyModel;
import com.taobao.arthas.core.shell.system.ExecStatus;
import com.taobao.arthas.grpcweb.grpc.observer.impl.ArthasStreamObserverImpl;
import com.taobao.arthas.grpcweb.grpc.service.GrpcJobController;
import io.arthas.api.ArthasServices;
import io.arthas.api.SystemPropertyGrpc;
import io.grpc.stub.StreamObserver;
import java.util.Map;

public class SystemPropertyCommandService
extends SystemPropertyGrpc.SystemPropertyImplBase {
    private GrpcJobController grpcJobController;

    public SystemPropertyCommandService(GrpcJobController grpcJobController) {
        this.grpcJobController = grpcJobController;
    }

    @Override
    public void get(Empty empty, StreamObserver<ArthasServices.ResponseBody> responseObserver) {
        ArthasStreamObserverImpl<ArthasServices.ResponseBody> arthasStreamObserver = new ArthasStreamObserverImpl<ArthasServices.ResponseBody>(responseObserver, null, this.grpcJobController);
        arthasStreamObserver.setProcessStatus(ExecStatus.RUNNING);
        arthasStreamObserver.appendResult((ResultModel)new SystemPropertyModel((Map)System.getProperties()));
        arthasStreamObserver.end();
    }

    @Override
    public void getByKey(ArthasServices.StringKey request, StreamObserver<ArthasServices.ResponseBody> responseObserver) {
        String propertyName = request.getKey();
        ArthasStreamObserverImpl<ArthasServices.ResponseBody> arthasStreamObserver = new ArthasStreamObserverImpl<ArthasServices.ResponseBody>(responseObserver, null, this.grpcJobController);
        arthasStreamObserver.setProcessStatus(ExecStatus.RUNNING);
        String value = System.getProperty(propertyName);
        if (value == null) {
            arthasStreamObserver.end(-1, "There is no property with the key " + propertyName);
            return;
        }
        arthasStreamObserver.appendResult((ResultModel)new SystemPropertyModel(propertyName, value));
        arthasStreamObserver.end();
    }

    @Override
    public void update(ArthasServices.StringStringMapValue request, StreamObserver<ArthasServices.ResponseBody> responseObserver) {
        Map<String, String> properties = request.getStringStringMapMap();
        String propertyName = "";
        String propertyValue = "";
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            propertyName = entry.getKey();
            propertyValue = entry.getValue();
        }
        ArthasStreamObserverImpl<ArthasServices.ResponseBody> arthasStreamObserver = new ArthasStreamObserverImpl<ArthasServices.ResponseBody>(responseObserver, null, this.grpcJobController);
        arthasStreamObserver.setProcessStatus(ExecStatus.RUNNING);
        try {
            System.setProperty(propertyName, propertyValue);
            arthasStreamObserver.appendResult((ResultModel)new SystemPropertyModel(propertyName, System.getProperty(propertyName)));
            arthasStreamObserver.onCompleted();
        }
        catch (Throwable t) {
            arthasStreamObserver.end(-1, "Error during setting system property: " + t.getMessage());
        }
    }
}

