/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpcweb.grpc.server.httpServer;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import javax.activation.MimetypesFileTypeMap;

public class NettyHttpStaticFileHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private final String STATIC_LOCATION;

    public NettyHttpStaticFileHandler(String staticLocation) {
        this.STATIC_LOCATION = staticLocation;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws URISyntaxException, IOException {
        ChannelFuture lastContentFuture;
        ChannelFuture sendFileFuture;
        RandomAccessFile randomAccessFile;
        String uri = new URI(request.uri()).getPath();
        if ("/favicon.ico".equals(uri)) {
            return;
        }
        if ("/".equals(uri)) {
            uri = "/index.html";
        }
        String path = Paths.get(this.STATIC_LOCATION, uri).toString();
        File file = new File(path);
        if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
            NettyHttpStaticFileHandler.send100Continue(ctx);
        }
        if (file.isHidden() || !file.exists() || file.isDirectory() || !file.isFile()) {
            NettyHttpStaticFileHandler.sendNotFound(ctx);
            return;
        }
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            NettyHttpStaticFileHandler.sendNotFound(ctx);
            throw new RuntimeException(e);
        }
        DefaultHttpResponse response = new DefaultHttpResponse(request.protocolVersion(), HttpResponseStatus.OK);
        if (path.endsWith(".html")) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
        } else if (path.endsWith(".js")) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/x-javascript");
        } else if (path.endsWith(".css")) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/css; charset=UTF-8");
        } else {
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mimetypesFileTypeMap.getContentType(path));
        }
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        if (keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)randomAccessFile.length());
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ctx.write((Object)response);
        if (ctx.pipeline().get(SslHandler.class) == null) {
            sendFileFuture = ctx.write((Object)new DefaultFileRegion(randomAccessFile.getChannel(), 0L, randomAccessFile.length()), (ChannelPromise)ctx.newProgressivePromise());
            lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        } else {
            lastContentFuture = sendFileFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(randomAccessFile, 0L, randomAccessFile.length(), 0xA00000)), (ChannelPromise)ctx.newProgressivePromise());
        }
        sendFileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

            public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                if (total < 0L) {
                    logger.info(future.channel() + " Transfer progress: " + progress);
                } else {
                    logger.info(future.channel() + " Transfer progress: " + progress + " / " + total);
                }
            }

            public void operationComplete(ChannelProgressiveFuture future) {
                logger.info(future.channel() + " Transfer complete.");
            }
        });
        if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.writeAndFlush((Object)response);
    }

    private static void sendNotFound(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        ctx.writeAndFlush((Object)response);
    }
}

