/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpc.server.handler.executor;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.grpc.server.handler.GrpcDispatcher;
import com.taobao.arthas.grpc.server.handler.constant.GrpcInvokeTypeEnum;
import com.taobao.arthas.grpc.server.handler.executor.AbstractGrpcExecutor;
import com.taobao.arthas.grpc.server.handler.executor.GrpcExecutor;
import com.taobao.arthas.grpc.server.utils.ReflectUtil;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GrpcExecutorFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    public static final String DEFAULT_GRPC_EXECUTOR_PACKAGE_NAME = "com.taobao.arthas.grpc.server.handler.executor";
    private final Map<GrpcInvokeTypeEnum, GrpcExecutor> map = new HashMap<GrpcInvokeTypeEnum, GrpcExecutor>();

    public void loadExecutor(GrpcDispatcher dispatcher) {
        List<Class<?>> classes = ReflectUtil.findClasses(DEFAULT_GRPC_EXECUTOR_PACKAGE_NAME);
        for (Class<?> clazz : classes) {
            if (!GrpcExecutor.class.isAssignableFrom(clazz)) continue;
            try {
                GrpcExecutor executor;
                Constructor<?> constructor;
                if (AbstractGrpcExecutor.class.equals(clazz) || GrpcExecutor.class.equals(clazz)) continue;
                if (AbstractGrpcExecutor.class.isAssignableFrom(clazz)) {
                    constructor = clazz.getConstructor(GrpcDispatcher.class);
                    executor = (GrpcExecutor)constructor.newInstance(dispatcher);
                    this.map.put(executor.supportGrpcType(), executor);
                    continue;
                }
                constructor = clazz.getConstructor(new Class[0]);
                executor = (GrpcExecutor)constructor.newInstance(new Object[0]);
                this.map.put(executor.supportGrpcType(), executor);
            }
            catch (Exception e) {
                logger.error("GrpcExecutorFactory loadExecutor error", (Throwable)e);
            }
        }
    }

    public GrpcExecutor getExecutor(GrpcInvokeTypeEnum grpcType) {
        return this.map.get((Object)grpcType);
    }
}

