/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpc.server.handler.executor;

import com.taobao.arthas.grpc.server.handler.GrpcDispatcher;
import com.taobao.arthas.grpc.server.handler.GrpcRequest;
import com.taobao.arthas.grpc.server.handler.GrpcResponse;
import com.taobao.arthas.grpc.server.handler.constant.GrpcInvokeTypeEnum;
import com.taobao.arthas.grpc.server.handler.executor.AbstractGrpcExecutor;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2DataFrame;

public class UnaryExecutor
extends AbstractGrpcExecutor {
    public UnaryExecutor(GrpcDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    public GrpcInvokeTypeEnum supportGrpcType() {
        return GrpcInvokeTypeEnum.UNARY;
    }

    @Override
    public void execute(GrpcRequest request, Http2DataFrame frame, ChannelHandlerContext context) throws Throwable {
        if (frame.isEndStream()) {
            GrpcResponse response = this.dispatcher.unaryExecute(request);
            context.writeAndFlush((Object)new DefaultHttp2HeadersFrame(response.getEndHeader()).stream(frame.stream()));
            context.writeAndFlush((Object)new DefaultHttp2DataFrame(response.getResponseData()).stream(frame.stream()));
            context.writeAndFlush((Object)new DefaultHttp2HeadersFrame(response.getEndStreamHeader(), true).stream(frame.stream()));
        }
    }
}

