/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.grpc.server;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.grpc.server.handler.GrpcDispatcher;
import com.taobao.arthas.grpc.server.handler.Http2Handler;
import com.taobao.arthas.grpc.server.handler.executor.GrpcExecutorFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import java.lang.invoke.MethodHandles;

public class ArthasGrpcServer {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    private int port = 9090;
    private String grpcServicePackageName;

    public ArthasGrpcServer(int port, String grpcServicePackageName) {
        this.port = port;
        this.grpcServicePackageName = grpcServicePackageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(10);
        final GrpcDispatcher grpcDispatcher = new GrpcDispatcher();
        grpcDispatcher.loadGrpcService(this.grpcServicePackageName);
        final GrpcExecutorFactory grpcExecutorFactory = new GrpcExecutorFactory();
        grpcExecutorFactory.loadExecutor(grpcDispatcher);
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{Http2FrameCodecBuilder.forServer().build()});
                    ch.pipeline().addLast(new ChannelHandler[]{new Http2Handler(grpcDispatcher, grpcExecutorFactory)});
                }
            });
            Channel channel = b.bind(this.port).sync().channel();
            logger.info("ArthasGrpcServer start successfully on port: {}", (Object)this.port);
            channel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            logger.error("ArthasGrpcServer start error", (Throwable)e);
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }
}

