/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.mcp.tool.function.basic1000;

import com.taobao.arthas.core.mcp.tool.function.AbstractArthasTool;
import com.taobao.arthas.core.mcp.tool.function.StreamableToolUtils;
import com.taobao.arthas.mcp.server.tool.ToolContext;
import com.taobao.arthas.mcp.server.tool.annotation.Tool;
import com.taobao.arthas.mcp.server.tool.annotation.ToolParam;
import com.taobao.arthas.mcp.server.util.JsonParser;
import java.util.HashMap;

public class StopTool
extends AbstractArthasTool {
    public static final int DEFAULT_SHUTDOWN_DELAY_MS = 1000;

    @Tool(name="stop", description="\u5f7b\u5e95\u505c\u6b62 Arthas\u3002\u6ce8\u610f\u505c\u6b62\u4e4b\u540e\u4e0d\u80fd\u518d\u8c03\u7528\u4efb\u4f55 tool \u4e86\u3002\u4e3a\u4e86\u786e\u4fdd MCP client \u80fd\u6536\u5230\u8fd4\u56de\u7ed3\u679c\uff0c\u672c tool \u4f1a\u5148\u8fd4\u56de\uff0c\u518d\u5ef6\u8fdf\u6267\u884c stop\u3002")
    public String stop(@ToolParam(description="\u5ef6\u8fdf\u6267\u884c stop \u7684\u6beb\u79d2\u6570\uff0c\u9ed8\u8ba4 1000ms\u3002\u7528\u4e8e\u786e\u4fdd MCP client \u6536\u5230\u8fd4\u56de\u7ed3\u679c\u3002", required=false) Integer delayMs, ToolContext toolContext) {
        try {
            int shutdownDelayMs = this.getDefaultValue(delayMs, 1000);
            AbstractArthasTool.ToolExecutionContext execContext = new AbstractArthasTool.ToolExecutionContext(toolContext, false);
            this.scheduleStop(execContext, shutdownDelayMs);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("command", "stop");
            result.put("scheduled", true);
            result.put("delayMs", shutdownDelayMs);
            result.put("note", "Arthas \u5c06\u5728\u8fd4\u56de\u7ed3\u679c\u540e\u505c\u6b62\uff0cMCP \u8fde\u63a5\u4f1a\u65ad\u5f00\u3002");
            return JsonParser.toJson(StreamableToolUtils.createCompletedResponse("Stop scheduled", result));
        }
        catch (Exception e) {
            this.logger.error("Error scheduling stop", (Throwable)e);
            return JsonParser.toJson(StreamableToolUtils.createErrorResponse("Error scheduling stop: " + e.getMessage()));
        }
    }

    private void scheduleStop(AbstractArthasTool.ToolExecutionContext execContext, int delayMs) {
        Object authSubject = execContext.getAuthSubject();
        String userId = execContext.getUserId();
        Thread shutdownThread = new Thread(() -> {
            try {
                if (delayMs > 0) {
                    Thread.sleep(delayMs);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                execContext.getCommandContext().getCommandExecutor().executeSync("stop", 300000L, null, authSubject, userId);
            }
            catch (Throwable t) {
                this.logger.error("Error executing stop command in background thread", t);
            }
        }, "arthas-mcp-stop");
        shutdownThread.setDaemon(true);
        shutdownThread.start();
    }
}

