/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.klass100.ClassLoaderCommand;
import com.taobao.arthas.core.command.model.ClassDetailVO;
import com.taobao.arthas.core.command.model.ClassLoaderModel;
import com.taobao.arthas.core.command.model.ClassLoaderVO;
import com.taobao.arthas.core.command.model.ClassSetVO;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.ui.TreeElement;
import com.taobao.text.util.RenderUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ClassLoaderView
extends ResultView<ClassLoaderModel> {
    @Override
    public void draw(CommandProcess process, ClassLoaderModel result) {
        if (result.getMatchedClassLoaders() != null) {
            process.write("Matched classloaders: \n");
            ClassLoaderView.drawClassLoaders(process, result.getMatchedClassLoaders(), false);
            process.write("\n");
            return;
        }
        if (result.getClassSet() != null) {
            this.drawAllClasses(process, result.getClassSet());
        }
        if (result.getResources() != null) {
            this.drawResources(process, result.getResources());
        }
        if (result.getLoadClass() != null) {
            this.drawLoadClass(process, result.getLoadClass());
        }
        if (result.getUrls() != null) {
            this.drawClassLoaderUrls(process, result.getUrls());
        }
        if (result.getClassLoaders() != null) {
            ClassLoaderView.drawClassLoaders(process, result.getClassLoaders(), result.getTree());
        }
        if (result.getClassLoaderStats() != null) {
            this.drawClassLoaderStats(process, result.getClassLoaderStats());
        }
        if (result.getUrlStats() != null) {
            this.drawUrlStats(process, result.getUrlStats());
        }
        if (result.getUrlClassStats() != null) {
            this.drawUrlClassStats(process, result.getClassLoader(), result.getUrlClassStats(), Boolean.TRUE.equals(result.getUrlClassStatsDetail()));
        }
    }

    private void drawUrlClassStats(CommandProcess process, ClassLoaderVO classLoader, List<ClassLoaderCommand.UrlClassStat> urlClassStats, boolean detail) {
        if (classLoader != null) {
            process.write(classLoader.getName() + ", hash:" + classLoader.getHash() + "\n");
        }
        boolean hasMatched = false;
        for (ClassLoaderCommand.UrlClassStat stat : urlClassStats) {
            if (stat.getMatchedClassCount() == null) continue;
            hasMatched = true;
            break;
        }
        if (!detail) {
            TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
            RowElement header = new RowElement().style(Decoration.bold.bold());
            if (hasMatched) {
                header.add(new String[]{"url", "loadedClassCount", "matchedClassCount"});
            } else {
                header.add(new String[]{"url", "loadedClassCount"});
            }
            table.add(header);
            for (ClassLoaderCommand.UrlClassStat stat : urlClassStats) {
                if (hasMatched) {
                    table.row(new String[]{stat.getUrl(), "" + stat.getLoadedClassCount(), "" + stat.getMatchedClassCount()});
                    continue;
                }
                table.row(new String[]{stat.getUrl(), "" + stat.getLoadedClassCount()});
            }
            process.write(RenderUtil.render((Element)table, (int)process.width())).write("");
            return;
        }
        for (ClassLoaderCommand.UrlClassStat stat : urlClassStats) {
            TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
            StringBuilder title = new StringBuilder();
            title.append(stat.getUrl()).append(" (loaded: ").append(stat.getLoadedClassCount());
            if (hasMatched) {
                title.append(", matched: ").append(stat.getMatchedClassCount());
            }
            title.append(")");
            table.row(new Element[]{new LabelElement(title.toString()).style(Decoration.bold.bold())});
            List<String> classes = stat.getClasses();
            if (classes != null) {
                for (String className : classes) {
                    table.row(new String[]{className});
                }
            }
            if (stat.isTruncated() && classes != null) {
                int total = hasMatched ? stat.getMatchedClassCount().intValue() : stat.getLoadedClassCount();
                table.row(new Element[]{new LabelElement("... (showing first " + classes.size() + " of " + total + ", use -n/--limit to change limit)")});
            }
            process.write(RenderUtil.render((Element)table, (int)process.width())).write("\n");
        }
    }

    private void drawUrlStats(CommandProcess process, Map<ClassLoaderVO, ClassLoaderCommand.ClassLoaderUrlStat> urlStats) {
        for (Map.Entry<ClassLoaderVO, ClassLoaderCommand.ClassLoaderUrlStat> entry : urlStats.entrySet()) {
            ClassLoaderVO classLoaderVO = entry.getKey();
            ClassLoaderCommand.ClassLoaderUrlStat urlStat = entry.getValue();
            if (urlStat.getUsedUrls().isEmpty() && urlStat.getUnUsedUrls().isEmpty()) continue;
            TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
            table.row(new Element[]{new LabelElement(classLoaderVO.getName() + ", hash:" + classLoaderVO.getHash()).style(Decoration.bold.bold())});
            Collection<String> usedUrls = urlStat.getUsedUrls();
            table.row(new Element[]{new LabelElement("Used URLs:").style(Decoration.bold.bold())});
            for (String url : usedUrls) {
                table.row(new String[]{url});
            }
            Collection<String> UnnsedUrls = urlStat.getUnUsedUrls();
            table.row(new Element[]{new LabelElement("Unused URLs:").style(Decoration.bold.bold())});
            for (String url : UnnsedUrls) {
                table.row(new String[]{url});
            }
            process.write(RenderUtil.render((Element)table, (int)process.width())).write("\n");
        }
    }

    private void drawClassLoaderStats(CommandProcess process, Map<String, ClassLoaderCommand.ClassLoaderStat> classLoaderStats) {
        TableElement element = ClassLoaderView.renderStat(classLoaderStats);
        process.write(RenderUtil.render((Element)element, (int)process.width())).write("");
    }

    private static TableElement renderStat(Map<String, ClassLoaderCommand.ClassLoaderStat> classLoaderStats) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.add(new RowElement().style(Decoration.bold.bold()).add(new String[]{"name", "numberOfInstances", "loadedCountTotal"}));
        for (Map.Entry<String, ClassLoaderCommand.ClassLoaderStat> entry : classLoaderStats.entrySet()) {
            table.row(new String[]{entry.getKey(), "" + entry.getValue().getNumberOfInstance(), "" + entry.getValue().getLoadedCount()});
        }
        return table;
    }

    public static void drawClassLoaders(CommandProcess process, Collection<ClassLoaderVO> classLoaders, boolean isTree) {
        Element element = isTree ? ClassLoaderView.renderTree(classLoaders) : ClassLoaderView.renderTable(classLoaders);
        process.write(RenderUtil.render((Element)element, (int)process.width())).write("");
    }

    private void drawClassLoaderUrls(CommandProcess process, List<String> urls) {
        process.write(RenderUtil.render((Element)ClassLoaderView.renderClassLoaderUrls(urls), (int)process.width()));
        process.write("");
    }

    private void drawLoadClass(CommandProcess process, ClassDetailVO loadClass) {
        process.write(RenderUtil.render((Element)ClassUtils.renderClassInfo(loadClass), (int)process.width()) + "\n");
    }

    private void drawAllClasses(CommandProcess process, ClassSetVO classSetVO) {
        process.write(RenderUtil.render((Element)this.renderClasses(classSetVO), (int)process.width()));
        process.write("\n");
    }

    private void drawResources(CommandProcess process, List<String> resources) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        for (String resource : resources) {
            table.row(new String[]{resource});
        }
        process.write(RenderUtil.render((Element)table, (int)process.width()) + "\n");
        process.write("");
    }

    private Element renderClasses(ClassSetVO classSetVO) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        if (classSetVO.getSegment() == 0) {
            table.row(new Element[]{new LabelElement("hash:" + classSetVO.getClassloader().getHash() + ", " + classSetVO.getClassloader().getName()).style(Decoration.bold.bold())});
        }
        for (String className : classSetVO.getClasses()) {
            table.row(new Element[]{new LabelElement(className)});
        }
        return table;
    }

    private static Element renderClassLoaderUrls(List<String> urls) {
        StringBuilder sb = new StringBuilder();
        for (String url : urls) {
            sb.append(url).append("\n");
        }
        return new LabelElement(sb.toString());
    }

    private static TableElement renderTable(Collection<ClassLoaderVO> classLoaderInfos) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.add(new RowElement().style(Decoration.bold.bold()).add(new String[]{"name", "loadedCount", "hash", "parent"}));
        for (ClassLoaderVO classLoaderVO : classLoaderInfos) {
            table.row(new String[]{classLoaderVO.getName(), "" + classLoaderVO.getLoadedCount(), classLoaderVO.getHash(), classLoaderVO.getParent()});
        }
        return table;
    }

    private static Element renderTree(Collection<ClassLoaderVO> classLoaderInfos) {
        TreeElement root = new TreeElement();
        for (ClassLoaderVO classLoader : classLoaderInfos) {
            TreeElement child = new TreeElement(classLoader.getName());
            root.addChild((Element)child);
            ClassLoaderView.renderSubtree(child, classLoader);
        }
        return root;
    }

    private static void renderSubtree(TreeElement parent, ClassLoaderVO parentClassLoader) {
        if (parentClassLoader.getChildren() == null) {
            return;
        }
        for (ClassLoaderVO childClassLoader : parentClassLoader.getChildren()) {
            TreeElement child = new TreeElement(childClassLoader.getName());
            parent.addChild((Element)child);
            ClassLoaderView.renderSubtree(child, childClassLoader);
        }
    }
}

