/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.express.Express;
import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.express.ExpressFactory;
import com.taobao.arthas.core.command.model.ClassLoaderVO;
import com.taobao.arthas.core.command.model.ObjectVO;
import com.taobao.arthas.core.command.model.OgnlModel;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ClassLoaderUtils;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.instrument.Instrumentation;
import java.util.List;

@Name(value="ognl")
@Summary(value="Execute ognl expression.")
@Description(value="\nEXAMPLES:\n  ognl '@java.lang.System@out.println(\"hello \\u4e2d\\u6587\")' \n  ognl -x 2 '@Singleton@getInstance()' \n  ognl '@Demo@staticFiled' \n  ognl '#value1=@System@getProperty(\"java.home\"), #value2=@System@getProperty(\"java.runtime.name\"), {#value1, #value2}'\n  ognl -c 5d113a51 '@com.taobao.arthas.core.GlobalOptions@isDump' \n\nWIKI:\n  https://arthas.aliyun.com/doc/ognl\n  https://commons.apache.org/proper/commons-ognl/language-guide.html")
public class OgnlCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(OgnlCommand.class);
    private String express;
    private String hashCode;
    private String classLoaderClass;
    private int expand = 1;

    @Argument(argName="express", index=0, required=true)
    @Description(value="The ognl expression.")
    public void setExpress(String express) {
        this.express = express;
    }

    @Option(shortName="c", longName="classLoader")
    @Description(value="The hash code of the special class's classLoader, default classLoader is SystemClassLoader.")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Option(longName="classLoaderClass")
    @Description(value="The class name of the special class's classLoader.")
    public void setClassLoaderClass(String classLoaderClass) {
        this.classLoaderClass = classLoaderClass;
    }

    @Option(shortName="x", longName="expand")
    @Description(value="Expand level of object (1 by default).")
    public void setExpand(Integer expand) {
        this.expand = expand;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(CommandProcess process) {
        ClassLoader classLoader;
        block9: {
            Instrumentation inst = process.session().getInstrumentation();
            classLoader = null;
            if (this.hashCode != null) {
                classLoader = ClassLoaderUtils.getClassLoader(inst, this.hashCode);
                if (classLoader == null) {
                    process.end(-1, "Can not find classloader with hashCode: " + this.hashCode + ".");
                    return;
                }
            } else {
                if (this.classLoaderClass != null) {
                    List<ClassLoader> matchedClassLoaders = ClassLoaderUtils.getClassLoaderByClassName(inst, this.classLoaderClass);
                    if (matchedClassLoaders.size() == 1) {
                        classLoader = matchedClassLoaders.get(0);
                        break block9;
                    } else {
                        if (matchedClassLoaders.size() > 1) {
                            List<ClassLoaderVO> classLoaderVOList = ClassUtils.createClassLoaderVOList(matchedClassLoaders);
                            OgnlModel ognlModel = new OgnlModel().setClassLoaderClass(this.classLoaderClass).setMatchedClassLoaders(classLoaderVOList);
                            process.appendResult(ognlModel);
                            process.end(-1, "Found more than one classloader by class name, please specify classloader with '-c <classloader hash>'");
                            return;
                        }
                        process.end(-1, "Can not find classloader by class name: " + this.classLoaderClass + ".");
                        return;
                    }
                }
                classLoader = ClassLoader.getSystemClassLoader();
            }
        }
        Express unpooledExpress = ExpressFactory.unpooledExpress(classLoader);
        try {
            Object value = unpooledExpress.bind(new Object()).get(this.express);
            OgnlModel ognlModel = new OgnlModel().setValue(new ObjectVO(value, Integer.valueOf(this.expand)));
            process.appendResult(ognlModel);
            process.end();
            return;
        }
        catch (ExpressException e) {
            logger.warn("ognl: failed execute express: " + this.express, (Throwable)e);
            process.end(-1, "Failed to execute ognl, exception message: " + e.getMessage() + ", please check $HOME/logs/arthas/arthas.log for more details. ");
        }
    }
}

