/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

public class ThreadLocalWatch {
    private static final int DEFAULT_STACK_SIZE = 4096;
    private final ThreadLocal<long[]> timestampRef = ThreadLocal.withInitial(() -> new long[4097]);

    public long start() {
        long timestamp = System.nanoTime();
        ThreadLocalWatch.push(this.timestampRef.get(), timestamp);
        return timestamp;
    }

    public long cost() {
        return System.nanoTime() - ThreadLocalWatch.pop(this.timestampRef.get());
    }

    public double costInMillis() {
        return (double)(System.nanoTime() - ThreadLocalWatch.pop(this.timestampRef.get())) / 1000000.0;
    }

    static void push(long[] stack, long value) {
        int pos = (int)stack[0];
        int cap = stack.length - 1;
        pos = pos < cap ? ++pos : 1;
        stack[pos] = value;
        stack[0] = pos;
    }

    static long pop(long[] stack) {
        int cap = stack.length - 1;
        int pos = (int)stack[0];
        if (pos > 0) {
            long value = stack[pos];
            stack[0] = pos - 1;
            return value;
        }
        pos = cap;
        long value = stack[pos];
        stack[0] = pos - 1;
        return value;
    }
}

